/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.yoko.orb.OCI.ConnectCB;
import org.apache.yoko.orb.OCI.IIOP.ConnectorInfo;
import org.apache.yoko.orb.OCI.IIOP.Exceptions;
import org.apache.yoko.orb.OCI.IIOP.Util;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.omg.CORBA.LocalObject;

public final class ConnectorInfo_impl
extends LocalObject
implements ConnectorInfo {
    private final String host;
    private final short port;
    private volatile InetAddress addr;
    private final List<ConnectCB> callbacks;

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public String describe() {
        return String.format("id: %s%nremote address: %s:%d", "iiop", this.remote_addr(), this.port);
    }

    @Override
    public String remote_addr() {
        return this.getInetAddress().getHostAddress();
    }

    @Override
    public short remote_port() {
        return this.port;
    }

    ConnectorInfo_impl(String host, int port, ConnectCB ... cb) {
        this.host = host;
        this.port = (short)port;
        this.callbacks = cb == null || cb.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ConnectCB>(Arrays.asList(cb)));
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return (char)this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress getInetAddress() {
        if (this.addr == null) {
            ConnectorInfo_impl connectorInfo_impl = this;
            synchronized (connectorInfo_impl) {
                if (this.addr == null) {
                    try {
                        String h = Util.decodeHost(this.host);
                        this.addr = InetAddress.getByName(h);
                    }
                    catch (UnknownHostException ex) {
                        throw Exceptions.asCommFailure(ex);
                    }
                }
            }
        }
        return this.addr;
    }

    synchronized void _OB_callConnectCB(TransportInfo info) {
        for (ConnectCB cb : this.callbacks) {
            cb.connect_cb(info);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConnectorInfo_impl)) {
            return false;
        }
        ConnectorInfo_impl that = (ConnectorInfo_impl)other;
        return this.port == that.port && this.getInetAddress().equals(that.getInetAddress());
    }

    public int hashCode() {
        return 31 * this.port + this.getInetAddress().hashCode();
    }

    public String toString() {
        return "[" + this.host + ":" + this.port + "]";
    }
}

