/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.csi;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import org.apache.yoko.orb.csi.CSIInterceptorBase;
import org.apache.yoko.orb.csi.SecurityContext;
import org.apache.yoko.orb.csi.gssup.GSSUPPolicy;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.UserException;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.SASContextBody;
import org.omg.GSSUP.InitialContextToken;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.Security.DelegationDirective;
import org.omg.Security.RequiresSupports;
import org.omg.SecurityLevel2.DelegationDirectivePolicy;

public class CSIServerRequestInterceptor
extends CSIInterceptorBase
implements ServerRequestInterceptor {
    private static final Logger log = Logger.getLogger(CSIServerRequestInterceptor.class.getName());

    CSIServerRequestInterceptor(Codec codec) {
        super(codec);
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        ServiceContext serviceContext;
        log.fine("receive_request_service_contexts " + ri.operation());
        if (CSIInterceptorBase.CallStatus.peekIsLocal()) {
            log.fine("local call");
            return;
        }
        boolean support_gssup_authorization = false;
        boolean require_gssup_authorization = false;
        String gssup_domain = null;
        try {
            GSSUPPolicy gp = (GSSUPPolicy)ri.get_server_policy(8080);
            if (gp == null) {
                log.fine("null GSSUPPolicy");
            } else {
                support_gssup_authorization = true;
                if (gp.mode() == RequiresSupports.SecRequires) {
                    require_gssup_authorization = true;
                }
                gssup_domain = gp.domain();
            }
        }
        catch (INV_POLICY ex) {
            log.log(Level.FINE, "no GSSUPPolicy", ex);
        }
        boolean support_gssup_principal_identity = false;
        try {
            DelegationDirective dir;
            DelegationDirectivePolicy delegate = (DelegationDirectivePolicy)ri.get_server_policy(38);
            if (delegate != null && (dir = delegate.delegation_directive()) == DelegationDirective.Delegate) {
                support_gssup_principal_identity = true;
            }
        }
        catch (INV_POLICY delegate) {
            // empty catch block
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("support gssup authorization: " + support_gssup_authorization);
            log.fine("require gssup authorization: " + require_gssup_authorization);
            log.fine("support gssup identity: " + support_gssup_principal_identity);
        }
        try {
            serviceContext = ri.get_request_service_context(15);
        }
        catch (BAD_PARAM ex) {
            serviceContext = null;
        }
        log.fine("Received request service context: " + serviceContext);
        if (require_gssup_authorization && serviceContext == null) {
            throw new NO_PERMISSION("GSSUP authorization required (missing SAS EstablishContext message)");
        }
        SASContextBody sasBody = null;
        if (serviceContext != null) {
            sasBody = this.decodeSASContextBody(serviceContext);
            log.fine("received request of type " + sasBody.discriminator());
            switch (sasBody.discriminator()) {
                case 1: 
                case 4: {
                    log.severe("Unexpected message of type " + sasBody.discriminator());
                    throw new NO_PERMISSION("unexpected SAS message");
                }
                case 5: {
                    log.fine("MTMessageInContext");
                    throw new NO_PERMISSION("Stateful SAS not supported");
                }
                case 0: {
                    log.fine("MTEstablishContext");
                    this.acceptContext(ri, sasBody.establish_msg(), support_gssup_authorization, require_gssup_authorization, support_gssup_principal_identity, gssup_domain);
                }
            }
        }
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo ri) {
        if (CSIInterceptorBase.CallStatus.peekIsLocal()) {
            return;
        }
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.send_reply(ri);
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.send_reply(ri);
    }

    public String name() {
        return "CSI Server Interceptor";
    }

    void acceptContext(ServerRequestInfo ri, EstablishContext establishMsg, boolean support_gssup_authorization, boolean require_gssup_authorization, boolean support_gssup_principal_identity, String gssup_domain) {
        if (establishMsg.client_context_id != 0L) {
            log.severe("Stateful security contexts not supported");
            throw new NO_PERMISSION("Stateful security contexts not supported");
        }
        log.fine("accepting context...");
        if (support_gssup_authorization && establishMsg.identity_token.discriminator() == 0 && establishMsg.client_authentication_token.length > 0) {
            String realm;
            String name;
            InitialContextToken gssupToken = this.decodeGSSUPToken(establishMsg.client_authentication_token);
            String useratrealm = this.utf8decode(gssupToken.username);
            int idx = useratrealm.lastIndexOf(64);
            if (idx == -1) {
                name = useratrealm;
                realm = "default";
            } else {
                name = useratrealm.substring(0, idx);
                realm = useratrealm.substring(idx + 1);
            }
            if (!realm.equals(gssup_domain)) {
                this.returnContextError(ri, 1, 1);
                throw new NO_PERMISSION("bad domain: \"" + realm + "\"");
            }
            String password = this.utf8decode(gssupToken.password);
            log.fine("GSSUP initial context token name=" + name + "; realm=" + realm + "; password=" + password);
            try {
                Subject subject = SecurityContext.login(name, realm, password);
                SecurityContext.setAuthenticatedSubject(subject);
                log.fine("Login succeeded");
                this.returnCompleteEstablishContext(ri);
            }
            catch (LoginException ex) {
                log.log(Level.SEVERE, "Login failed", ex);
                this.returnContextError(ri, 1, 1);
                throw new NO_PERMISSION("login failed");
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Exception occured: ", ex);
            }
        } else {
            if (require_gssup_authorization) {
                this.returnContextError(ri, 1, 1);
                throw new NO_PERMISSION("GSSUP authorization required");
            }
            if (support_gssup_principal_identity && establishMsg.identity_token.discriminator() == 2) {
                String domain;
                Any aa;
                log.fine("accepting ITTPrincipalName");
                byte[] name = establishMsg.identity_token.principal_name();
                try {
                    aa = this.codec.decode_value(name, OctetSeqHelper.type());
                }
                catch (UserException e) {
                    MARSHAL me = new MARSHAL("cannot decode security descriptor", 0, CompletionStatus.COMPLETED_NO);
                    me.initCause((Throwable)e);
                    throw me;
                }
                byte[] exported_name = OctetSeqHelper.extract((Any)aa);
                String userAtDomain = this.decodeGSSExportedName(exported_name);
                log.fine("establish ITTPrincipalName " + userAtDomain);
                int idx = userAtDomain.indexOf(64);
                String user = "";
                if (idx == -1) {
                    user = userAtDomain;
                    domain = "default";
                } else {
                    user = userAtDomain.substring(0, idx);
                    domain = userAtDomain.substring(idx + 1);
                }
                if (gssup_domain != null && !domain.equals(gssup_domain)) {
                    this.returnContextError(ri, 1, 1);
                    log.warning("request designates wrong domain: " + userAtDomain);
                    throw new NO_PERMISSION("bad domain");
                }
                Subject subject = SecurityContext.delegate(user, domain);
                SecurityContext.setAuthenticatedSubject(subject);
                this.returnCompleteEstablishContext(ri);
            } else if (establishMsg.identity_token.discriminator() == 1) {
                log.fine("accepting ITTAnonymous");
                try {
                    Subject subject = SecurityContext.anonymousLogin();
                    SecurityContext.setAuthenticatedSubject(subject);
                }
                catch (LoginException subject) {
                    // empty catch block
                }
                this.returnCompleteEstablishContext(ri);
            } else if (establishMsg.identity_token.discriminator() == 8) {
                Any aa;
                log.fine("accepting ITTDistinguishedName");
                byte[] name_data = establishMsg.identity_token.dn();
                try {
                    aa = this.codec.decode_value(name_data, OctetSeqHelper.type());
                }
                catch (UserException e) {
                    MARSHAL me = new MARSHAL("cannot encode security descriptor", 0, CompletionStatus.COMPLETED_NO);
                    me.initCause((Throwable)e);
                    throw me;
                }
                byte[] x500name_data = OctetSeqHelper.extract((Any)aa);
                try {
                    Subject subject = new Subject();
                    subject.getPrincipals().add(new X500Principal(x500name_data));
                    SecurityContext.setAuthenticatedSubject(subject);
                }
                catch (IllegalArgumentException ex) {
                    log.log(Level.FINE, "cannot decode X500 name", ex);
                    this.returnContextError(ri, 1, 1);
                    throw new NO_PERMISSION("cannot decode X500 name");
                }
                this.returnCompleteEstablishContext(ri);
            } else {
                this.returnContextError(ri, 2, 1);
                throw new NO_PERMISSION("Unsupported IdentityToken");
            }
        }
    }

    void returnCompleteEstablishContext(ServerRequestInfo ri) {
        SASContextBody sasBody = new SASContextBody();
        CompleteEstablishContext completeMsg = new CompleteEstablishContext();
        completeMsg.client_context_id = 0L;
        completeMsg.context_stateful = false;
        completeMsg.final_context_token = EMPTY_BARR;
        sasBody.complete_msg(completeMsg);
        log.fine("Adding SASContextBody, discriminator = " + sasBody.discriminator());
        ri.add_reply_service_context(this.encodeSASContextBody(sasBody), true);
    }

    void returnContextError(ServerRequestInfo ri, int major, int minor) {
        SASContextBody sasBody = new SASContextBody();
        ContextError errorMsg = new ContextError();
        errorMsg.client_context_id = 0L;
        errorMsg.major_status = major;
        errorMsg.minor_status = minor;
        errorMsg.error_token = EMPTY_BARR;
        sasBody.error_msg(errorMsg);
        log.fine("Adding SASContextBody, discriminator = " + sasBody.discriminator());
        ri.add_reply_service_context(this.encodeSASContextBody(sasBody), true);
    }

    public void destroy() {
    }
}

