/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal.injection;

import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSHome;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ejbcontainer.injection.factory.EJBLinkObjectFactory;
import com.ibm.ws.ejbcontainer.osgi.EJBHomeRuntime;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ObjectFactory.class, EJBLinkObjectFactoryImpl.class})
public class EJBLinkObjectFactoryImpl
extends EJBLinkObjectFactory {
    private static final TraceComponent tc = Tr.register(EJBLinkObjectFactoryImpl.class);
    private volatile boolean homeRuntime;
    static final long serialVersionUID = -2696570273186922378L;

    @Reference(service=LibertyProcess.class, target="(wlp.process.type=server)")
    protected void setLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    protected void unsetLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    @Reference(service=EJBHomeRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = true;
    }

    protected void unsetEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = false;
    }

    @Override
    public void checkHomeSupported(EJSHome home, String homeInterface) throws EJBNotFoundException {
        if (!this.homeRuntime) {
            J2EEName j2eeName = home.getJ2EEName();
            String appName = j2eeName.getApplication();
            String moduleName = j2eeName.getModule();
            String ejbName = j2eeName.getComponent();
            String msgTxt = Tr.formatMessage((TraceComponent)tc, (String)"INJECTION_CANNOT_INSTANTIATE_HOME_CNTR4011E", (Object[])new Object[]{homeInterface, ejbName, moduleName, appName});
            throw new EJBNotFoundException(msgTxt);
        }
    }
}

