/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.apache.yoko.rmi.api.PortableRemoteObjectExt;
import org.apache.yoko.rmi.api.PortableRemoteObjectState;
import org.apache.yoko.rmi.impl.PortableRemoteObjectImpl;
import org.apache.yoko.rmi.impl.RMIServant;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.util.NodeleteSynchronizedMap;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;

public class RMIState
implements PortableRemoteObjectState {
    static final Logger logger = Logger.getLogger(RMIState.class.getName());
    private boolean isShutdown;
    private final ORB _orb;
    private String _name;
    final TypeRepository repo = TypeRepository.get();
    private POA poa;
    Map stub_map = new NodeleteSynchronizedMap(){

        @Override
        public Map initialValue() {
            return new HashMap();
        }
    };
    Map tie_map = Collections.synchronizedMap(new IdentityHashMap());
    private Map static_stub_map = new NodeleteSynchronizedMap(){

        @Override
        public Map initialValue() {
            return new HashMap();
        }
    };
    private URL _codebase;

    POA getPOA() {
        return this.poa;
    }

    RMIState(ORB orb, String name) {
        if (orb == null) {
            throw new NullPointerException("ORB is null");
        }
        try {
            POA rootPoa = (POA)orb.resolve_initial_references("RootPOA");
            this.poa = rootPoa.create_POA(name, null, new Policy[0]);
            this.poa.the_POAManager().activate();
        }
        catch (AdapterAlreadyExists e) {
            logger.log(Level.WARNING, "Adapter already exists", e);
        }
        catch (InvalidPolicy e) {
            logger.log(Level.WARNING, "Invalid policy", e);
        }
        catch (InvalidName e) {
            logger.log(Level.WARNING, "Invalid name", e);
        }
        catch (AdapterInactive e) {
            logger.log(Level.WARNING, "Adapter inactive", e);
        }
        this._orb = orb;
        this._name = name;
    }

    void checkShutDown() {
        if (this.isShutdown) {
            BAD_INV_ORDER ex = new BAD_INV_ORDER("RMIState has already been shut down");
            logger.fine("RMIState has already been shut down " + (Object)((Object)ex));
            throw ex;
        }
    }

    @Override
    public void shutdown() {
        logger.finer("RMIState shutdown requested; name = " + this._name);
        this.checkShutDown();
        this.isShutdown = true;
    }

    @Override
    public ORB getORB() {
        return this._orb;
    }

    Delegate createDelegate(RMIServant servant) {
        ObjectImpl ref;
        this.checkShutDown();
        byte[] id = servant._id;
        RemoteDescriptor desc = servant._descriptor;
        String repid = desc.getRepositoryID();
        try {
            POA poa = this.getPOA();
            ref = (ObjectImpl)poa.create_reference_with_id(id, repid);
        }
        catch (BAD_PARAM ex) {
            throw (InternalError)new InternalError("wrong policy: " + ex.getMessage()).initCause(ex);
        }
        return ref._get_delegate();
    }

    static RMIState current() {
        return (RMIState)PortableRemoteObjectExt.getState();
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader;
    }

    public void setCodeBase(URL codebase) {
        this._codebase = codebase;
    }

    public URL getCodeBase() {
        return this._codebase;
    }

    void clearState() {
        this.stub_map = null;
        this.tie_map = null;
        this.static_stub_map = null;
    }

    public Stub getStaticStub1(String codebase, Class type) {
        return null;
    }

    public Stub getStaticStub(String codebase, Class type) {
        StaticStubEntry ent = (StaticStubEntry)this.static_stub_map.get(type);
        if (ent == null) {
            ent = new StaticStubEntry();
            Constructor cons = this.findConstructor(codebase, this.getNewStubClassName(type));
            if (cons != null && !Stub.class.isAssignableFrom(cons.getDeclaringClass())) {
                logger.fine("class " + cons.getDeclaringClass() + " is not a javax.rmi.CORBA.Stub");
                cons = null;
            }
            if (cons == null) {
                cons = this.findConstructor(codebase, this.getOldStubClassName(type));
            }
            if (cons != null && !Stub.class.isAssignableFrom(cons.getDeclaringClass())) {
                logger.fine("class " + cons.getDeclaringClass() + " is not a javax.rmi.CORBA.Stub");
                cons = null;
            }
            ent.stub_constructor = cons;
            this.static_stub_map.put(type, ent);
        }
        if (ent.stub_constructor == null) {
            return null;
        }
        try {
            return (Stub)ent.stub_constructor.newInstance(PortableRemoteObjectImpl.NO_ARG);
        }
        catch (ClassCastException ex) {
            logger.log(Level.FINE, "loaded class " + ent.stub_constructor.getDeclaringClass() + " is not a proper stub", ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.FINE, "cannot instantiate stub class for " + type + " :: " + ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            logger.log(Level.FINE, "cannot instantiate stub class for " + type + " :: " + ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            logger.log(Level.FINE, "cannot instantiate stub class for " + type + " :: " + ex.getCause(), ex.getCause());
        }
        return null;
    }

    private Constructor findConstructor(String codebase, String stubName) {
        try {
            Class stubClass = Util.loadClass((String)stubName, (String)codebase, (ClassLoader)this.getClassLoader());
            return stubClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            logger.log(Level.WARNING, "stub class " + stubName + " has no default constructor", ex);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINE, "failed to load remote class " + stubName + " from " + codebase, ex);
        }
        return null;
    }

    String getNewStubClassName(Class c) {
        String cname = c.getName();
        String pkgname = null;
        int idx = cname.lastIndexOf(46);
        pkgname = idx == -1 ? "org.omg.stub" : "org.omg.stub." + cname.substring(0, idx);
        String cplain = cname.substring(idx + 1);
        return pkgname + "._" + cplain + "_Stub";
    }

    String getOldStubClassName(Class c) {
        String cname = c.getName();
        int idx = cname.lastIndexOf(46);
        if (idx == -1) {
            return "_" + cname + "_Stub";
        }
        return cname.substring(0, idx + 1) + "_" + cname.substring(idx + 1) + "_Stub";
    }

    @Override
    public void exportObject(Remote remote) throws RemoteException {
        PortableRemoteObject.exportObject((Remote)remote);
    }

    @Override
    public void unexportObject(Remote remote) throws RemoteException {
        PortableRemoteObject.unexportObject((Remote)remote);
    }

    public String getName() {
        return this._name;
    }

    static class StaticStubEntry {
        Constructor stub_constructor;

        StaticStubEntry() {
        }
    }
}

