/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.jmx.connector.server.rest.notification.NotificationManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/notifications/{clientID}"})
public class NotificationClientHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(NotificationClientHandler.class);
    static final long serialVersionUID = 2095693011880030232L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (!RESTHelper.isDeleteMethod(method)) {
            throw new RESTHandlerMethodNotAllowedError("DELETE");
        }
        this.removeClient(request, response);
    }

    /*
     * WARNING - void declaration
     */
    private void removeClient(RESTRequest request, RESTResponse response) {
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationClientHandler", (String)"65", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        NotificationManager.getNotificationManager().cleanUp(request, clientID);
        response.setStatus(204);
    }
}

