/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.jms;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.jms.JMSContextInfo;
import com.ibm.ws.cdi.jms.JMSContextInjected;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.jms.JMSConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSPasswordCredential;
import javax.jms.JMSSessionMode;
import javax.naming.NamingException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JMSContextInjectionBean {
    static final long serialVersionUID = 7595160993763507627L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Produces
    public JMSContext getJMSContext(InjectionPoint injectionPoint) throws NamingException {
        String connectionFactoryString = "java:comp/DefaultJMSConnectionFactory";
        int acknowledgeMode = 1;
        String userName = null;
        String password = null;
        if (injectionPoint != null) {
            if (injectionPoint.getAnnotated().isAnnotationPresent(JMSConnectionFactory.class)) {
                JMSConnectionFactory jmsConnectionFactory = (JMSConnectionFactory)injectionPoint.getAnnotated().getAnnotation(JMSConnectionFactory.class);
                connectionFactoryString = jmsConnectionFactory.value();
            }
            if (injectionPoint.getAnnotated().isAnnotationPresent(JMSPasswordCredential.class)) {
                JMSPasswordCredential jmsPasswordCredential = (JMSPasswordCredential)injectionPoint.getAnnotated().getAnnotation(JMSPasswordCredential.class);
                userName = jmsPasswordCredential.userName();
                password = jmsPasswordCredential.password();
            }
            if (injectionPoint.getAnnotated().isAnnotationPresent(JMSSessionMode.class)) {
                JMSSessionMode jmsSessionMode = (JMSSessionMode)injectionPoint.getAnnotated().getAnnotation(JMSSessionMode.class);
                acknowledgeMode = jmsSessionMode.value();
            }
        }
        JMSContextInfo info = new JMSContextInfo(connectionFactoryString, userName, password, acknowledgeMode);
        return new JMSContextInjected(info);
    }

    public void closeJMSContext(@Disposes JMSContext context) {
        if (context instanceof JMSContextInjected) {
            ((JMSContextInjected)context).closeInternalJMSContext();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JMSContextInjectionBean.class);
    }
}

