/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.zip.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.zip.internal.ZipFileContainer;
import com.ibm.ws.artifact.zip.internal.ZipFileEntry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Set;
import java.util.zip.ZipEntry;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileEntryIterator
implements Iterator<ArtifactEntry> {
    private final ContainerFactoryHolder containerFactoryHolder;
    private final File archiveFile;
    private final ArtifactContainer enclosingContainer;
    private final ZipFileContainer rootContainer;
    private final String path;
    private final Set<String> pathSubSet = new HashSet<String>();
    private final Iterator<String> pathSubiter;
    private final NavigableMap<String, ZipEntry> allEntries;
    static final long serialVersionUID = 6008941607771380082L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ZipFileEntryIterator(ZipFileContainer zc, ArtifactContainer c, File f, NavigableMap<String, ZipEntry> allEntries, String absolutePath, ContainerFactoryHolder cfh) {
        String lastKey;
        String firstKey;
        this.enclosingContainer = c;
        this.rootContainer = zc;
        this.archiveFile = f;
        this.path = absolutePath;
        this.allEntries = allEntries;
        this.containerFactoryHolder = cfh;
        String rootPath = this.path.substring(1);
        boolean includeLast = false;
        boolean includeFirst = false;
        if (this.path.length() == 1) {
            firstKey = (String)allEntries.firstKey();
            lastKey = (String)allEntries.lastKey();
            includeFirst = true;
            includeLast = true;
        } else {
            firstKey = rootPath;
            lastKey = firstKey + 0;
        }
        for (String e : allEntries.subMap(firstKey, includeFirst, lastKey, includeLast).keySet()) {
            String name = PathUtils.getChildUnder((String)e, (String)rootPath);
            this.pathSubSet.add(name);
        }
        this.pathSubiter = this.pathSubSet.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.pathSubiter.hasNext();
    }

    @Override
    public ArtifactEntry next() {
        String name = this.pathSubiter.next();
        String pathAndName = this.path;
        if (this.path.length() > 1) {
            pathAndName = pathAndName + '/';
        }
        String absolutePath = pathAndName = pathAndName + name;
        ZipEntry ze = (ZipEntry)this.allEntries.get(pathAndName = pathAndName.substring(1));
        if (ze != null) {
            return new ZipFileEntry(this.rootContainer, ze, name, absolutePath, this.archiveFile, this.allEntries, this.containerFactoryHolder);
        }
        return new ZipFileEntry(this.rootContainer, null, name, absolutePath, this.archiveFile, this.allEntries, this.containerFactoryHolder);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ZipFileEntryIterator.class);
    }
}

