/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.frames.utils;

public abstract class Frame {
    protected static final TraceComponent tc = Tr.register(Frame.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    protected int streamId;
    protected int payloadLength;
    FrameDirection direction;
    protected byte flags;
    protected boolean reservedBit;
    protected FrameTypes frameType;
    public static final int SIZE_FRAME_BEFORE_PAYLOAD = 9;
    protected boolean END_STREAM_FLAG;
    protected boolean END_HEADERS_FLAG;
    protected boolean PADDED_FLAG;
    protected boolean PRIORITY_FLAG;
    protected boolean ACK_FLAG;
    protected boolean initialized;

    public Frame(int streamId, int payloadLength, byte flags, boolean reserveBit, FrameDirection direction) {
        this.streamId = streamId;
        this.payloadLength = payloadLength;
        this.flags = flags;
        this.reservedBit = reserveBit;
        this.initialized = false;
        this.direction = direction;
        this.setFlags();
    }

    public abstract void validate(H2ConnectionSettings var1) throws Http2Exception;

    public abstract void processPayload(FrameReadProcessor var1) throws FrameSizeException;

    protected abstract void setFlags();

    protected byte[] createFrameArray() {
        return new byte[9 + this.payloadLength];
    }

    protected void setFrameHeaders(byte[] frame, byte type) {
        utils.Move24BitstoByteArray(this.payloadLength, frame, 0);
        frame[3] = type;
        frame[4] = 0;
        if (this.PADDED_FLAG) {
            frame[4] = (byte)(frame[4] | 8);
        }
        if (this.END_HEADERS_FLAG) {
            frame[4] = (byte)(frame[4] | 4);
        }
        if (this.ACK_FLAG | this.END_STREAM_FLAG) {
            frame[4] = (byte)(frame[4] | 1);
        }
        if (this.PRIORITY_FLAG) {
            frame[4] = (byte)(frame[4] | 0x20);
        }
        if (this.reservedBit) {
            utils.Move31BitstoByteArray(this.streamId, frame, 5);
        } else {
            utils.Move31BitstoByteArray(this.streamId, frame, 5);
        }
    }

    public byte[] buildFrameForWrite() {
        if (!this.initialized) {
            return null;
        }
        byte[] frame = this.createFrameArray();
        return frame;
    }

    public byte getFrameFlags() {
        return this.flags;
    }

    public boolean isReadFrame() {
        return this.direction == FrameDirection.READ;
    }

    public boolean isWriteFrame() {
        return this.direction == FrameDirection.WRITE;
    }

    public boolean getFrameReserveBit() {
        return this.reservedBit;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setInitialized() {
        this.initialized = true;
    }

    public boolean getInitialized() {
        return this.initialized;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public FrameTypes getFrameType() {
        return this.frameType;
    }

    public boolean flagEndStreamSet() {
        return this.END_STREAM_FLAG;
    }

    public boolean flagEndHeadersSet() {
        return this.END_HEADERS_FLAG;
    }

    public boolean flagPrioritySet() {
        return this.PRIORITY_FLAG;
    }

    public boolean flagAckSet() {
        return this.ACK_FLAG;
    }

    public boolean flagPaddingSet() {
        return this.PADDED_FLAG;
    }

    public boolean setAckFlag() {
        this.ACK_FLAG = true;
        return true;
    }

    public boolean flagPaddedSet() {
        return this.PADDED_FLAG;
    }

    public void setPaddedFlag() {
        this.PADDED_FLAG = true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Frame)) {
            return false;
        }
        Frame frameToCompare = (Frame)object;
        if (this.flagAckSet() != frameToCompare.flagAckSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.flagAckSet() = " + this.flagAckSet() + " frameToCompare.flagAckSet() = " + frameToCompare.flagAckSet()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.flagPrioritySet() != frameToCompare.flagPrioritySet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.flagPrioritySet() = " + this.flagPrioritySet() + " frameToCompare.flagPrioritySet() = " + frameToCompare.flagPrioritySet()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.flagEndStreamSet() != frameToCompare.flagEndStreamSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.flagEndStreamSet() = " + this.flagEndStreamSet() + " frameToCompare.flagEndStreamSet() = " + frameToCompare.flagEndStreamSet()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.flagEndHeadersSet() != frameToCompare.flagEndHeadersSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.flagEndHeadersSet() = " + this.flagEndHeadersSet() + " frameToCompare.flagEndHeadersSet() = " + frameToCompare.flagEndHeadersSet()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.flagPaddedSet() != frameToCompare.flagPaddedSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.flagPaddedSet() = " + this.flagPaddedSet() + " frameToCompare.flagPaddedSet() = " + frameToCompare.flagPaddedSet()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getFrameType() != frameToCompare.getFrameType()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getFrameType is false", (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getFrameReserveBit() != frameToCompare.getFrameReserveBit()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getFrameReserveBit is false", (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getPayloadLength() != frameToCompare.getPayloadLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getPayloadLength is false", (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getStreamId() != frameToCompare.getStreamId()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getStreamId is false", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append("\nFrameType: " + (Object)((Object)this.getFrameType()) + "\n");
        frameToString.append("FrameFlags:\n");
        frameToString.append(" FlagAckSet: ").append(this.flagAckSet()).append("\n");
        frameToString.append(" FlagPrioritySet: ").append(this.flagPrioritySet()).append("\n");
        frameToString.append(" FlagEndStreamSet: ").append(this.flagEndStreamSet()).append("\n");
        frameToString.append(" FlagEndHeadersSet: ").append(this.flagEndHeadersSet()).append("\n");
        frameToString.append(" FlagPaddedSet: ").append(this.flagPaddedSet()).append("\n");
        frameToString.append("FrameReserveBit: ").append(this.getFrameReserveBit()).append("\n");
        frameToString.append("PayloadLength: ").append(this.getPayloadLength()).append("\n");
        frameToString.append("StreamId: ").append(this.getStreamId()).append("\n");
        return frameToString.toString();
    }

    public static enum FrameDirection {
        WRITE,
        READ;

    }
}

