/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.DefaultMimeTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.http.mimetype"}, immediate=true, property={"service.vendor=IBM"})
public class DefaultMimeTypesImpl
implements DefaultMimeTypes {
    private static final TraceComponent tc = Tr.register(DefaultMimeTypesImpl.class);
    private static final String CFG_KEY_DEFAULT_TYPES = "defaultType";
    private static final String CFG_KEY_MIME_TYPES = "type";
    private volatile Map<String, String> extToType = Collections.emptyMap();
    static final long serialVersionUID = -2026124612738868934L;

    @Trivial
    @Activate
    protected void activate(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Activating", (Object[])new Object[0]);
        }
        this.modified(properties);
    }

    @Trivial
    @Deactivate
    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Deactivating, reason=" + reason), (Object[])new Object[0]);
        }
    }

    @Trivial
    @Modified
    protected void modified(Map<String, Object> properties) {
        HashMap<String, String> extensionMap = new HashMap<String, String>();
        String[] mimeTypeList = (String[])properties.get(CFG_KEY_DEFAULT_TYPES);
        this.processList(mimeTypeList, extensionMap);
        mimeTypeList = (String[])properties.get(CFG_KEY_MIME_TYPES);
        this.processList(mimeTypeList, extensionMap);
        this.extToType = extensionMap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Default mime configured", (Object[])new Object[]{properties, this.extToType});
        }
    }

    @Trivial
    private void processList(String[] mimeTypeList, Map<String, String> extensionMap) {
        if (mimeTypeList != null) {
            for (String mimeType : mimeTypeList) {
                int equalIndex = mimeType.indexOf(61);
                if (equalIndex == -1 || mimeType.length() <= equalIndex + 1) continue;
                String ext = mimeType.substring(0, equalIndex);
                String type = mimeType.substring(equalIndex + 1);
                extensionMap.put(ext, type);
            }
        }
    }

    @Override
    public String getType(String extension) {
        return this.extToType.get(extension);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.extToType + "]";
    }
}

