/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpCookie {
    private String myName = null;
    private String myValue = null;
    private int myVersion = 0;
    private String myComment = null;
    private String myDomain = null;
    private String myPath = null;
    private boolean mySecureFlag = false;
    private int myMaxAge = -1;
    private boolean myHttpOnlyFlag = false;
    private boolean myDiscardFlag = false;
    private Map<String, String> myAttrs = new HashMap<String, String>();
    static final long serialVersionUID = -4227267607381229310L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public HttpCookie(String name, String value) {
        this.myName = name;
        this.myValue = value;
    }

    public String getName() {
        return this.myName;
    }

    public String getValue() {
        return this.myValue;
    }

    public String getComment() {
        return this.myComment;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getDomain() {
        return this.myDomain;
    }

    public boolean isSecure() {
        return this.mySecureFlag;
    }

    public int getMaxAge() {
        return this.myMaxAge;
    }

    public void setAttribute(String name, String value) {
        this.myAttrs.put(name.toLowerCase(), value);
    }

    public String getAttribute(String name) {
        return this.myAttrs.get(name.toLowerCase());
    }

    public int getVersion() {
        return this.myVersion;
    }

    public void setVersion(int version) {
        if (0 != version && 1 != version) {
            throw new IllegalArgumentException("Incorrect version; " + version);
        }
        this.myVersion = version;
    }

    public void setComment(String comment) {
        this.myComment = comment;
    }

    public void setDomain(String domain) {
        this.myDomain = domain;
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    public void setSecure(boolean flag) {
        this.mySecureFlag = flag;
    }

    public void setMaxAge(int age) {
        this.myMaxAge = age;
    }

    public boolean isHttpOnly() {
        return this.myHttpOnlyFlag;
    }

    public void setHttpOnly(boolean flag) {
        this.myHttpOnlyFlag = flag;
    }

    public boolean isDiscard() {
        return this.myDiscardFlag;
    }

    public void setDiscard(boolean flag) {
        this.myDiscardFlag = flag;
    }

    public HttpCookie clone() {
        HttpCookie rc = new HttpCookie(this.myName, this.myValue);
        rc.setVersion(this.myVersion);
        rc.setPath(this.myPath);
        rc.setComment(this.myComment);
        rc.setDomain(this.myDomain);
        rc.setMaxAge(this.myMaxAge);
        rc.setSecure(this.mySecureFlag);
        rc.setHttpOnly(this.myHttpOnlyFlag);
        rc.setDiscard(this.myDiscardFlag);
        for (Map.Entry<String, String> entry : this.myAttrs.entrySet()) {
            rc.setAttribute(entry.getKey(), entry.getValue());
        }
        return rc;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(HttpCookie.class);
    }
}

