/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.concurrent;

import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import org.apache.yoko.util.KeyedFactory;
import org.apache.yoko.util.Sequential;
import org.apache.yoko.util.concurrent.ConcurrentFifo;
import org.apache.yoko.util.concurrent.PNode;
import org.apache.yoko.util.concurrent.VNode;
import org.apache.yoko.util.concurrent.WeakNode;

public class WeakConcurrentFifo<T>
extends ConcurrentFifo<T> {
    private final ReferenceQueue<T> refQueue = new ReferenceQueue();
    private final KeyedFactory<? super T, Runnable> cleanupFactory;

    WeakConcurrentFifo(KeyedFactory<? super T, Runnable> cleanupFactory) {
        this.cleanupFactory = Objects.requireNonNull(cleanupFactory);
    }

    @Override
    public int size() {
        this.cleanup();
        return super.size();
    }

    @Override
    public T peek() {
        this.cleanup();
        return super.peek();
    }

    @Override
    public Sequential.Place<T> put(T elem) {
        this.cleanup();
        return super.put(elem);
    }

    @Override
    public T remove() {
        this.cleanup();
        return super.remove();
    }

    @Override
    protected VNode<T> createNode(T elem) {
        return new WeakNode<T>(elem, this.refQueue, this.cleanupFactory.create(elem));
    }

    private void cleanup() {
        WeakNode wn;
        while ((wn = (WeakNode)this.refQueue.poll()) != null) {
            this.cleanup(wn);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanup(WeakNode<T> wn) {
        PNode<T> prev;
        while ((prev = wn.prev()) != null) {
            PNode<T> pNode = prev;
            synchronized (pNode) {
                if (wn.prev() == prev) {
                    WeakNode<T> weakNode = wn;
                    synchronized (weakNode) {
                        wn.delete();
                        this.size.decrementAndGet();
                        wn.cleanup.run();
                        return;
                    }
                }
            }
        }
        return;
    }
}

