/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javamail.internal.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.javamail.internal.injection.MailSessionResourceFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ResourceFactoryBuilder.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "creates.objectClass=javax.mail.Session"})
public class MailSessionResourceFactoryBuilder
implements ResourceFactoryBuilder {
    private static final TraceComponent tc = Tr.register(MailSessionResourceFactoryBuilder.class);
    private static final String ID = "id";
    private BundleContext bundleContext;
    static final long serialVersionUID = 6673689776101049878L;

    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{context});
        }
        this.bundleContext = context.getBundleContext();
    }

    public ResourceFactory createResourceFactory(Map<String, Object> props) throws Exception {
        Hashtable<String, Object> mailSessionSvcProps = new Hashtable<String, Object>();
        HashMap<String, Object> annotationProps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value = prop.getValue();
            annotationProps.put(prop.getKey(), value);
        }
        String application = (String)annotationProps.remove("application");
        String module = (String)annotationProps.remove("module");
        String component = (String)annotationProps.remove("component");
        String jndiName = (String)annotationProps.remove("jndiName");
        String description = (String)annotationProps.remove("description");
        String storeProtocol = (String)annotationProps.remove("storeProtocol");
        String transportProtocol = (String)annotationProps.remove("transportProtocol");
        String host = (String)annotationProps.remove("host");
        String user = (String)annotationProps.remove("user");
        String password = (String)annotationProps.remove("password");
        String from = (String)annotationProps.remove("from");
        String storeProtocolClass = (String)annotationProps.remove("storeProtocolClassName");
        String transportProtocolClass = (String)annotationProps.remove("transportProtocolClassName");
        String property = (String)annotationProps.remove("property");
        String mailSessionID = MailSessionResourceFactoryBuilder.getMailSessionID(application, module, component, jndiName);
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)ID, (String)mailSessionID));
        filter.insert(filter.length() - 1, '*');
        if (!this.removeExistingConfigurations(filter.toString())) {
            throw new IllegalArgumentException(mailSessionID);
        }
        mailSessionSvcProps.put("jndiName", jndiName);
        if (description != null) {
            mailSessionSvcProps.put("description", description);
        }
        if (storeProtocol != null) {
            mailSessionSvcProps.put("storeProtocol", storeProtocol);
        }
        if (transportProtocol != null) {
            mailSessionSvcProps.put("transportProtocol", transportProtocol);
        }
        if (host != null) {
            mailSessionSvcProps.put("host", host);
        }
        if (user != null) {
            mailSessionSvcProps.put("user", user);
        }
        if (password != null) {
            mailSessionSvcProps.put("password", password);
        }
        if (from != null) {
            mailSessionSvcProps.put("from", from);
        }
        if (storeProtocolClass != null) {
            mailSessionSvcProps.put("storeProtocolClassName", storeProtocolClass);
        }
        if (transportProtocolClass != null) {
            mailSessionSvcProps.put("transportProtocolClassName", transportProtocolClass);
        }
        if (property != null) {
            mailSessionSvcProps.put("property", property);
        }
        if (application != null) {
            mailSessionSvcProps.put("application", application);
            if (module != null) {
                mailSessionSvcProps.put("module", module);
                if (component != null) {
                    mailSessionSvcProps.put("component", component);
                }
            }
        }
        MailSessionResourceFactory mss = new MailSessionResourceFactory();
        mss.processProperties(mailSessionSvcProps);
        mss.createResource((ResourceRefInfo)null);
        return mss;
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{context});
        }
    }

    private static final String getMailSessionID(String application, String module, String component, String jndiName) {
        StringBuilder sb = new StringBuilder(jndiName.length() + 80);
        if (application != null) {
            sb.append("application").append('[').append(application).append(']').append('/');
            if (module != null) {
                sb.append("module").append('[').append(module).append(']').append('/');
                if (component != null) {
                    sb.append("component").append('[').append(component).append(']').append('/');
                }
            }
        }
        return sb.append("mailSessionID").append('[').append(jndiName).append(']').toString();
    }

    public final boolean removeExistingConfigurations(String filter) throws Exception {
        return true;
    }
}

