/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation;

import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.beanvalidation.AbstractBeanValidation;
import com.ibm.ws.beanvalidation.BeanValidationMetaData;
import com.ibm.ws.beanvalidation.OSGiBeanValidationScopeData;
import com.ibm.ws.beanvalidation.ValidatorFactoryAccessor;
import com.ibm.ws.beanvalidation.config.ValidationConfigurationFactory;
import com.ibm.ws.beanvalidation.config.ValidationConfigurationInterface;
import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.beanvalidation.service.BeanValidationExtensionHelper;
import com.ibm.ws.beanvalidation.service.BeanValidationRuntimeVersion;
import com.ibm.ws.beanvalidation.service.BeanValidationUsingClassLoader;
import com.ibm.ws.beanvalidation.service.ValidatorFactoryBuilder;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.bval.ValidationConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ModuleMetaDataListener.class, BeanValidationUsingClassLoader.class, BeanValidation.class}, immediate=true)
public class OSGiBeanValidationImpl
extends AbstractBeanValidation
implements ModuleMetaDataListener,
BeanValidationUsingClassLoader {
    private static final TraceComponent tc = Tr.register(OSGiBeanValidationImpl.class);
    private static final String REFERENCE_VALIDATION_CONFIG_FACTORY = "validationConfigFactory";
    private static final String REFERENCE_CLASSLOADING_SERVICE = "classLoadingService";
    private static final String REFERENCE_VALIDATOR_FACTORY_BUILDER = "ValidatorFactoryBuilder";
    private MetaDataSlot ivModuleMetaDataSlot;
    private final AtomicServiceReference<ValidationConfigurationFactory> validationConfigFactorySR = new AtomicServiceReference("validationConfigFactory");
    private final AtomicServiceReference<ClassLoadingService> classLoadingServiceSR = new AtomicServiceReference("classLoadingService");
    private final AtomicServiceReference<ValidatorFactoryBuilder> validatorFactoryBuilderSR = new AtomicServiceReference("ValidatorFactoryBuilder");
    private static final Version DEFAULT_VERSION = BeanValidationRuntimeVersion.VERSION_1_0;
    private Version runtimeVersion = DEFAULT_VERSION;
    private static final PrivilegedAction<ThreadContextAccessor> getThreadContextAccessorAction = new PrivilegedAction<ThreadContextAccessor>(){
        static final long serialVersionUID = -2198084351891221209L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public ThreadContextAccessor run() {
            return ThreadContextAccessor.getThreadContextAccessor();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = -3558677163357853871L;

    @Override
    public void registerValidatorFactory(ModuleMetaData mmd, ClassLoader cl, ValidatorFactory validatorFactory) {
        this.getValidatorFactory(mmd, cl, validatorFactory);
    }

    @Override
    @Trivial
    public ConstraintValidatorFactory getConstraintValidatorFactory(Configuration<?> config) {
        ValidationConfigurationFactory configFactory = (ValidationConfigurationFactory)this.validationConfigFactorySR.getServiceWithException();
        return configFactory.getConstraintValidatorFactoryOverride(config);
    }

    @Override
    @Trivial
    public ValidatorFactory getValidatorFactory(ModuleMetaData mmd) {
        return this.getValidatorFactory(mmd, null);
    }

    @Override
    public ValidatorFactory getValidatorFactory(ModuleMetaData mmd, ClassLoader loader) {
        return this.getValidatorFactory(mmd, loader, null);
    }

    private ValidatorFactory getValidatorFactory(ModuleMetaData mmd, ClassLoader loader, ValidatorFactory validatorFactoryToSave) {
        if (this.ivModuleMetaDataSlot == null) {
            throw new ValidationException("Validation not enabled for module " + mmd.getName() + "; MetaDataSlotService not active");
        }
        if (this.isBeanValidationVersion20()) {
            return this.getValidatorFactoryHVProvider(mmd);
        }
        return this.getValidatorFactoryApacheProvider(mmd, loader, validatorFactoryToSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory getValidatorFactoryHVProvider(ModuleMetaData mmd) {
        BeanValidationMetaData beanValMetaData = (BeanValidationMetaData)mmd.getMetaData(this.ivModuleMetaDataSlot);
        if (beanValMetaData == null) {
            throw new ValidationException("Validation not enabled for module " + mmd.getName());
        }
        ValidatorFactory vf = beanValMetaData.getValidatorFactory();
        if (vf == null) {
            BeanValidationMetaData beanValidationMetaData = beanValMetaData;
            synchronized (beanValidationMetaData) {
                vf = beanValMetaData.getValidatorFactory();
                if (vf == null) {
                    ValidatorFactoryBuilder validatorFactoryBuilder = (ValidatorFactoryBuilder)this.validatorFactoryBuilderSR.getServiceWithException();
                    vf = validatorFactoryBuilder.buildValidatorFactory(beanValMetaData.getModuleClassLoader(), beanValMetaData.getModuleUri());
                    beanValMetaData.setValidatorFactory(vf);
                    mmd.setMetaData(this.ivModuleMetaDataSlot, (Object)beanValMetaData);
                }
            }
        }
        if (vf == null) {
            throw new ValidationException("Validation not enabled for module " + mmd.getName());
        }
        return vf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ValidatorFactory getValidatorFactoryApacheProvider(ModuleMetaData mmd, ClassLoader loader, ValidatorFactory validatorFactoryToSave) {
        OSGiBeanValidationScopeData scopeData = (OSGiBeanValidationScopeData)mmd.getMetaData(this.ivModuleMetaDataSlot);
        if (scopeData == null) {
            throw new ValidationException("Validation not enabled for module " + mmd.getName());
        }
        ValidatorFactory vf = scopeData.ivValidatorFactory;
        if (vf == null) {
            OSGiBeanValidationScopeData oSGiBeanValidationScopeData = scopeData;
            synchronized (oSGiBeanValidationScopeData) {
                vf = scopeData.ivValidatorFactory;
                if (vf == null) {
                    if (scopeData.configuratorReleased && this.isBeanValidationVersion11OrGreater()) {
                        throw new ValidationException("the module is stopped, so either the ValidatorFactory has already been destroyed or it was never created");
                    }
                    if (loader != null && !((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).isThreadContextClassLoader(loader)) {
                        loader = this.createTCCL(loader);
                    }
                    ClassLoader origLoader = scopeData.setClassLoader(loader);
                    boolean createSuccessful = false;
                    ValidationConfigurationInterface bvalConfigurator = null;
                    try {
                        boolean canLookInAppClassPath;
                        ValidationConfig config = null;
                        try {
                            config = (ValidationConfig)scopeData.ivModuleContainer.adapt(ValidationConfig.class);
                        }
                        catch (UnableToAdaptException unableToAdaptException) {
                            void e;
                            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.beanvalidation.OSGiBeanValidationImpl", (String)"192", (Object)this, (Object[])new Object[]{mmd, loader, validatorFactoryToSave});
                            throw new ValidationException((Throwable)e);
                        }
                        boolean bVal11OrHigher = this.isBeanValidationVersion11OrGreater();
                        boolean bl = canLookInAppClassPath = !bVal11OrHigher || !BeanValidationExtensionHelper.IS_VALIDATION_CLASSLOADING_ENABLED;
                        if (config == null && canLookInAppClassPath) {
                            vf = ValidatorFactoryAccessor.getValidatorFactory(loader, bVal11OrHigher, validatorFactoryToSave != null);
                        } else {
                            ValidationConfigurationFactory configFactory = (ValidationConfigurationFactory)this.validationConfigFactorySR.getServiceWithException();
                            bvalConfigurator = configFactory.createValidationConfiguration(scopeData, config);
                            vf = ValidatorFactoryAccessor.getValidatorFactory(bvalConfigurator, validatorFactoryToSave != null);
                        }
                        if (validatorFactoryToSave != null) {
                            vf = validatorFactoryToSave;
                        }
                        scopeData.ivValidatorFactory = vf;
                        scopeData.configurator = bvalConfigurator;
                        createSuccessful = true;
                    }
                    finally {
                        if (loader != null) {
                            this.releaseLoader(loader);
                        }
                        scopeData.setClassLoader(origLoader);
                        if (!createSuccessful && bvalConfigurator != null) {
                            bvalConfigurator.release(null);
                        }
                    }
                }
            }
        }
        return vf;
    }

    @Override
    @Trivial
    public Validator getValidator(ComponentMetaData cmd) {
        ClassLoader tccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -665022786711479047L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        return this.getValidator(cmd.getModuleMetaData(), tccl);
    }

    @Override
    public Validator getValidator(ModuleMetaData mmd, ClassLoader loader) {
        ValidatorFactory vfactory = this.getValidatorFactory(mmd, loader);
        Validator validator = vfactory.getValidator();
        return validator;
    }

    private ClassLoader createTCCL(ClassLoader parentCL) {
        return ((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).createThreadContextClassLoader(parentCL);
    }

    @Override
    public void releaseLoader(ClassLoader tccl) {
        ((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).destroyThreadContextClassLoader(tccl);
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) {
        if (this.isBeanValidationVersion20()) {
            this.moduleMetaDataCreatedHVProvider(event);
        } else {
            this.moduleMetaDataCreatedApacheProvider(event);
        }
    }

    private void moduleMetaDataCreatedHVProvider(MetaDataEvent<ModuleMetaData> event) {
        ModuleMetaData mmd = (ModuleMetaData)event.getMetaData();
        Container container = event.getContainer();
        MetaDataSlot mmdSlot = this.ivModuleMetaDataSlot;
        if (mmdSlot == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MetaDataSlotService not active... skipping start module action", (Object[])new Object[]{mmd.getName()});
            }
            return;
        }
        BeanValidationMetaData beanValMetaData = (BeanValidationMetaData)mmd.getMetaData(this.ivModuleMetaDataSlot);
        if (beanValMetaData == null) {
            ExtendedModuleInfo moduleInfo = this.getModuleInfo(container);
            beanValMetaData = new BeanValidationMetaData(moduleInfo.getClassLoader(), moduleInfo.getURI());
            mmd.setMetaData(mmdSlot, (Object)beanValMetaData);
        }
    }

    private void moduleMetaDataCreatedApacheProvider(MetaDataEvent<ModuleMetaData> event) {
        Container container;
        ModuleMetaData mmd;
        block7: {
            ValidationConfig validationConfig = null;
            mmd = (ModuleMetaData)event.getMetaData();
            container = event.getContainer();
            try {
                validationConfig = (ValidationConfig)container.adapt(ValidationConfig.class);
                if (validationConfig != null) {
                    URL validationXmlUrl = container.getEntry(validationConfig.getDeploymentDescriptorPath()).getResource();
                    this.moduleValidationXMLs.put(mmd, validationXmlUrl);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("validation.xml found at: " + validationXmlUrl.getPath()), (Object[])new Object[0]);
                    }
                }
            }
            catch (UnableToAdaptException validationXmlUrl) {
                FFDCFilter.processException((Throwable)validationXmlUrl, (String)"com.ibm.ws.beanvalidation.OSGiBeanValidationImpl", (String)"336", (Object)this, (Object[])new Object[]{event});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)("Failed to find a valid validation.xml - will continue to start module: " + ((ModuleMetaData)event.getMetaData()).getJ2EEName()), (Object[])new Object[0]);
            }
        }
        MetaDataSlot mmdSlot = this.ivModuleMetaDataSlot;
        if (mmdSlot == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MetaDataSlotService not active... skipping start module action", (Object[])new Object[]{mmd.getName()});
            }
            return;
        }
        OSGiBeanValidationScopeData scopeData = (OSGiBeanValidationScopeData)mmd.getMetaData(this.ivModuleMetaDataSlot);
        if (scopeData == null) {
            scopeData = new OSGiBeanValidationScopeData(container);
            mmd.setMetaData(mmdSlot, (Object)scopeData);
        }
    }

    private void moduleMetaDataDestroyedHVProvider(MetaDataEvent<ModuleMetaData> event) {
        ModuleMetaData mmd = (ModuleMetaData)event.getMetaData();
        MetaDataSlot mmdSlot = this.ivModuleMetaDataSlot;
        if (mmdSlot == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MetaDataSlotService not active... skipping stop module action", (Object[])new Object[]{mmd.getName()});
            }
            return;
        }
        BeanValidationMetaData beanValMetaData = (BeanValidationMetaData)mmd.getMetaData(this.ivModuleMetaDataSlot);
        if (beanValMetaData != null) {
            ValidatorFactoryBuilder validatorFactoryBuilder = (ValidatorFactoryBuilder)this.validatorFactoryBuilderSR.getServiceWithException();
            validatorFactoryBuilder.closeValidatorFactory(beanValMetaData.getValidatorFactory());
            beanValMetaData.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleMetaDataDestroyedApacheProvider(MetaDataEvent<ModuleMetaData> event) {
        ModuleMetaData mmd = (ModuleMetaData)event.getMetaData();
        this.moduleValidationXMLs.remove(mmd);
        MetaDataSlot mmdSlot = this.ivModuleMetaDataSlot;
        if (mmdSlot == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MetaDataSlotService not active... skipping stop module action", (Object[])new Object[]{mmd.getName()});
            }
            return;
        }
        OSGiBeanValidationScopeData scopeData = (OSGiBeanValidationScopeData)mmd.getMetaData(mmdSlot);
        if (scopeData != null) {
            OSGiBeanValidationScopeData oSGiBeanValidationScopeData = scopeData;
            synchronized (oSGiBeanValidationScopeData) {
                ValidationConfigurationInterface configurator = scopeData.configurator;
                if (configurator != null) {
                    configurator.release(scopeData.ivValidatorFactory);
                }
                scopeData.classloader = null;
                scopeData.configuratorReleased = true;
                if (this.isBeanValidationVersion11OrGreater()) {
                    scopeData.configurator = null;
                    scopeData.ivValidatorFactory = null;
                }
            }
        }
        this.cleanBvalCache();
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        if (this.isBeanValidationVersion20()) {
            this.moduleMetaDataDestroyedHVProvider(event);
        } else {
            this.moduleMetaDataDestroyedApacheProvider(event);
        }
    }

    @Activate
    protected void activate(ComponentContext cc) {
        OSGiBeanValidationImpl.setInstance(this);
        this.classLoadingServiceSR.activate(cc);
        this.validationConfigFactorySR.activate(cc);
        this.validatorFactoryBuilderSR.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        OSGiBeanValidationImpl.setInstance(null);
        this.classLoadingServiceSR.deactivate(cc);
        this.validationConfigFactorySR.deactivate(cc);
        this.validatorFactoryBuilderSR.deactivate(cc);
    }

    @Reference
    protected void setMetaDataSlotService(MetaDataSlotService slotService) {
        this.ivModuleMetaDataSlot = slotService.reserveMetaDataSlot(ModuleMetaData.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : mmd slot=" + this.ivModuleMetaDataSlot), (Object[])new Object[0]);
        }
    }

    protected void unsetMetaDataSlotService(MetaDataSlotService slotService) {
        this.ivModuleMetaDataSlot = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetMetaDataSlotService", (Object[])new Object[0]);
        }
    }

    @Reference(service=BeanValidationRuntimeVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRuntimeVersion(ServiceReference<BeanValidationRuntimeVersion> ref) {
        this.runtimeVersion = Version.parseVersion((String)((String)ref.getProperty("version")));
    }

    protected void unsetRuntimeVersion(ServiceReference<BeanValidationRuntimeVersion> ref) {
        this.runtimeVersion = DEFAULT_VERSION;
    }

    @Reference(name="classLoadingService", service=ClassLoadingService.class)
    protected void setClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.setReference(ref);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.unsetReference(ref);
    }

    @Reference(name="ValidatorFactoryBuilder", service=ValidatorFactoryBuilder.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setValidatorFactoryBuilder(ServiceReference<ValidatorFactoryBuilder> ref) {
        this.validatorFactoryBuilderSR.setReference(ref);
    }

    protected void unsetValidatorFactoryBuilder(ServiceReference<ValidatorFactoryBuilder> ref) {
        this.validatorFactoryBuilderSR.unsetReference(ref);
    }

    @Reference(name="validationConfigFactory", service=ValidationConfigurationFactory.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setValidationConfigFactory(ServiceReference<ValidationConfigurationFactory> factoryRef) {
        this.validationConfigFactorySR.setReference(factoryRef);
    }

    protected void unsetValidationConfigFactory(ServiceReference<ValidationConfigurationFactory> factoryRef) {
        this.validationConfigFactorySR.unsetReference(factoryRef);
    }

    private boolean isBeanValidationVersion11OrGreater() {
        return this.runtimeVersion.compareTo(BeanValidationRuntimeVersion.VERSION_1_1) >= 0;
    }

    private boolean isBeanValidationVersion11() {
        return this.runtimeVersion.compareTo(BeanValidationRuntimeVersion.VERSION_1_1) == 0;
    }

    private boolean isBeanValidationVersion20() {
        return this.runtimeVersion.compareTo(BeanValidationRuntimeVersion.VERSION_2_0) == 0;
    }

    @Override
    public ClassLoader configureBvalClassloader(ClassLoader cl) {
        if (cl == null) {
            cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = -1687437955128942582L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        if (cl != null) {
            ClassLoadingService classLoadingService = (ClassLoadingService)this.classLoadingServiceSR.getServiceWithException();
            if (classLoadingService.isThreadContextClassLoader(cl)) {
                return cl;
            }
            if (classLoadingService.isAppClassLoader(cl)) {
                return this.createTCCL(cl);
            }
        }
        return this.createTCCL(AbstractBeanValidation.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanBvalCache() {
        if (this.isBeanValidationVersion11() && !FrameworkState.isStopping()) {
            boolean wasTcclCreated;
            ClassLoader classLoader;
            block16: {
                classLoader = null;
                SetContextClassLoaderPrivileged setClassLoader = null;
                ClassLoader oldClassLoader = null;
                wasTcclCreated = false;
                try {
                    classLoader = ((ValidationConfigurationFactory)this.validationConfigFactorySR.getServiceWithException()).getClass().getClassLoader();
                    if (classLoader != null && !((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).isThreadContextClassLoader(classLoader)) {
                        classLoader = this.createTCCL(classLoader);
                        wasTcclCreated = true;
                    }
                    ThreadContextAccessor tca = System.getSecurityManager() == null ? ThreadContextAccessor.getThreadContextAccessor() : AccessController.doPrivileged(getThreadContextAccessorAction);
                    setClassLoader = new SetContextClassLoaderPrivileged(tca);
                    oldClassLoader = setClassLoader.execute(classLoader);
                    if (classLoader == null) {
                        classLoader = oldClassLoader;
                    }
                    Class<?> clazz = classLoader.loadClass("org.apache.bval.jsr.ConstraintAnnotationAttributes");
                    final Field methodByNameAndClass = clazz.getDeclaredField("METHOD_BY_NAME_AND_CLASS");
                    if (System.getSecurityManager() == null) {
                        methodByNameAndClass.setAccessible(true);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){
                            static final long serialVersionUID = 8125148069441700412L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public Object run() {
                                methodByNameAndClass.setAccessible(true);
                                return null;
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(4.class);
                            }
                        });
                    }
                    Map methodMap = (Map)methodByNameAndClass.get(null);
                    methodMap.clear();
                    if (setClassLoader == null) break block16;
                }
                catch (Exception exception) {
                    block17: {
                        try {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.beanvalidation.OSGiBeanValidationImpl", (String)"581", (Object)this, (Object[])new Object[0]);
                            if (setClassLoader == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (setClassLoader != null) {
                                setClassLoader.execute(oldClassLoader);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                                }
                            }
                            if (classLoader != null && wasTcclCreated) {
                                this.releaseLoader(classLoader);
                            }
                            throw throwable;
                        }
                        setClassLoader.execute(oldClassLoader);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                        }
                    }
                    if (classLoader != null && wasTcclCreated) {
                        this.releaseLoader(classLoader);
                    }
                }
                setClassLoader.execute(oldClassLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                }
            }
            if (classLoader != null && wasTcclCreated) {
                this.releaseLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private ExtendedModuleInfo getModuleInfo(Container container) throws ValidationException {
        ExtendedModuleInfo moduleInfo = null;
        try {
            NonPersistentCache cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
            moduleInfo = (ExtendedModuleInfo)cache.getFromCache(ModuleInfo.class);
        }
        catch (UnableToAdaptException cache) {
            void e;
            FFDCFilter.processException((Throwable)cache, (String)"com.ibm.ws.beanvalidation.OSGiBeanValidationImpl", (String)"603", (Object)this, (Object[])new Object[]{container});
            throw new ValidationException((Throwable)e);
        }
        return moduleInfo;
    }
}

