/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.accessor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.validation.ValidatorFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BeanValidationAccessor {
    private static final TraceComponent tc = Tr.register(BeanValidationAccessor.class);
    static final long serialVersionUID = -8587341158558947065L;

    public static ValidatorFactory getValidatorFactory() {
        Bundle bundle = FrameworkUtil.getBundle(BeanValidationAccessor.class);
        BeanValidation bv = AccessController.doPrivileged(new GetServiceAction(bundle));
        if (bv != null) {
            ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (cmd != null) {
                return bv.getValidatorFactoryOrDefault(cmd);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to get ValidatorFactory because ComponentMetaData was null", (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unable to get ValidatorFactory because BeanValidation service was null", (Object[])new Object[0]);
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class GetServiceAction
    implements PrivilegedAction<BeanValidation> {
        private final Bundle bundle;
        static final long serialVersionUID = 1354734561875470104L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetServiceAction(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public BeanValidation run() {
            BundleContext bCtx = this.bundle.getBundleContext();
            ServiceReference svcRef = bCtx.getServiceReference(BeanValidation.class);
            return svcRef == null ? null : (BeanValidation)bCtx.getService(svcRef);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(GetServiceAction.class);
        }
    }
}

