/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class Validation20ClassLoader
extends ClassLoader {
    private static final TraceComponent tc = Tr.register(Validation20ClassLoader.class);
    String moduleHint;

    public Validation20ClassLoader(ClassLoader parent, String hint) {
        super(parent);
        this.moduleHint = hint;
    }

    @Override
    public Enumeration<URL> getResources(String resourceName) throws IOException {
        if (this.moduleHint != null && resourceName.equals("META-INF/validation.xml") || resourceName.equals("WEB-INF/validation.xml") || resourceName.equals("WEB-INF/classes/META-INF/validation.xml")) {
            ArrayList<URL> list = new ArrayList<URL>();
            URL url = this.getValidationXml(resourceName);
            if (url != null) {
                list.add(url);
            }
            return Collections.enumeration(list);
        }
        return super.getResources(resourceName);
    }

    @Override
    public URL getResource(String resourceName) {
        if (this.moduleHint != null && resourceName.equals("META-INF/validation.xml") || resourceName.equals("WEB-INF/validation.xml") || resourceName.equals("WEB-INF/classes/META-INF/validation.xml")) {
            try {
                return this.getValidationXml(resourceName);
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"IOException", (Object[])new Object[]{e});
                }
                return super.getResource(resourceName);
            }
        }
        if (this.moduleHint != null) {
            try {
                return this.getResourceWithHint(resourceName);
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"IOException", (Object[])new Object[]{e});
                }
                return super.getResource(resourceName);
            }
        }
        return super.getResource(resourceName);
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) {
        if (resourceName.equals("META-INF/validation.xml") || resourceName.equals("WEB-INF/validation.xml") || resourceName.equals("WEB-INF/classes/META-INF/validation.xml")) {
            InputStream is = super.getResourceAsStream(resourceName);
            if (is == null) {
                is = super.getResourceAsStream("WEB-INF/classes/META-INF/validation.xml");
            }
            return is;
        }
        return super.getResourceAsStream(resourceName);
    }

    private URL getValidationXml(String resourceName) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getValidationXml : " + resourceName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("moduleHint : " + this.moduleHint), (Object[])new Object[0]);
        }
        URL validationXml = null;
        ArrayList<URL> metaInfValidationXmlUrls = Collections.list(super.getResources(resourceName));
        for (URL aUrl : metaInfValidationXmlUrls) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("aUrl.getPath(): " + aUrl.getPath()), (Object[])new Object[0]);
            }
            if (!aUrl.getPath().contains(this.moduleHint)) continue;
            validationXml = aUrl;
        }
        ArrayList<URL> webInfValidationXmlUrls = null;
        if (validationXml == null) {
            webInfValidationXmlUrls = Collections.list(super.getResources("WEB-INF/validation.xml"));
            for (URL aUrl : webInfValidationXmlUrls) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("aUrl.getPath(): " + aUrl.getPath()), (Object[])new Object[0]);
                }
                if (!aUrl.getPath().contains(this.moduleHint)) continue;
                validationXml = aUrl;
            }
        }
        if (validationXml == null && metaInfValidationXmlUrls.size() == 1) {
            validationXml = (URL)metaInfValidationXmlUrls.get(0);
        }
        if (validationXml == null && webInfValidationXmlUrls != null && webInfValidationXmlUrls.size() == 1) {
            validationXml = (URL)webInfValidationXmlUrls.get(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getValidationXml is returning URL : " + validationXml), (Object[])new Object[0]);
        }
        return validationXml;
    }

    private URL getResourceWithHint(String resourceName) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getResourceWithHint : " + resourceName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("moduleHint : " + this.moduleHint), (Object[])new Object[0]);
        }
        URL resource = null;
        ArrayList<URL> resourceUrls = Collections.list(super.getResources(resourceName));
        for (URL aUrl : resourceUrls) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("aUrl.getPath(): " + aUrl.getPath()), (Object[])new Object[0]);
            }
            if (!aUrl.getPath().contains(this.moduleHint)) continue;
            resource = aUrl;
        }
        if (resource == null && resourceUrls.size() >= 1) {
            resource = (URL)resourceUrls.get(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getResourceWithHint is returning URL : " + resource), (Object[])new Object[0]);
        }
        return resource;
    }
}

