/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.cdi.AggregatedFTPolicy;
import com.ibm.ws.microprofile.faulttolerance.cdi.FaultTolerance;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.AsynchronousConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.BulkheadConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.CircuitBreakerConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.FTGlobalConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.FallbackConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.RetryConfig;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.TimeoutConfig;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException;
import com.ibm.ws.microprofile.faulttolerance.spi.Executor;
import com.ibm.ws.microprofile.faulttolerance.spi.FTExecutionContext;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

@FaultTolerance
@Interceptor
@Priority(value=1000)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FaultToleranceInterceptor {
    @Inject
    BeanManager beanManager;
    private final ConcurrentHashMap<Method, AggregatedFTPolicy> policyCache = new ConcurrentHashMap();
    static final long serialVersionUID = 9068286916195687200L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Inject
    public FaultToleranceInterceptor(ExecutorCleanup executorCleanup) {
        executorCleanup.setPolicies(this.policyCache.values());
    }

    @AroundInvoke
    public Object executeFT(InvocationContext context) throws Throwable {
        AggregatedFTPolicy policy = this.getFTPolicies(context);
        Object result = this.execute(context, policy);
        return result;
    }

    private AggregatedFTPolicy getFTPolicies(InvocationContext context) {
        AggregatedFTPolicy previous;
        AggregatedFTPolicy policy = null;
        Method method = context.getMethod();
        policy = this.policyCache.get(method);
        if (policy == null && (previous = this.policyCache.putIfAbsent(method, policy = this.processPolicies(context, this.beanManager))) != null) {
            policy = previous;
        }
        return policy;
    }

    private AggregatedFTPolicy processPolicies(InvocationContext context, BeanManager beanManager) {
        Annotation[] annotations;
        AsynchronousConfig asynchronous = null;
        RetryConfig retry = null;
        CircuitBreakerConfig circuitBreaker = null;
        TimeoutConfig timeout = null;
        BulkheadConfig bulkhead = null;
        FallbackConfig fallback = null;
        Class<?> targetClass = context.getTarget().getClass();
        for (Annotation annotation : annotations = targetClass.getAnnotations()) {
            if (!FTGlobalConfig.getActiveAnnotations(targetClass).contains(annotation.annotationType())) continue;
            if (annotation.annotationType().equals(Asynchronous.class)) {
                asynchronous = new AsynchronousConfig(targetClass, (Asynchronous)annotation);
                asynchronous.validate();
                continue;
            }
            if (annotation.annotationType().equals(Retry.class)) {
                retry = new RetryConfig(targetClass, (Retry)annotation);
                retry.validate();
                continue;
            }
            if (annotation.annotationType().equals(CircuitBreaker.class)) {
                circuitBreaker = new CircuitBreakerConfig(targetClass, (CircuitBreaker)annotation);
                circuitBreaker.validate();
                continue;
            }
            if (annotation.annotationType().equals(Timeout.class)) {
                timeout = new TimeoutConfig(targetClass, (Timeout)annotation);
                timeout.validate();
                continue;
            }
            if (!annotation.annotationType().equals(Bulkhead.class)) continue;
            bulkhead = new BulkheadConfig(targetClass, (Bulkhead)annotation);
            bulkhead.validate();
        }
        Method method = context.getMethod();
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (!FTGlobalConfig.getActiveAnnotations(targetClass).contains(annotation.annotationType())) continue;
            if (annotation.annotationType().equals(Asynchronous.class)) {
                asynchronous = new AsynchronousConfig(method, targetClass, (Asynchronous)annotation);
                asynchronous.validate();
                continue;
            }
            if (annotation.annotationType().equals(Retry.class)) {
                retry = new RetryConfig(method, targetClass, (Retry)annotation);
                retry.validate();
                continue;
            }
            if (annotation.annotationType().equals(CircuitBreaker.class)) {
                circuitBreaker = new CircuitBreakerConfig(method, targetClass, (CircuitBreaker)annotation);
                circuitBreaker.validate();
                continue;
            }
            if (annotation.annotationType().equals(Timeout.class)) {
                timeout = new TimeoutConfig(method, targetClass, (Timeout)annotation);
                timeout.validate();
                continue;
            }
            if (annotation.annotationType().equals(Bulkhead.class)) {
                bulkhead = new BulkheadConfig(method, targetClass, (Bulkhead)annotation);
                bulkhead.validate();
                continue;
            }
            if (!annotation.annotationType().equals(Fallback.class)) continue;
            fallback = new FallbackConfig(method, targetClass, (Fallback)annotation);
            fallback.validate();
        }
        AggregatedFTPolicy aggregatedFTPolicy = new AggregatedFTPolicy();
        if (asynchronous != null) {
            aggregatedFTPolicy.setAsynchronous(true);
        }
        if (timeout != null) {
            TimeoutPolicy timeoutPolicy = timeout.generatePolicy();
            aggregatedFTPolicy.setTimeoutPolicy(timeoutPolicy);
        }
        if (retry != null) {
            RetryPolicy retryPolicy = retry.generatePolicy();
            aggregatedFTPolicy.setRetryPolicy(retryPolicy);
        }
        if (circuitBreaker != null) {
            CircuitBreakerPolicy circuitBreakerPolicy = circuitBreaker.generatePolicy();
            aggregatedFTPolicy.setCircuitBreakerPolicy(circuitBreakerPolicy);
        }
        if (bulkhead != null) {
            BulkheadPolicy bulkheadPolicy = bulkhead.generatePolicy();
            aggregatedFTPolicy.setBulkheadPolicy(bulkheadPolicy);
        }
        if (fallback != null) {
            FallbackPolicy fallbackPolicy = fallback.generatePolicy(context, beanManager);
            aggregatedFTPolicy.setFallbackPolicy(fallbackPolicy);
        }
        return aggregatedFTPolicy;
    }

    @FFDCIgnore(value={ExecutionException.class})
    private Object execute(InvocationContext invocationContext, AggregatedFTPolicy aggregatedFTPolicy) throws Throwable {
        Object result = null;
        if (aggregatedFTPolicy != null) {
            Executor<?> executor = aggregatedFTPolicy.getExecutor();
            Method method = invocationContext.getMethod();
            Object[] params = invocationContext.getParameters();
            String id = method.getName();
            FTExecutionContext executionContext = executor.newExecutionContext(id, method, params);
            if (aggregatedFTPolicy.isAsynchronous()) {
                Callable<Future> callable = () -> (Future)invocationContext.proceed();
                Executor<?> async = executor;
                try {
                    result = async.execute(callable, (ExecutionContext)executionContext);
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
            } else {
                Callable<Object> callable = () -> invocationContext.proceed();
                Executor<?> sync = executor;
                try {
                    result = sync.execute(callable, (ExecutionContext)executionContext);
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
            }
        } else {
            result = invocationContext.proceed();
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FaultToleranceInterceptor.class);
    }

    @Dependent
    @TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class ExecutorCleanup {
        private static final TraceComponent tc = Tr.register(ExecutorCleanup.class);
        private Collection<AggregatedFTPolicy> policies;
        static final long serialVersionUID = -3872994025772282844L;

        public void setPolicies(Collection<AggregatedFTPolicy> policies) {
            this.policies = policies;
        }

        @PreDestroy
        public void cleanUpExecutors() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cleaning up executors", (Object[])new Object[0]);
            }
            this.policies.forEach(e -> e.close());
        }
    }
}

