/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.cdi.config.AbstractAnnotationConfig;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BulkheadConfig
extends AbstractAnnotationConfig<Bulkhead>
implements Bulkhead {
    private static final TraceComponent tc = Tr.register(BulkheadConfig.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Integer> valueConfig = this.getParameterConfig("value", Integer.class);
    private final AbstractAnnotationConfig.AnnotationParameterConfig<Integer> waitingTaskQueueConfig = this.getParameterConfig("waitingTaskQueue", Integer.class);
    static final long serialVersionUID = 7902104958867083131L;

    public BulkheadConfig(Class<?> annotatedClass, Bulkhead annotation) {
        super(annotatedClass, annotation, Bulkhead.class);
    }

    public BulkheadConfig(Method annotatedMethod, Class<?> annotatedClass, Bulkhead annotation) {
        super(annotatedMethod, annotatedClass, annotation, Bulkhead.class);
    }

    public int value() {
        return this.valueConfig.getValue();
    }

    public int waitingTaskQueue() {
        return this.waitingTaskQueueConfig.getValue();
    }

    @Override
    public void validate() {
        String target = this.getTargetName();
        if (this.value() < 1) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"bulkhead.parameter.invalid.value.CWMFT5016E", (Object[])new Object[]{"value ", this.value(), target}));
        }
        if (this.waitingTaskQueue() < 1) {
            throw new FaultToleranceDefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"bulkhead.parameter.invalid.value.CWMFT5016E", (Object[])new Object[]{"waitingTaskQueue", this.waitingTaskQueue(), target}));
        }
    }

    public BulkheadPolicy generatePolicy() {
        int maxThreads = this.value();
        int queueSize = this.waitingTaskQueue();
        BulkheadPolicy bulkheadPolicy = FaultToleranceProvider.newBulkheadPolicy();
        bulkheadPolicy.setMaxThreads(maxThreads);
        bulkheadPolicy.setQueueSize(queueSize);
        return bulkheadPolicy;
    }
}

