/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.ParametersOfInterest;
import com.ibm.ws.wsoc.external.ExtensionExt;
import com.ibm.ws.wsoc.external.HandshakeRequestExt;
import com.ibm.ws.wsoc.external.HandshakeResponseExt;
import com.ibm.ws.wsoc.external.ParameterExt;
import com.ibm.ws.wsoc.util.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HandshakeProcessor {
    private static final TraceComponent tc = Tr.register(HandshakeProcessor.class);
    private String headerHost = null;
    private String headerUpgrade = null;
    private String headerConnection = null;
    private String headerSecWebSocketKey = null;
    private String headerOrigin = null;
    private String headerSecWebSocketProtocol = null;
    private String headerSecWebSocketVersion = null;
    private String[] clientSubProtocols = null;
    private List<Extension> clientExtensions = null;
    private List<Extension> configuredExtensions = null;
    private static final String subProtocolDelimiter = ",";
    private final Map<String, List<String>> requestHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, List<String>> parameterMap = new HashMap<String, List<String>>();
    private URI requestURI = null;
    private HttpServletResponse httpResponse = null;
    private HttpServletRequest httpRequest = null;
    private Map<String, String> extraParamMap = null;
    private ServerEndpointConfig endpointConfig = null;
    private ServerEndpointConfig.Configurator endpointConfigurator = null;
    private final ParametersOfInterest things = new ParametersOfInterest();
    static final long serialVersionUID = 7226934893693822208L;

    public void initialize(HttpServletRequest _hsr, HttpServletResponse resp, Map<String, String> extraParams) {
        this.httpRequest = _hsr;
        this.httpResponse = resp;
        this.extraParamMap = extraParams;
    }

    public void addWsocConfigurationData(ServerEndpointConfig _config, ServerEndpointConfig.Configurator _configurator) {
        this.endpointConfig = _config;
        this.endpointConfigurator = _configurator;
    }

    public ParametersOfInterest getParametersOfInterest() {
        return this.things;
    }

    public void readRequestInfo() throws Exception {
        String s;
        Enumeration names = this.httpRequest.getHeaderNames();
        Map paramMap = this.httpRequest.getParameterMap();
        for (Map.Entry entry : paramMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] value = (String[])entry.getValue();
            List<String> list = Arrays.asList(value);
            this.parameterMap.put(key, list);
        }
        if (this.extraParamMap != null) {
            for (String key : this.extraParamMap.keySet()) {
                this.parameterMap.put(key, Arrays.asList(this.extraParamMap.get(key)));
            }
        }
        this.requestURI = new URI(this.httpRequest.getRequestURI());
        this.things.setParameterMap(this.parameterMap);
        this.things.setQueryString(this.httpRequest.getQueryString());
        this.things.setURI(this.requestURI);
        this.things.setUserPrincipal(this.httpRequest.getUserPrincipal());
        boolean secure = this.httpRequest.isSecure();
        if (!secure && (s = this.httpRequest.getAuthType()) != null && s.equalsIgnoreCase("BASIC")) {
            secure = true;
        }
        this.things.setSecure(secure);
        this.things.setHttpSession(this.httpRequest.getSession());
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration headerValues = this.httpRequest.getHeaders(name);
            ArrayList<String> list = Collections.list(headerValues);
            this.requestHeaders.put(name, list);
            String headerValue = this.httpRequest.getHeader(name);
            String compName = name.trim();
            if (compName.compareToIgnoreCase("Host") == 0) {
                this.headerHost = headerValue;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("host header has a value of:  " + this.headerHost), (Object[])new Object[0]);
                continue;
            }
            if (compName.compareToIgnoreCase("Upgrade") == 0) {
                this.headerUpgrade = headerValue;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("upgrade header has a value of:  " + this.headerUpgrade), (Object[])new Object[0]);
                continue;
            }
            if (compName.compareToIgnoreCase("Connection") == 0) {
                this.headerConnection = headerValue;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("connection header has a value of:  " + this.headerConnection), (Object[])new Object[0]);
                continue;
            }
            if (compName.compareToIgnoreCase("Sec-WebSocket-Key") == 0) {
                this.headerSecWebSocketKey = headerValue;
                if (this.headerSecWebSocketKey == null) continue;
                this.headerSecWebSocketKey = this.headerSecWebSocketKey.trim();
                continue;
            }
            if (compName.compareToIgnoreCase("Origin") == 0) {
                this.headerOrigin = headerValue;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Origin header has a value of:  " + this.headerOrigin), (Object[])new Object[0]);
                continue;
            }
            if (compName.compareToIgnoreCase("Sec-WebSocket-Protocol") == 0) {
                for (String val : list) {
                    if (this.headerSecWebSocketProtocol == null) {
                        this.headerSecWebSocketProtocol = val;
                        continue;
                    }
                    this.headerSecWebSocketProtocol = this.headerSecWebSocketProtocol + subProtocolDelimiter + val;
                }
                if (this.headerSecWebSocketProtocol == null || this.headerSecWebSocketProtocol.length() <= 0) continue;
                this.clientSubProtocols = this.headerSecWebSocketProtocol.split(subProtocolDelimiter);
                int len = this.clientSubProtocols.length;
                for (int i = 0; i < len; ++i) {
                    this.clientSubProtocols[i] = this.clientSubProtocols[i].trim();
                }
                continue;
            }
            if (compName.compareToIgnoreCase("Sec-WebSocket-Extensions") == 0) {
                this.clientExtensions = HandshakeProcessor.parseClientExtensions(list);
                continue;
            }
            if (compName.compareToIgnoreCase("Sec-WebSocket-Version") != 0) continue;
            this.headerSecWebSocketVersion = headerValue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WebSocketVersion header has a value of:  " + this.headerSecWebSocketVersion), (Object[])new Object[0]);
            }
            this.things.setWsocProtocolVersion(this.headerSecWebSocketVersion);
        }
    }

    public void addResponseHeaders() {
        this.httpResponse.setHeader("Upgrade", "websocket");
        this.httpResponse.setHeader("Connection", "Upgrade");
        String accept = this.makeAcceptResponseHeaderValue();
        this.httpResponse.setHeader("Sec-WebSocket-Accept", accept);
    }

    public boolean checkOrigin() {
        return this.endpointConfigurator.checkOrigin(this.headerOrigin);
    }

    public void modifyHandshake() {
        TreeMap<String, List<String>> responseHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        Collection names = this.httpResponse.getHeaderNames();
        for (String name : names) {
            Collection headerValues = this.httpResponse.getHeaders(name);
            ArrayList list = new ArrayList(headerValues);
            responseHeaders.put(name, list);
        }
        HandshakeRequestExt handshakeRequest = new HandshakeRequestExt(this.httpRequest, this.requestHeaders, this.parameterMap, this.requestURI);
        HandshakeResponseExt handshakeResponse = new HandshakeResponseExt(responseHeaders);
        this.endpointConfigurator.modifyHandshake(this.endpointConfig, (HandshakeRequest)handshakeRequest, (HandshakeResponse)handshakeResponse);
        Map<String, List<String>> hdrs = handshakeResponse.getHeaders();
        for (Map.Entry<String, List<String>> entry : hdrs.entrySet()) {
            List<String> list = entry.getValue();
            if (list == null) {
                this.httpResponse.setHeader(entry.getKey(), "");
                continue;
            }
            if (list.size() == 0) {
                this.httpResponse.setHeader(entry.getKey(), "");
            }
            for (int x = 0; x < list.size(); ++x) {
                if (x == 0) {
                    this.httpResponse.setHeader(entry.getKey(), list.get(x));
                    continue;
                }
                this.httpResponse.addHeader(entry.getKey(), list.get(x));
            }
        }
    }

    public void determineAndSetSubProtocol() {
        List<String> localSubProtocolList = this.endpointConfig.getSubprotocols();
        if (localSubProtocolList == null) {
            localSubProtocolList = Collections.emptyList();
        }
        List<Object> clientProtocols = null;
        clientProtocols = this.clientSubProtocols == null ? Collections.emptyList() : Arrays.asList(this.clientSubProtocols);
        String agreedSubProtocol = this.endpointConfigurator.getNegotiatedSubprotocol(localSubProtocolList, clientProtocols);
        this.things.setAgreedSubProtocol(agreedSubProtocol);
        this.things.setLocalSubProtocols(localSubProtocolList);
        if (!"".equals(agreedSubProtocol) && agreedSubProtocol != null) {
            this.httpResponse.setHeader("Sec-WebSocket-Protocol", agreedSubProtocol);
        }
    }

    public void determineAndSetExtensions() {
        List agreedExtensions;
        this.configuredExtensions = this.endpointConfig.getExtensions();
        if (this.configuredExtensions == null) {
            this.configuredExtensions = Collections.emptyList();
        }
        if (this.clientExtensions == null) {
            this.clientExtensions = Collections.emptyList();
        }
        if ((agreedExtensions = this.endpointConfigurator.getNegotiatedExtensions(this.configuredExtensions, this.clientExtensions)) != null && agreedExtensions.size() > 0) {
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            for (Extension ext : agreedExtensions) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(ext.getName());
                List li = ext.getParameters();
                if (li == null || li.size() <= 0) continue;
                for (Extension.Parameter p : li) {
                    buf.append("; " + p.getName() + "=" + p.getValue());
                }
            }
            this.things.setNegotiatedExtensions(agreedExtensions);
            this.httpResponse.setHeader("Sec-WebSocket-Extensions", buf.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyHeaders() throws Exception {
        String protocol = this.httpRequest.getProtocol();
        String[] args = protocol.split("/");
        if (args.length < 2) {
            throw new Exception("Websocket request processed, but no HTTP Protocol version was provided..");
        }
        float version = Float.valueOf(args[1]).floatValue();
        if ((double)version < 1.1) {
            throw new Exception("Websocket request processed, provided HTTP Protocol level \"" + protocol + "\"provided but WebSocket support requires HTTP/1.1 or above.");
        }
        if (this.headerHost == null) {
            throw new Exception("Websocket request processing found no Host header.");
        }
        if (this.headerUpgrade == null || !"websocket".equalsIgnoreCase(this.headerUpgrade)) {
            throw new Exception("Websocket request processed but provided upgrade header \"" + this.headerUpgrade + "\" does not match " + "websocket" + ".");
        }
        if (this.headerConnection != null) {
            String[] connection;
            boolean found = false;
            for (String conn : connection = this.headerConnection.split(subProtocolDelimiter)) {
                if (!conn.trim().equalsIgnoreCase("Upgrade")) continue;
                found = true;
            }
            if (!found) {
                throw new Exception("Websocket request processed but provided connection header \"" + this.headerConnection + "\" does not match " + "Upgrade" + ".");
            }
        } else {
            throw new Exception("Websocket request processed but provided connection header \"" + this.headerConnection + "\" does not match " + "Upgrade" + ".");
        }
        int supportedVersion = Integer.valueOf("13");
        if (this.headerSecWebSocketVersion == null) {
            this.httpResponse.setIntHeader("Sec-WebSocket-Version", supportedVersion);
            throw new Exception("Websocket request processed, but no websocket version provided.");
        }
        try {
            int version2 = Integer.parseInt(this.headerSecWebSocketVersion);
            if (version2 != supportedVersion) {
                this.httpResponse.setIntHeader("Sec-WebSocket-Version", supportedVersion);
                throw new Exception("Websocket request processed, but Version header of \"" + this.headerSecWebSocketVersion + "\" is not a match for supported version " + supportedVersion + ".");
            }
        }
        catch (NumberFormatException version2) {
            void nfe;
            FFDCFilter.processException((Throwable)version2, (String)"com.ibm.ws.wsoc.HandshakeProcessor", (String)"405", (Object)this, (Object[])new Object[0]);
            this.httpResponse.setIntHeader("Sec-WebSocket-Version", supportedVersion);
            throw new Exception("Websocket request processed, but version header of \"" + this.headerSecWebSocketVersion + "\" is not valid number.", (Throwable)nfe);
        }
        if ("".equals(this.headerSecWebSocketKey) || this.headerSecWebSocketKey == null) {
            throw new Exception("Websocket request processed, but Sec-WebSocket-Key is blank or null");
        }
        byte[] decodedBytes = Base64Coder.base64DecodeString((String)this.headerSecWebSocketKey);
        if (decodedBytes == null) {
            throw new Exception("Websocket request processed, but client sent Sec-WebSocket-Key that has not been base64 encoded.");
        }
        if (decodedBytes.length != 16) {
            throw new Exception("Websocket request processed, but client sent Sec-WebSocket-Key that is not 16 bytes");
        }
    }

    @Sensitive
    private String makeAcceptResponseHeaderValue() {
        String acceptKey = "";
        try {
            acceptKey = Utils.makeAcceptResponseHeaderValue(this.headerSecWebSocketKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.wsoc.HandshakeProcessor", (String)"431", (Object)this, (Object[])new Object[0]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.wsoc.HandshakeProcessor", (String)"433", (Object)this, (Object[])new Object[0]);
        }
        return acceptKey;
    }

    public static List<Extension> parseClientExtensions(List<String> list) {
        ArrayList<Extension> extensions = new ArrayList<Extension>(10);
        String headerSecWebSocketExtensions = null;
        for (String val : list) {
            if (headerSecWebSocketExtensions == null) {
                headerSecWebSocketExtensions = val;
                continue;
            }
            headerSecWebSocketExtensions = headerSecWebSocketExtensions + subProtocolDelimiter + val;
        }
        if (headerSecWebSocketExtensions != null && headerSecWebSocketExtensions.length() > 0) {
            String[] extArr = headerSecWebSocketExtensions.split(subProtocolDelimiter);
            for (int i = 0; i < extArr.length; ++i) {
                String[] parameters = extArr[i].trim().split(";");
                String extName = parameters[0];
                ArrayList<Extension.Parameter> paramList = new ArrayList<Extension.Parameter>(parameters.length - 1);
                if (parameters.length > 1) {
                    for (int z = 1; z < parameters.length; ++z) {
                        String[] namevals = parameters[z].trim().split("=");
                        String val = "";
                        if (namevals.length > 1) {
                            val = namevals[1];
                        }
                        paramList.add(new ParameterExt(namevals[0], val));
                    }
                }
                extensions.add(new ExtensionExt(extName, paramList));
            }
        }
        return extensions;
    }
}

