/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.external;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.servlet.WsocHandler;
import com.ibm.ws.wsoc.AnnotatedEndpoint;
import com.ibm.ws.wsoc.HandshakeProcessor;
import com.ibm.ws.wsoc.ParametersOfInterest;
import com.ibm.ws.wsoc.WsocUpgradeHandler;
import com.ibm.ws.wsoc.external.ServerContainerExt;
import com.ibm.ws.wsoc.util.Utils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WsocHandlerImpl
implements WsocHandler {
    private static final TraceComponent tc = Tr.register(WsocHandlerImpl.class);
    boolean noMoreAddsCalled = false;
    static final long serialVersionUID = -2067291126638824067L;

    public boolean isWsocRequest(ServletRequest request) throws ServletException {
        ServletContext context = request.getServletContext();
        Object wsocContainer = null;
        if (context != null) {
            wsocContainer = context.getAttribute("javax.websocket.server.ServerContainer");
        }
        if (wsocContainer != null) {
            if (!this.isValidContainer(wsocContainer)) {
                return false;
            }
        } else {
            return false;
        }
        if (!this.noMoreAddsCalled) {
            ((ServerContainerExt)wsocContainer).setNoMoreAddEndpointsAllowed();
            this.noMoreAddsCalled = true;
        }
        return this.checkWebSocketRequest(request, wsocContainer);
    }

    private boolean isValidContainer(Object wsocContainer) {
        return wsocContainer instanceof ServerContainerExt;
    }

    private boolean checkWebSocketRequest(ServletRequest req, Object wsocContainer) throws ServletException {
        if (this.checkIfUpgradeHeader(req)) {
            ServerEndpointConfig endPointConfig;
            ServerContainerExt container = (ServerContainerExt)wsocContainer;
            String path = ((HttpServletRequest)req).getServletPath();
            String pathInfo = ((HttpServletRequest)req).getPathInfo();
            if (pathInfo != null) {
                path = path + pathInfo;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("servlet path is: " + path), (Object[])new Object[0]);
            }
            if ((endPointConfig = container.getServerEndpointConfig(path)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WebSocket request", (Object[])new Object[0]);
                }
                return true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Not a websocket request", (Object[])new Object[0]);
        }
        return false;
    }

    private boolean checkIfUpgradeHeader(ServletRequest request) {
        boolean upgrade = false;
        boolean websocket = false;
        String headerValue = null;
        if (request instanceof HttpServletRequest && "GET".equals(((HttpServletRequest)request).getMethod())) {
            Enumeration names = ((HttpServletRequest)request).getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equalsIgnoreCase("upgrade")) {
                    upgrade = true;
                    headerValue = ((HttpServletRequest)request).getHeader(name);
                }
                if (headerValue != null && headerValue.equalsIgnoreCase("websocket")) {
                    websocket = true;
                }
                if (!upgrade || !websocket) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WebSocket upgrade header exists", (Object[])new Object[0]);
                }
                return true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WebSocket upgrade header doesn't exist", (Object[])new Object[0]);
        }
        return false;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) {
        this.handleRequest(request, response, null, null, false);
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(HttpServletRequest request, HttpServletResponse response, ServerEndpointConfig endPointConfig, Map<String, String> paramMap, boolean allowEndpointCreation) {
        Endpoint ep;
        ServerContainerExt container;
        HandshakeProcessor hp;
        WsocUpgradeHandler wuh;
        block27: {
            wuh = null;
            Class endPointClass = null;
            hp = new HandshakeProcessor();
            hp.initialize(request, response, paramMap);
            try {
                hp.readRequestInfo();
                hp.verifyHeaders();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsoc.external.WsocHandlerImpl", (String)"170", (Object)this, (Object[])new Object[]{request, response, endPointConfig, paramMap, allowEndpointCreation});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("header validation failed, throwing following exception. Exception message: " + e.getMessage()), (Object[])new Object[0]);
                }
                response.setStatus(400);
                return;
            }
            ServletContext context = request.getServletContext();
            container = (ServerContainerExt)context.getAttribute("javax.websocket.server.ServerContainer");
            String path = request.getServletPath();
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                path = path + pathInfo;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("servlet path is: " + path), (Object[])new Object[0]);
            }
            if (endPointConfig == null) {
                endPointConfig = container.getServerEndpointConfig(path);
            }
            if (endPointConfig == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"returning: server endpoint config not found", (Object[])new Object[0]);
                }
                response.setStatus(500);
                return;
            }
            endPointClass = endPointConfig.getEndpointClass();
            ServerEndpointConfig.Configurator configurator = endPointConfig.getConfigurator();
            hp.addWsocConfigurationData(endPointConfig, configurator);
            if (!hp.checkOrigin()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Configurator checkOrigin return false, sending 403.", (Object[])new Object[0]);
                }
                response.setStatus(403);
                return;
            }
            ep = null;
            try {
                Object instance = configurator.getEndpointInstance(endPointClass);
                if (endPointClass.isAnnotationPresent(ServerEndpoint.class)) {
                    try {
                        AnnotatedEndpoint aep = container.getEndpointManager().getAnnotatedEndpoint(endPointConfig.getEndpointClass());
                        if (aep == null && allowEndpointCreation) {
                            aep = new AnnotatedEndpoint();
                            aep.initialize(endPointClass, (EndpointConfig)endPointConfig);
                            container.getEndpointManager().addAnnotatedEndpoint(aep);
                        }
                        if (aep == null) {
                            Tr.error((TraceComponent)tc, (String)"endpoint.instance.error", (Object[])new Object[]{endPointClass});
                            response.setStatus(500);
                            return;
                        }
                        aep = (AnnotatedEndpoint)aep.clone();
                        aep.setAppInstance(instance);
                        aep.setRequestPath(path);
                        ep = aep;
                        break block27;
                    }
                    catch (Exception aep) {
                        void e;
                        FFDCFilter.processException((Throwable)aep, (String)"com.ibm.ws.wsoc.external.WsocHandlerImpl", (String)"245", (Object)this, (Object[])new Object[]{request, response, endPointConfig, paramMap, allowEndpointCreation});
                        throw new ServletException((Throwable)e);
                    }
                }
                ep = (Endpoint)instance;
            }
            catch (InstantiationException instance) {
                void e;
                FFDCFilter.processException((Throwable)instance, (String)"com.ibm.ws.wsoc.external.WsocHandlerImpl", (String)"251", (Object)this, (Object[])new Object[]{request, response, endPointConfig, paramMap, allowEndpointCreation});
                Tr.error((TraceComponent)tc, (String)"endpoint.instance.error", (Object[])new Object[]{endPointClass, e});
                response.setStatus(500);
                return;
            }
            catch (Throwable e) {
                void t;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.external.WsocHandlerImpl", (String)"255", (Object)this, (Object[])new Object[]{request, response, endPointConfig, paramMap, allowEndpointCreation});
                Tr.error((TraceComponent)tc, (String)"endpoint.instance.error", (Object[])new Object[]{endPointClass, t});
                response.setStatus(500);
                return;
            }
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"requesting our upgrade handler be instantiated", (Object[])new Object[0]);
            }
            wuh = (WsocUpgradeHandler)request.upgrade(WsocUpgradeHandler.class);
        }
        catch (IOException t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.wsoc.external.WsocHandlerImpl", (String)"266", (Object)this, (Object[])new Object[]{request, response, endPointConfig, paramMap, allowEndpointCreation});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("returning: user configurator threw an InstantiationException. Exception message: " + e.getMessage()), (Object[])new Object[0]);
            }
            response.setStatus(500);
            return;
        }
        catch (ServletException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.external.WsocHandlerImpl", (String)"274", (Object)this, (Object[])new Object[]{request, response, endPointConfig, paramMap, allowEndpointCreation});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("returning: user configurator threw an InstantiationException. Exception message: " + e.getMessage()), (Object[])new Object[0]);
            }
            response.setStatus(500);
            return;
        }
        if (wuh == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"returning: could not get our upgrade handler instantiated", (Object[])new Object[0]);
            }
            return;
        }
        wuh.initialize(ep, (EndpointConfig)endPointConfig, container);
        hp.addResponseHeaders();
        hp.determineAndSetSubProtocol();
        hp.determineAndSetExtensions();
        hp.modifyHandshake();
        ParametersOfInterest poi = hp.getParametersOfInterest();
        poi.setEndpointManager(container.getEndpointManager());
        ClassLoader tccl = Utils.getContextClassloaderPrivileged();
        ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WsocServlet: stored CL of: " + tccl), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("WsocServlet: stored CMD of: " + componentMetaData), (Object[])new Object[0]);
        }
        poi.setTccl(tccl);
        poi.setCmd(componentMetaData);
        response.setStatus(101);
        wuh.setParametersOfInterest(poi);
    }
}

