/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import java.net.InetSocketAddress;
import java.net.URI;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WsocAddress
implements HttpAddress {
    private static final TraceComponent tc = Tr.register(WsocAddress.class);
    private InetSocketAddress isAddr = null;
    private String scheme = "";
    private String schemeKey = "";
    private String host = "";
    private int port = 80;
    private URI path = null;
    static final long serialVersionUID = 5098129395313203892L;

    public WsocAddress(URI path) {
        this.schemeKey = path.getScheme().toLowerCase();
        this.scheme = path.getScheme();
        this.host = path.getHost();
        this.port = path.getPort();
        if (this.port == -1) {
            this.port = "wss".equals(this.schemeKey) ? 443 : 80;
        }
        this.path = path;
        this.isAddr = new InetSocketAddress(this.host, this.port);
    }

    public String getChainKey() {
        return "OutboundWsoc" + this.schemeKey;
    }

    public void validateURI() {
        if (!this.schemeKey.startsWith("ws") && !this.schemeKey.startsWith("wss")) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.invalid.scheme", (Object[])new Object[]{this.scheme});
            Tr.error((TraceComponent)tc, (String)"client.invalid.scheme", (Object[])new Object[]{this.scheme});
            throw new IllegalArgumentException(msg);
        }
    }

    public boolean isSecure() {
        return "wss".equals(this.schemeKey);
    }

    public URI getURI() {
        return this.path;
    }

    public String getPath() {
        if (this.path.getPath() == null) {
            return "/";
        }
        if (this.path.getPath().equals("")) {
            return "/";
        }
        return this.path.getPath();
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.isAddr;
    }

    public String getHostname() {
        return this.host;
    }

    public boolean isForwardProxy() {
        return false;
    }

    public int getConnectTimeout() {
        return -1;
    }

    public String toString() {
        return this.path.toString();
    }
}

