/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.metadata;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.bus.LibertyApplicationBusFactory;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaxWsServerMetaData {
    private final LibertyApplicationBus applicationBus;
    private final JaxWsModuleMetaData moduleMetaData;
    private final Map<String, J2EEName> endpointNameJ2EENameMap = new HashMap<String, J2EEName>();
    static final long serialVersionUID = -3049921520709995631L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JaxWsServerMetaData(JaxWsModuleMetaData moduleMetaData) {
        this.moduleMetaData = moduleMetaData;
        this.applicationBus = LibertyApplicationBusFactory.getInstance().createServerScopedBus(moduleMetaData);
    }

    public void destroy() {
        if (this.applicationBus != null) {
            this.applicationBus.shutdown(false);
        }
    }

    public LibertyApplicationBus getServerBus() {
        return this.applicationBus;
    }

    public JaxWsModuleMetaData getModuleMetaData() {
        return this.moduleMetaData;
    }

    public void putEndpointNameAndJ2EENameEntry(String endpointName, J2EEName j2eeName) {
        this.endpointNameJ2EENameMap.put(endpointName, j2eeName);
    }

    public J2EEName getEndpointJ2EEName(String endpointName) {
        return this.endpointNameJ2EENameMap.get(endpointName);
    }

    public String retrieveEndpointName(J2EEName j2eeName) {
        for (Map.Entry<String, J2EEName> entry : this.endpointNameJ2EENameMap.entrySet()) {
            if (!entry.getValue().equals(j2eeName)) continue;
            return entry.getKey();
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JaxWsServerMetaData.class);
    }
}

