/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.metadata.builder;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilderContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class WsdlAddressingEnabledHandler
extends DefaultHandler {
    private static final TraceComponent tc = Tr.register(WsdlAddressingEnabledHandler.class);
    private final EndpointInfo endptInfo;
    private final EndpointInfoBuilderContext context;
    private String bindingName;
    private String portName;
    private final HashMap<String, String> preNsMapping = new HashMap();
    static final long serialVersionUID = 8442361962566175199L;

    public WsdlAddressingEnabledHandler(EndpointInfo endptInfo, EndpointInfoBuilderContext context) {
        this.endptInfo = endptInfo;
        this.context = context;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prefix = " + prefix + " uri = " + uri), (Object[])new Object[0]);
        }
        this.preNsMapping.put(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String optional;
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("binding")) {
            this.bindingName = attributes.getValue("name");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("startElement for binding " + this.bindingName), (Object[])new Object[0]);
            }
        }
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("port")) {
            this.portName = attributes.getValue("name");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("startElement for port " + this.portName), (Object[])new Object[0]);
            }
            if (this.endptInfo.getWsdlPort().getLocalPart().equals(this.portName)) {
                String bindingForPortName = attributes.getValue("binding");
                String bindingNs = "";
                if (bindingForPortName.indexOf(":") > 0) {
                    String bindingPrefix = bindingForPortName.substring(0, bindingForPortName.indexOf(":"));
                    bindingNs = this.preNsMapping.get(bindingPrefix);
                    bindingForPortName = bindingForPortName.substring(bindingForPortName.indexOf(":") + 1, bindingForPortName.length());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Namespace URI for prefix " + bindingPrefix + " = " + bindingNs), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("Local name = " + bindingForPortName), (Object[])new Object[0]);
                    }
                }
                QName bQName = new QName(bindingNs, bindingForPortName);
                this.endptInfo.setWsdlBinding(bQName);
            }
        }
        if (this.bindingName != null) {
            if (uri.equals("http://www.w3.org/2007/05/addressing/metadata") && localName.equals("Addressing")) {
                this.context.addContextEnv("addressing.wsdl.enabled", new QName(this.endptInfo.getTargetNamespaceURL(), this.bindingName));
                optional = attributes.getValue("http://www.w3.org/ns/ws-policy", "Optional");
                this.context.addContextEnv("addressing.wsdl.optional", optional);
            }
            if (uri.equals("http://www.w3.org/2007/05/addressing/metadata") && localName.indexOf("AnonymousResponses") > -1) {
                if (localName.equals("AnonymousResponses")) {
                    this.context.addContextEnv("addressing.wsdl.responses.anonymous", Boolean.TRUE);
                } else if (localName.equals("NonAnonymousResponses")) {
                    this.context.addContextEnv("addressing.wsdl.responses.anonymous", Boolean.FALSE);
                }
            }
        }
        if (this.portName != null) {
            if (uri.equals("http://www.w3.org/2007/05/addressing/metadata") && localName.equals("Addressing")) {
                this.context.addContextEnv("addressing.wsdl.enabled", new QName(this.endptInfo.getTargetNamespaceURL(), this.portName));
                optional = attributes.getValue("http://www.w3.org/ns/ws-policy", "Optional");
                this.context.addContextEnv("addressing.wsdl.optional", optional);
            }
            if (uri.equals("http://www.w3.org/2007/05/addressing/metadata") && localName.indexOf("AnonymousResponses") > -1) {
                if (localName.equals("AnonymousResponses")) {
                    this.context.addContextEnv("addressing.wsdl.responses.anonymous", Boolean.TRUE);
                } else if (localName.equals("NonAnonymousResponses")) {
                    this.context.addContextEnv("addressing.wsdl.responses.anonymous", Boolean.FALSE);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("binding")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("endElement for binding " + this.bindingName), (Object[])new Object[0]);
            }
            this.bindingName = null;
        }
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("port")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("endElement for port " + this.portName), (Object[])new Object[0]);
            }
            this.portName = null;
        }
    }

    @Override
    public void endDocument() {
    }
}

