/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.policy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.bus.LibertyApplicationBusListener;
import com.ibm.ws.jaxws.policy.DynamicAttachmentProvider;
import com.ibm.ws.jaxws.policy.URIDomainExpressionBuilder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.cxf.Bus;
import org.apache.cxf.ws.policy.PolicyException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PolicyAttachmentApplicationBusListener
implements LibertyApplicationBusListener {
    private static final TraceComponent tc = Tr.register(PolicyAttachmentApplicationBusListener.class);
    private static final String clientFileName = "policy-attachments-client.xml";
    private static final String serviceFileName = "policy-attachments-server.xml";
    static final long serialVersionUID = -6571496879780036741L;

    @Override
    public void preInit(Bus bus) {
    }

    @Override
    public void initComplete(Bus bus) {
        if (bus == null) {
            return;
        }
        LibertyApplicationBus.Type busType = (LibertyApplicationBus.Type)((Object)bus.getExtension(LibertyApplicationBus.Type.class));
        if (busType == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to recognize the bus type from bus, DynamicAttachmentProvider will not be created", (Object[])new Object[0]);
            }
            return;
        }
        String[] location = null;
        String finalName = "";
        if (busType.equals((Object)LibertyApplicationBus.Type.CLIENT)) {
            finalName = clientFileName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"This is client side so check", (Object[])new Object[]{finalName});
            }
        } else if (busType.equals((Object)LibertyApplicationBus.Type.SERVER)) {
            finalName = serviceFileName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"This is server side so check", (Object[])new Object[]{finalName});
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unknown bus type", (Object[])new Object[]{busType});
            }
            throw new PolicyException((Throwable)new Exception("Cannot init PolicyAttachmentApplicationBusListener because of unknown bus type " + (Object)((Object)busType)));
        }
        location = new String[]{"WEB-INF/" + finalName, "META-INF/" + finalName};
        InputStream is = null;
        ClassLoader classLoader = this.getThreadContextClassLoader();
        for (int i = 0; i <= 1; ++i) {
            if (classLoader.getResource(location[i]) != null) {
                is = classLoader.getResourceAsStream(location[i]);
            }
            if (is == null) continue;
            this.registerBuilder(bus, location[i]);
            try {
                is.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jaxws.policy.PolicyAttachmentApplicationBusListener", (String)"87", (Object)this, (Object[])new Object[]{bus});
            }
            break;
        }
    }

    @Override
    public void preShutdown(Bus bus) {
    }

    @Override
    public void postShutdown(Bus bus) {
    }

    private ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -2299437993031983928L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    private void registerBuilder(Bus bus, String location) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Special policy attachment file exists, register DynamicAttachmentProvider", (Object[])new Object[]{location});
        }
        DynamicAttachmentProvider provider = new DynamicAttachmentProvider();
        provider.setBus(bus);
        provider.setLocation(location);
        bus.setExtension((Object)new URIDomainExpressionBuilder(), URIDomainExpressionBuilder.class);
    }
}

