/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.probe;

import com.ibm.websphere.logging.hpel.LogRecordContext;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.request.probe.ThreadLocalStringExtension;
import com.ibm.wsspi.probeExtension.FastList;
import com.ibm.wsspi.probeExtension.ProbeExtension;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Deactivate;

public class RequestProbeService {
    private static final TraceComponent tc = Tr.register(RequestProbeService.class);
    private static volatile List<ProbeExtension> probeExtensions = Collections.unmodifiableList(new ArrayList());
    private static FastList<RequestContext> activeRequests = new FastList();
    public static final ThreadLocalStringExtension requestIDExtension = new ThreadLocalStringExtension();
    private static final String REQUEST_ID_EXTENSION_NAME = "requestID";

    protected void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        LogRecordContext.registerExtension((String)REQUEST_ID_EXTENSION_NAME, (LogRecordContext.Extension)requestIDExtension);
    }

    protected void modified(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)" Modified", (Object[])new Object[0]);
        }
    }

    public synchronized void setRequestProbe(ProbeExtension probeExtension) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Setting the probe extension into list", (Object[])new Object[]{probeExtension.getClass()});
        }
        ArrayList<ProbeExtension> extensions = new ArrayList<ProbeExtension>(probeExtensions);
        extensions.add(probeExtension);
        probeExtensions = Collections.unmodifiableList(extensions);
    }

    public synchronized void unsetRequestProbe(ProbeExtension probeExtension) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Removing probe extension from list", (Object[])new Object[]{probeExtension.getClass()});
        }
        ArrayList<ProbeExtension> extensions = new ArrayList<ProbeExtension>(probeExtensions);
        extensions.remove(probeExtension);
        probeExtensions = Collections.unmodifiableList(extensions);
    }

    @Deactivate
    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[]{" reason = " + reason});
        }
        LogRecordContext.unregisterExtension((String)REQUEST_ID_EXTENSION_NAME);
        requestIDExtension.remove();
        probeExtensions = Collections.unmodifiableList(new ArrayList());
        activeRequests.clear();
    }

    public static void processAllEntryProbeExtensions(Event event, RequestContext requestContext) {
        if (event == requestContext.getRootEvent()) {
            requestContext.setRequestContextIndex(activeRequests.add(requestContext));
        }
        List<ProbeExtension> probeExtnList = RequestProbeService.getProbeExtensions();
        for (int i = 0; i < probeExtnList.size(); ++i) {
            ProbeExtension probeExtension = probeExtnList.get(i);
            try {
                if (!probeExtension.invokeForEventEntry() || requestContext.getRequestId().getSequenceNumber() % (long)probeExtension.getRequestSampleRate() != 0L) continue;
                if (event == requestContext.getRootEvent() && probeExtension.invokeForRootEventsOnly() && (probeExtension.invokeForEventTypes() == null || probeExtension.invokeForEventTypes().contains(event.getType()))) {
                    probeExtension.processEntryEvent(event, requestContext);
                }
                if (probeExtension.invokeForRootEventsOnly() || probeExtension.invokeForEventTypes() != null && !probeExtension.invokeForEventTypes().contains(event.getType())) continue;
                probeExtension.processEntryEvent(event, requestContext);
                continue;
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"----------------Probe extension invocation failure---------------", (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)(probeExtension.getClass().getName() + ".processEntryEvent failed because of the following reason:"), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)(RequestProbeService.class.getName() + ".processAllEntryProbeExtensions"), (String)"148");
            }
        }
    }

    public static void processAllExitProbeExtensions(Event event, RequestContext requestContext) {
        List<ProbeExtension> probeExtnList = RequestProbeService.getProbeExtensions();
        for (int i = 0; i < probeExtnList.size(); ++i) {
            ProbeExtension probeExtension = probeExtnList.get(i);
            try {
                if (!probeExtension.invokeForEventExit() || requestContext.getRequestId().getSequenceNumber() % (long)probeExtension.getRequestSampleRate() != 0L) continue;
                if (event == requestContext.getRootEvent() && probeExtension.invokeForRootEventsOnly() && (probeExtension.invokeForEventTypes() == null || probeExtension.invokeForEventTypes().contains(event.getType()))) {
                    probeExtension.processExitEvent(event, requestContext);
                }
                if (probeExtension.invokeForRootEventsOnly() || probeExtension.invokeForEventTypes() != null && !probeExtension.invokeForEventTypes().contains(event.getType())) continue;
                probeExtension.processExitEvent(event, requestContext);
                continue;
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"----------------Probe extension invocation failure---------------", (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)(probeExtension.getClass().getName() + ".processExitEvent failed because of the following reason:"), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)(RequestProbeService.class.getName() + ".processAllExitProbeExtensions"), (String)"185");
            }
        }
        if (event == requestContext.getRootEvent()) {
            try {
                RequestContext storedRequestContext = activeRequests.get(requestContext.getRequestContextIndex());
                if (storedRequestContext != null && storedRequestContext.getRequestId() == requestContext.getRequestId()) {
                    activeRequests.remove(requestContext.getRequestContextIndex());
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public static void processAllCounterProbeExtensions(Event event) {
        List<ProbeExtension> probeExtnList = RequestProbeService.getProbeExtensions();
        for (int i = 0; i < probeExtnList.size(); ++i) {
            ProbeExtension probeExtension = probeExtnList.get(i);
            try {
                if (!probeExtension.invokeForCounter()) continue;
                probeExtension.processCounter(event);
                continue;
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"----------------Probe extension invocation failure---------------", (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)(probeExtension.getClass().getName() + ".processCounterEvent failed because of the following reason:"), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)(RequestProbeService.class.getName() + ".processAllCounterProbeExtensions"), (String)"215");
            }
        }
    }

    public static List<RequestContext> getActiveRequests() {
        return activeRequests.getAll();
    }

    public static List<ProbeExtension> getProbeExtensions() {
        return probeExtensions;
    }
}

