/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class PmiModuleConfig
implements Serializable,
PmiConstants {
    private static final long serialVersionUID = 9139791110927568058L;
    private final String UID;
    private String description;
    private String mbeanType = null;
    private final HashMap perfData;
    private String statsNLSFile;
    private int[] dependList = null;
    private boolean hasSubMod = false;
    private boolean hasSubModInit = false;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PmiModuleConfig(String UID) {
        this.UID = UID;
        this.perfData = new HashMap();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMbeanType(String mbeanType) {
        this.mbeanType = mbeanType;
    }

    public void setResourceBundle(String nlsFile) {
        this.statsNLSFile = nlsFile;
    }

    public synchronized void addData(PmiDataInfo info) {
        if (info != null) {
            this.perfData.put(new Integer(info.getId()), info);
        }
    }

    public synchronized void removeData(PmiDataInfo info) {
        if (info != null && this.perfData != null) {
            this.perfData.remove(new Integer(info.getId()));
        }
    }

    public String getResourceBundle() {
        return this.statsNLSFile;
    }

    public int getNumData() {
        return this.perfData.size();
    }

    public String getUID() {
        return this.UID;
    }

    public String getShortName() {
        int index = this.UID.lastIndexOf(".");
        return this.UID.substring(index + 1);
    }

    public String getDescription() {
        return this.description;
    }

    public String getMbeanType() {
        return this.mbeanType;
    }

    public int getDataId(String name) {
        for (PmiDataInfo dataInfo : this.perfData.values()) {
            if (!dataInfo.getName().equalsIgnoreCase(name)) continue;
            return dataInfo.getId();
        }
        return -1;
    }

    public PmiDataInfo getDataInfo(int dataId) {
        return (PmiDataInfo)this.perfData.get(new Integer(dataId));
    }

    public PmiDataInfo[] submoduleMembers(String submoduleName) {
        return this.submoduleMembers(submoduleName, 15);
    }

    public PmiDataInfo[] submoduleMembers(String submoduleName, int level) {
        if (submoduleName == null) {
            return this.listLevelData(level);
        }
        ArrayList<PmiDataInfo> returnData = new ArrayList<PmiDataInfo>();
        boolean inCategory = false;
        if (submoduleName.startsWith("ejb.")) {
            inCategory = true;
        }
        for (PmiDataInfo info : this.perfData.values()) {
            if (inCategory) {
                if (!info.getCategory().equals("all") && !this.isInCategory(submoduleName, info.getCategory())) continue;
                returnData.add(info);
                continue;
            }
            if (info.getSubmoduleName() == null || !info.getSubmoduleName().equals(submoduleName) || info.getLevel() > level) continue;
            returnData.add(info);
        }
        PmiDataInfo[] ret = new PmiDataInfo[returnData.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (PmiDataInfo)returnData.get(i);
        }
        return ret;
    }

    public PmiDataInfo[] listData(String submoduleName) {
        if (submoduleName == null) {
            return this.listAllData();
        }
        return this.submoduleMembers(submoduleName);
    }

    public PmiDataInfo[] listAllData() {
        return this.listLevelData(15);
    }

    public PmiDataInfo[] listLevelData(int level) {
        ArrayList<PmiDataInfo> levelData = new ArrayList<PmiDataInfo>();
        for (PmiDataInfo dataInfo : this.perfData.values()) {
            if (dataInfo.getLevel() > level) continue;
            levelData.add(dataInfo);
        }
        PmiDataInfo[] ret = new PmiDataInfo[levelData.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (PmiDataInfo)levelData.get(i);
        }
        return ret;
    }

    public PmiDataInfo[] listMyLevelData(int level) {
        ArrayList<PmiDataInfo> levelData = new ArrayList<PmiDataInfo>();
        for (PmiDataInfo dataInfo : this.perfData.values()) {
            if (dataInfo.getLevel() != level) continue;
            levelData.add(dataInfo);
        }
        return (PmiDataInfo[])levelData.toArray();
    }

    @Deprecated
    public void print(PrintWriter pw) {
        pw.println("UID:" + this.UID);
        pw.println("description:" + this.description);
        PmiDataInfo[] data = this.listAllData();
        for (int i = 0; i < data.length; ++i) {
            data[i].print(pw);
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer("Stats type=").append(this.UID);
        b.append(", Description=").append(this.description).append("\n");
        PmiDataInfo[] data = this.listAllData();
        for (int i = 0; i < data.length; ++i) {
            b.append("\n").append(data[i].toString()).append("\n");
        }
        return b.toString();
    }

    private boolean isInCategory(String myCategory, String categoryList) {
        StringTokenizer st = new StringTokenizer(categoryList, "+");
        while (st.hasMoreTokens()) {
            if (!myCategory.equals(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    public int[] listStatisticsWithDependents() {
        if (this.dependList == null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (PmiDataInfo dataInfo : this.perfData.values()) {
                if (dataInfo.getDependency() == null) continue;
                list.add(new Integer(dataInfo.getId()));
            }
            this.dependList = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.dependList[i] = (Integer)list.get(i);
            }
        }
        return this.dependList;
    }

    public int[] listStatisticsBySet(String statisticSet) {
        if (statisticSet.equals("none") || statisticSet.equals("custom")) {
            return new int[0];
        }
        int k = 0;
        if (statisticSet.equals("basic")) {
            k = 1;
        } else if (statisticSet.equals("extended")) {
            k = 2;
        } else if (statisticSet.equals("all")) {
            k = 3;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(3);
        for (PmiDataInfo dataInfo : this.perfData.values()) {
            String s = dataInfo.getStatisticSet();
            if (s.equals("basic")) {
                if (k <= 0) continue;
                list.add(new Integer(dataInfo.getId()));
                continue;
            }
            if (s.equals("extended")) {
                if (k <= 1) continue;
                list.add(new Integer(dataInfo.getId()));
                continue;
            }
            if (!s.equals("all") || k <= 2) continue;
            list.add(new Integer(dataInfo.getId()));
        }
        int[] statSet = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            statSet[i] = (Integer)list.get(i);
        }
        return statSet;
    }

    public boolean hasSubModule() {
        if (!this.hasSubModInit) {
            this.hasSubModInit = true;
            if (this.perfData != null) {
                for (PmiDataInfo dataInfo : this.perfData.values()) {
                    if (dataInfo.getSubmoduleName() == null) continue;
                    this.hasSubMod = true;
                    break;
                }
            }
        }
        return this.hasSubMod;
    }

    public PmiModuleConfig copy() {
        PmiModuleConfig r = new PmiModuleConfig(this.UID);
        if (this.description != null) {
            r.description = new String(this.description);
        }
        r.mbeanType = this.mbeanType;
        r.statsNLSFile = this.statsNLSFile;
        r.hasSubMod = this.hasSubMod;
        r.dependList = this.dependList;
        if (this.perfData != null) {
            for (PmiDataInfo dataInfo : this.perfData.values()) {
                r.perfData.put(new Integer(dataInfo.getId()), dataInfo.copy());
            }
        }
        return r;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PmiModuleConfig.class);
    }
}

