/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal;

import com.ibm.websphere.monitor.Probe;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.monitor.internal.ProbeManagerImpl;
import com.ibm.ws.monitor.internal.ReflectionHelper;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.objectweb.asm.Type;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public final class ProbeImpl
implements Probe {
    private static final String CTOR_METHOD_NAME = "<init>";
    final String name;
    final long identifier;
    final WeakReference<Class<?>> sourceClassReference;
    WeakReference<Method> sourceMethodReference;
    WeakReference<Constructor<?>> sourceConstructorReference;
    final String sourceMethodName;
    final String sourceMethodDescriptor;
    final long sourceBundleId;
    static final long serialVersionUID = -7050771874810516956L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ProbeImpl(ProbeManagerImpl probeManagerImpl, Class<?> clazz, String name, Constructor<?> ctor, Method method) {
        this.name = name;
        this.sourceClassReference = new WeakReference(clazz);
        this.sourceMethodReference = new WeakReference<Method>(method);
        this.sourceConstructorReference = new WeakReference(ctor);
        this.identifier = probeManagerImpl.generateProbeId();
        if (method != null) {
            this.sourceMethodName = method.getName();
            this.sourceMethodDescriptor = Type.getMethodDescriptor((Method)method);
        } else if (ctor != null) {
            this.sourceMethodName = CTOR_METHOD_NAME;
            this.sourceMethodDescriptor = Type.getConstructorDescriptor(ctor);
        } else {
            throw new IllegalArgumentException("Method or constructor reference is required");
        }
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        this.sourceBundleId = bundle == null ? -1L : bundle.getBundleId();
    }

    @Override
    public Class<?> getSourceClass() {
        return (Class)this.sourceClassReference.get();
    }

    @Override
    public Method getSourceMethod() {
        Method method = (Method)this.sourceMethodReference.get();
        if (method != null || this.sourceMethodName == CTOR_METHOD_NAME) {
            return method;
        }
        for (Method m : ReflectionHelper.getDeclaredMethods(this.getSourceClass())) {
            if (!m.getName().equals(this.sourceMethodName) || !Type.getMethodDescriptor((Method)m).equals(this.sourceMethodDescriptor)) continue;
            method = m;
            this.sourceMethodReference = new WeakReference<Method>(method);
            break;
        }
        return method;
    }

    @Override
    public Constructor<?> getSourceConstructor() {
        Constructor<?> ctor = (Constructor<?>)this.sourceConstructorReference.get();
        if (ctor != null || this.sourceMethodName != CTOR_METHOD_NAME) {
            return ctor;
        }
        for (Constructor<?> c : ReflectionHelper.getDeclaredConstructors(this.getSourceClass())) {
            if (!Type.getConstructorDescriptor(c).equals(this.sourceMethodDescriptor)) continue;
            ctor = c;
            this.sourceConstructorReference = new WeakReference(ctor);
            break;
        }
        return ctor;
    }

    @Override
    public long getSourceBundleId() {
        return this.sourceBundleId;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return (int)this.identifier;
    }

    public boolean equals(Object o) {
        if (o instanceof ProbeImpl) {
            ProbeImpl that = (ProbeImpl)o;
            return this.identifier == that.identifier;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";identifier=").append(this.identifier);
        sb.append(",clazz=").append(this.sourceClassReference.get());
        sb.append(",name=").append(this.name);
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProbeImpl.class);
    }
}

