/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.collectors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class CpuTimeCollector {
    private static final ThreadMXBean threadBean = CpuTimeCollector.getThreadMXBean();
    private static final TraceComponent tc = Tr.register(CpuTimeCollector.class);
    long previous;
    long current;
    static final long serialVersionUID = 8715477491851473331L;

    public long getPrevious() {
        return this.previous;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getElapsed() {
        return this.current - this.previous;
    }

    public void begin() {
        if (threadBean == null) {
            return;
        }
        this.previous = this.current;
        this.current = threadBean.getCurrentThreadCpuTime();
    }

    public void end() {
        if (threadBean == null) {
            return;
        }
        this.previous = this.current;
        this.current = threadBean.getCurrentThreadCpuTime();
    }

    private static ThreadMXBean getThreadMXBean() {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadMXBean>(){
            static final long serialVersionUID = 1783373424346479143L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ThreadMXBean run() {
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                try {
                    if (bean != null && !bean.isCurrentThreadCpuTimeSupported()) {
                        bean = null;
                    }
                    if (bean != null && !bean.isThreadCpuTimeEnabled()) {
                        bean.setThreadCpuTimeEnabled(true);
                    }
                }
                catch (Throwable t) {
                    bean = null;
                }
                return bean;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }
}

