/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitors;

import com.ibm.websphere.monitor.annotation.Args;
import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.ProbeAtEntry;
import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.annotation.This;
import com.ibm.websphere.monitor.meters.MeterCollection;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.monitors.helper.ThreadPoolStats;
import com.ibm.ws.monitors.helper.ThreadPoolStatsHelper;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.stat.SPIBoundedRangeStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.lang.reflect.Method;
import java.util.Map;

@Monitor(group={"ThreadPool"})
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class ThreadPoolMonitor
extends StatisticActions {
    @PublishedMetric
    public MeterCollection<ThreadPoolStats> threadPoolCountByName = new MeterCollection("ThreadPool", this);
    private Object ob_ref;
    private static final TraceComponent tc = Tr.register(ThreadPoolMonitor.class);
    private static final String DEFAULT_POOL_NAME = "Default Executor";
    public static final int ACTIVE_THREADS = 3;
    public static final int POOL_SIZE = 4;
    private static final String template = "/com/ibm/ws/monitors/threadPoolModule.xml";
    private SPIBoundedRangeStatistic activeThreads;
    private SPIBoundedRangeStatistic poolSize;
    private static ThreadPoolStatsHelper _tpHelper = null;
    static final long serialVersionUID = 4741091502533645708L;

    public ThreadPoolMonitor() {
        try {
            StatsGroup grp = StatsFactory.createStatsGroup("ThreadPool", template, null, this);
            StatsFactory.createStatsInstance(DEFAULT_POOL_NAME, grp, null, (StatisticActions)this);
        }
        catch (StatsFactoryException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Thread Pool Module is not registered with PMI", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)".ThreadPoolMonitor");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.threading.internal.ExecutorServiceImpl", method="execute")
    public void atFieldGet(@This Object esi) {
        if (this.ob_ref == null) {
            String poolName = DEFAULT_POOL_NAME;
            try {
                ThreadPoolStats tpStats;
                Method tMethod = esi.getClass().getMethod("getPoolName", null);
                String tempName = null;
                if (tMethod != null) {
                    tempName = (String)tMethod.invoke(esi, null);
                }
                this.ob_ref = esi;
                if (!poolName.equalsIgnoreCase(tempName)) {
                    poolName = tempName;
                }
                if ((tpStats = this.threadPoolCountByName.get(poolName)) == null) {
                    this.initThreadPoolStat(poolName);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getSimpleName(), (String)"Unable to query Thread Pool Exec.");
            }
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.threading.internal.ExecutorServiceImpl", method="createExecutor")
    public void atCreateExecutorEntry(@Args Object[] myargs) {
        Map componentConfig = (Map)myargs[0];
        String name = (String)componentConfig.get("name");
        if (name != null && !name.isEmpty()) {
            this.threadPoolCountByName.remove(name);
            this.ob_ref = null;
        }
    }

    private synchronized void initThreadPoolStat(String _poolName) {
        if (this.threadPoolCountByName.get(_poolName) != null) {
            return;
        }
        if (_tpHelper == null) {
            _tpHelper = new ThreadPoolStatsHelper(_poolName, this.ob_ref);
        }
        ThreadPoolStats tpStats = new ThreadPoolStats(_poolName, this.ob_ref);
        this.threadPoolCountByName.put(_poolName, tpStats);
    }

    @Override
    public void statisticCreated(SPIStatistic s) {
        if (s.getId() == 3) {
            this.activeThreads = (SPIBoundedRangeStatistic)s;
        } else if (s.getId() == 4) {
            this.poolSize = (SPIBoundedRangeStatistic)s;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Invlid stats found " + s), (Object[])new Object[0]);
        }
    }

    @Override
    public void updateStatisticOnRequest(int dataId) {
        if (_tpHelper == null) {
            return;
        }
        if (dataId == 3) {
            this.activeThreads.set(_tpHelper.getActiveThreads());
        }
        if (dataId == 4) {
            this.poolSize.set(_tpHelper.getPoolSize());
        }
    }
}

