/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class CountStatisticImpl
extends StatisticImpl
implements SPICountStatistic {
    private static final long serialVersionUID = 6335644998767409978L;
    protected long count = 0L;
    protected CountStatisticImpl baseValue = null;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public int getStatisticType() {
        return 1;
    }

    public CountStatisticImpl(int dataId) {
        super(dataId);
    }

    public CountStatisticImpl(int dataId, long count, long startTime, long lastSampleTime) {
        super(dataId, null, null, null, startTime, lastSampleTime);
        this.count = count;
    }

    public CountStatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        super(id, name, unit, description, startTime, lastSampleTime);
    }

    @Override
    public WSStatistic copy() {
        CountStatisticImpl copy = new CountStatisticImpl(this.id, this.count, this.startTime, this.lastSampleTime);
        copy.baseValue = this.baseValue;
        return copy;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    @Override
    public void reset(boolean resetAll) {
        if (resetAll) {
            super.reset();
        }
        this.count = 0L;
    }

    @Override
    public void set(long count, long startTime, long lastSampleTime) {
        this.count = count;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
    }

    @Override
    public void combine(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        CountStatisticImpl other = (CountStatisticImpl)otherStat;
        this.count += other.count;
        if (other.lastSampleTime > this.lastSampleTime) {
            this.lastSampleTime = other.lastSampleTime;
        }
    }

    @Override
    public void setCount(long value) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        this.count = value;
    }

    public void setCount(long value, long lastSampleTime) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = lastSampleTime;
        this.count = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void increment(long time, long value) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = time;
        if (!this.sync) {
            this.count += value;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                this.count += value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void decrement(long time, long value) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = time;
        if (!this.sync) {
            this.count -= value;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                this.count -= value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void increment() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            ++this.count;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                ++this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void increment(long val) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += val;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                this.count += val;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void decrement() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            --this.count;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                --this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void decrement(long val) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= val;
        } else {
            CountStatisticImpl countStatisticImpl = this;
            synchronized (countStatisticImpl) {
                this.count -= val;
            }
        }
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuffer str = new StringBuffer(super.toString(""));
        str.append(", type=").append("CountStatistic");
        str.append(", count=").append(this.count);
        return str.toString();
    }

    @Override
    public String toXML() {
        StringBuffer res = new StringBuffer();
        res.append("<CS");
        res.append(" id=\"");
        res.append(this.id);
        res.append("\" sT=\"");
        res.append(this.startTime);
        res.append("\" lST=\"");
        res.append(this.lastSampleTime);
        res.append("\" ct=\"");
        res.append(this.count);
        res.append("\">\n");
        res.append("</CS>");
        return res.toString();
    }

    @Override
    public void update(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        CountStatisticImpl other = (CountStatisticImpl)otherStat;
        if (this.baseValue == null) {
            this.count = other.getCount();
            this.startTime = other.getStartTime();
        } else {
            this.count = other.count - this.baseValue.count;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.lastSampleTime = other.lastSampleTime;
    }

    @Override
    public WSStatistic delta(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        CountStatisticImpl other = (CountStatisticImpl)otherStat;
        CountStatisticImpl newData = new CountStatisticImpl(this.id);
        newData.count = this.count - other.getCount();
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    @Override
    public WSStatistic rateOfChange(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        CountStatisticImpl other = (CountStatisticImpl)otherStat;
        CountStatisticImpl newData = new CountStatisticImpl(this.id);
        long timeDiff = (this.lastSampleTime - other.lastSampleTime) / 1000L;
        if (timeDiff == 0L) {
            return null;
        }
        newData.count = (this.count - other.count) / timeDiff;
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    @Override
    public void resetOnClient(WSStatistic other) {
        if (other == null) {
            if (this.baseValue == null) {
                this.baseValue = new CountStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (this.validate(other)) {
            this.baseValue = (CountStatisticImpl)other;
            this.update(this.baseValue);
        }
    }

    private boolean validate(WSStatistic other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof CountStatisticImpl)) {
            return false;
        }
        return other.getId() == this.id;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CountStatisticImpl.class);
    }
}

