/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.eclipselink.logging;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import org.eclipse.persistence.logging.SessionLogEntry;

@Trivial
class LogChannel {
    private final TraceComponent _tc;

    LogChannel(String channel) {
        this._tc = Tr.register((String)channel, LogChannel.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    }

    boolean shouldLog(int level) {
        switch (level) {
            case 8: {
                return false;
            }
            case 7: {
                return this._tc.isErrorEnabled();
            }
            case 6: {
                return this._tc.isWarningEnabled();
            }
            case 5: {
                return this._tc.isInfoEnabled();
            }
            case 4: {
                return this._tc.isConfigEnabled();
            }
            case 3: {
                return this._tc.isEventEnabled();
            }
            case 2: {
                return this._tc.isEntryEnabled();
            }
        }
        return this._tc.isDebugEnabled();
    }

    void log(SessionLogEntry entry, String formattedMessage) {
        int level = entry.getLevel();
        Throwable loggedException = entry.getException();
        String msgParm = (formattedMessage == null || formattedMessage.equals("")) && loggedException != null ? loggedException.toString() : formattedMessage;
        switch (level) {
            case 8: {
                return;
            }
            case 7: {
                Tr.error((TraceComponent)this._tc, (String)"PROVIDER_ERROR_CWWJP9992E", (Object[])new Object[]{msgParm});
                break;
            }
            case 6: {
                Tr.warning((TraceComponent)this._tc, (String)"PROVIDER_WARNING_CWWJP9991W", (Object[])new Object[]{msgParm});
                break;
            }
            case 5: {
                Tr.info((TraceComponent)this._tc, (String)"PROVIDER_INFO_CWWJP9990I", (Object[])new Object[]{msgParm});
                break;
            }
            case 4: {
                Tr.info((TraceComponent)this._tc, (String)"PROVIDER_INFO_CWWJP9990I", (Object[])new Object[]{msgParm});
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                Tr.debug((TraceComponent)this._tc, (String)formattedMessage, (Object[])new Object[0]);
            }
        }
        if (this._tc.isDebugEnabled() && loggedException != null) {
            Tr.debug((TraceComponent)this._tc, (String)"throwable", (Object[])new Object[]{loggedException});
        }
    }
}

