/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticateApi;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.LoggedOutTokenCacheImpl;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SSOAuthenticator
implements WebAuthenticator {
    public static final String DEFAULT_SSO_COOKIE_NAME = "LtpaToken2";
    private static final TraceComponent tc = Tr.register(SSOAuthenticator.class);
    private final AuthenticationService authenticationService;
    private final WebAppSecurityConfig webAppSecurityConfig;
    private final SSOCookieHelper ssoCookieHelper;
    private final String challengeType;
    static final long serialVersionUID = 3133580111719027507L;

    public SSOAuthenticator(AuthenticationService authenticationService, SecurityMetadata securityMetadata, WebAppSecurityConfig webAppSecurityConfig, SSOCookieHelper ssoCookieHelper) {
        this.authenticationService = authenticationService;
        this.webAppSecurityConfig = webAppSecurityConfig;
        this.ssoCookieHelper = ssoCookieHelper;
        LoginConfiguration loginConfig = securityMetadata == null ? null : securityMetadata.getLoginConfiguration();
        this.challengeType = loginConfig == null ? null : loginConfig.getAuthenticationMethod();
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        return this.authenticate(webRequest, this.webAppSecurityConfig);
    }

    public AuthenticationResult authenticate(WebRequest webRequest, WebAppSecurityConfig webAppSecConfig) {
        HttpServletRequest req = webRequest.getHttpServletRequest();
        HttpServletResponse res = webRequest.getHttpServletResponse();
        AuthenticationResult authResult = this.handleSSO(req, res);
        return authResult;
    }

    @FFDCIgnore(value={AuthenticationException.class})
    public AuthenticationResult handleSSO(HttpServletRequest req, HttpServletResponse res) {
        boolean useOnlyCustomCookieName;
        boolean comp;
        AuthenticationResult authResult = null;
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return authResult;
        }
        boolean bl = comp = this.webAppSecurityConfig != null && this.webAppSecurityConfig.getLogoutOnHttpSessionExpire();
        if (comp && req.getRequestedSessionId() != null && !req.isRequestedSessionIdValid() && this.challengeType != null && this.challengeType.equals("FORM")) {
            this.ssoCookieHelper.createLogoutCookies(req, res);
            return authResult;
        }
        String cookieName = this.ssoCookieHelper.getSSOCookiename();
        String[] hdrVals = CookieHelper.getCookieValues(cookies, cookieName);
        boolean bl2 = useOnlyCustomCookieName = this.webAppSecurityConfig != null && this.webAppSecurityConfig.isUseOnlyCustomCookieName();
        if (hdrVals == null && !DEFAULT_SSO_COOKIE_NAME.equalsIgnoreCase(cookieName) && !useOnlyCustomCookieName) {
            hdrVals = CookieHelper.getCookieValues(cookies, DEFAULT_SSO_COOKIE_NAME);
        }
        if (hdrVals != null) {
            for (int n = 0; n < hdrVals.length; ++n) {
                boolean checkLoggedOutToken;
                String hdrVal = hdrVals[n];
                if (hdrVal == null || hdrVal.length() <= 0) continue;
                String ltpa64 = hdrVal;
                boolean bl3 = checkLoggedOutToken = this.webAppSecurityConfig != null && this.webAppSecurityConfig.isTrackLoggedOutSSOCookiesEnabled();
                if (checkLoggedOutToken && this.isTokenLoggedOut(ltpa64)) {
                    this.cleanupLoggedOutToken(req, res);
                    return authResult;
                }
                AuthenticationData authenticationData = this.createAuthenticationData(req, res, ltpa64);
                try {
                    Subject authenticatedSubject = this.authenticationService.authenticate("system.WEB_INBOUND", authenticationData, null);
                    authResult = new AuthenticationResult(AuthResult.SUCCESS, authenticatedSubject, this.ssoCookieHelper.getSSOCookiename(), null, "success");
                    return authResult;
                }
                catch (AuthenticationException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"handleSSO Exception: ", (Object[])new Object[]{e});
                }
            }
        }
        this.ssoCookieHelper.createLogoutCookies(req, res);
        return authResult;
    }

    private boolean isTokenLoggedOut(String ltpaToken) {
        boolean loggedOut = false;
        Object entry = LoggedOutTokenCacheImpl.getInstance().getDistributedObjectLoggedOutToken(ltpaToken);
        if (entry != null) {
            loggedOut = true;
        }
        return loggedOut;
    }

    private void cleanupLoggedOutToken(HttpServletRequest req, HttpServletResponse res) {
        AuthenticateApi aa = new AuthenticateApi(this.ssoCookieHelper, this.authenticationService);
        aa.simpleLogout(req, res);
    }

    private AuthenticationData createAuthenticationData(HttpServletRequest req, HttpServletResponse res, String ltpaToken) {
        WSAuthenticationData authenticationData = new WSAuthenticationData();
        authenticationData.set("HTTP_SERVLET_REQUEST", (Object)req);
        authenticationData.set("HTTP_SERVLET_RESPONSE", (Object)res);
        authenticationData.set("TOKEN64", (Object)ltpaToken);
        return authenticationData;
    }

    public AuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, HashMap props) throws Exception {
        return null;
    }
}

