/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.crypto.certificateutil.DefaultSSLCertificateCreator;
import com.ibm.ws.crypto.certificateutil.DefaultSSLCertificateFactory;
import com.ibm.ws.crypto.certificateutil.DefaultSubjectDN;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import com.ibm.ws.ssl.internal.KeystoreConfig;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class WSKeyStore
extends Properties {
    private static final long serialVersionUID = 7497108598211551343L;
    protected static final TraceComponent tc = Tr.register(WSKeyStore.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    protected static final WSPKCSInKeyStoreList pkcsStoreList = new WSPKCSInKeyStoreList();
    private static boolean defaultKeyStoreWarningIssued = false;
    private KeyStore myKeyStore = null;
    private String name = null;
    private String location = null;
    private String provider = JSSEProviderFactory.getInstance().getKeyStoreProvider();
    private String type = "JKS";
    private Boolean fileBased = Boolean.TRUE;
    private Boolean readOnly = Boolean.FALSE;
    private Boolean initializeAtStartup = Boolean.FALSE;
    private Boolean stashFile = Boolean.FALSE;
    private Map<String, String> customProps = null;
    private Boolean isDefault = false;
    private String genKeyHostName = null;
    private Long pollingRate = null;
    private String trigger = "disabled";
    private SerializableProtectedString password = null;
    private final transient KeystoreConfig cfgSvc;
    private final String KEY_STORE_POLLING_RATE = "pollingRate";
    private final String KEY_STORE_READ_ONLY = "readOnly";
    private final String KEY_STORE_FILE_BASED = "fileBased";
    private final String KEY_STORE_KEYENTRY = "keyEntry";
    private final String KEY_STORE_KEYENTRY_NAME = "name";
    private final String KEY_STORE_KEYENTRY_PASSWORD = "keyPassword";
    private static final String IBMPKCS11Impl_PROVIDER_NAME = "IBMPKCS11Impl";
    private static final String SUNPKCS11_PROVIDER_NAME = "SunPKCS11";
    private final Map<String, SerializableProtectedString> certAliasInfo = new HashMap<String, SerializableProtectedString>();

    public WSKeyStore() {
        this.cfgSvc = null;
        this.setFileBased(true);
        String provider = JSSEProviderFactory.getInstance().getKeyStoreProvider();
        if (null != provider) {
            this.setProvider(provider);
        }
        this.setType("PKCS12");
        this.setReadOnly(false);
        this.setInitializeAtStartup(false);
        this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
    }

    public WSKeyStore(String _name, Dictionary<String, Object> properties, KeystoreConfig cfgSvc) throws Exception {
        this.name = _name;
        this.cfgSvc = cfgSvc;
        List<Map<String, Object>> keyEntryElements = Nester.nest("keyEntry", properties);
        this.saveAliasInformation(keyEntryElements);
        String specifiedType = null;
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object oValue = properties.get(key);
            if (!(oValue instanceof String)) {
                if (key.equalsIgnoreCase("pollingRate") && oValue instanceof Long) {
                    this.pollingRate = (Long)oValue;
                }
                if (key.equalsIgnoreCase("fileBased") && oValue instanceof Boolean) {
                    this.fileBased = (Boolean)oValue;
                }
                if (!key.equalsIgnoreCase("readOnly") || !(oValue instanceof Boolean)) continue;
                this.readOnly = (Boolean)oValue;
                continue;
            }
            String value = (String)oValue;
            if (key.equalsIgnoreCase("location")) {
                this.location = value;
                continue;
            }
            if (key.equalsIgnoreCase("provider")) {
                this.provider = value;
                continue;
            }
            if (key.equalsIgnoreCase("type")) {
                this.type = value;
                specifiedType = value;
                continue;
            }
            if (key.equalsIgnoreCase("initializeAtStartup")) {
                this.initializeAtStartup = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase("createStashFileForCMS")) {
                this.stashFile = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase("id") && this.name == null) {
                this.name = value;
                continue;
            }
            if (key.equalsIgnoreCase("genKeyHostName") && this.genKeyHostName == null) {
                this.genKeyHostName = value;
                continue;
            }
            if (key.equalsIgnoreCase("updateTrigger")) {
                this.trigger = value;
                continue;
            }
            if (null == this.customProps) {
                this.customProps = new HashMap<String, String>();
            }
            this.customProps.put(key, value);
        }
        Object o = properties.get("password");
        this.password = o != null ? (o instanceof SerializableProtectedString ? (SerializableProtectedString)o : new SerializableProtectedString(((String)o).toCharArray())) : SerializableProtectedString.EMPTY_PROTECTED_STRING;
        this.isDefault = "defaultKeyStore".equals(this.name);
        if (this.isDefault.booleanValue() && this.location == null && specifiedType == null) {
            this.location = "${server.output.dir}/resources/security/key.jks";
            this.type = "JKS";
            specifiedType = "JKS";
            if (this.password.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"ssl.default.keystore.config.error", (Object[])new Object[0]);
                throw new IllegalArgumentException("Required keystore information is missing, must provide a password for the default keystore");
            }
        }
        if (specifiedType == null || this.location == null) {
            Tr.error((TraceComponent)tc, (String)"ssl.keystore.config.error", (Object[])new Object[0]);
            throw new IllegalArgumentException("Required keystore information is missing, must provide a location and type.");
        }
        if (this.getFileBased().booleanValue()) {
            this.setLocation(this.location);
        }
        this.setUpInternalProperties();
        this.initializeKeyStore(true);
    }

    private void saveAliasInformation(List<Map<String, Object>> keyEntryElements) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveAliasInformation", (Object[])new Object[0]);
        }
        for (Map<String, Object> keyEntry : keyEntryElements) {
            SerializableProtectedString certPassword;
            String alias = (String)keyEntry.get("name");
            Object o = keyEntry.get("keyPassword");
            if (o != null) {
                certPassword = o instanceof SerializableProtectedString ? (SerializableProtectedString)o : new SerializableProtectedString(((String)o).toCharArray());
            } else {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("There is no password for certificate " + alias + " do not save it."), (Object[])new Object[0]);
                continue;
            }
            if (alias == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding " + alias + " to key pwd map."), (Object[])new Object[0]);
            }
            this.certAliasInfo.put(alias, certPassword);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveAliasInformation");
        }
    }

    private boolean locationInOutputDir(String location) {
        String expandedOutputLocation = this.cfgSvc.resolveString("${server.output.dir}/resources/security/");
        return location.startsWith("${server.output.dir}/resources/security/") || location.startsWith(expandedOutputLocation);
    }

    private void setLocation(String _location) {
        String res = null;
        File resFile = null;
        boolean relativePath = true;
        boolean defaultPath = false;
        try {
            res = this.cfgSvc.resolveString(_location);
            resFile = new File(res);
            relativePath = !resFile.isAbsolute();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (resFile == null || !resFile.isFile() && relativePath) {
            try {
                res = this.cfgSvc.resolveString("${server.config.dir}/resources/security/" + _location);
                resFile = new File(res);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (resFile == null || !resFile.isFile()) {
                try {
                    res = this.cfgSvc.resolveString("${server.output.dir}/resources/security/" + _location);
                    resFile = new File(res);
                    defaultPath = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        if (this.isDefault.booleanValue() && (defaultPath || this.locationInOutputDir(_location))) {
            this.initializeAtStartup = true;
        }
        if (res != null && resFile.isFile() || this.isDefault.booleanValue()) {
            this.location = res;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found store under [" + this.location + "]"), (Object[])new Object[0]);
            }
        } else {
            Tr.warning((TraceComponent)tc, (String)"ssl.keystore.not.found.warning", (Object[])new Object[]{res, this.name});
        }
    }

    private void setUpInternalProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setUpInternalProperties", (Object[])new Object[0]);
        }
        if (this.getLocation() != null) {
            String keyStoreType;
            String keyStoreLocation;
            String keyStorePassword;
            String keyStoreName;
            String keyStoreProvider;
            Map<String, String> otherProps = this.getCustomProps();
            if (otherProps != null) {
                for (Map.Entry<String, String> current : otherProps.entrySet()) {
                    this.setProperty(current.getKey(), current.getValue());
                }
            }
            if ((keyStoreProvider = this.getProvider()) != null) {
                this.setProperty("com.ibm.ssl.keyStoreProvider", keyStoreProvider);
            }
            if ((keyStoreName = this.getName()) != null) {
                this.setProperty("com.ibm.ssl.keyStoreName", keyStoreName);
            }
            if ((keyStorePassword = this.getPassword()) != null) {
                this.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
            }
            if ((keyStoreLocation = this.getLocation()) != null) {
                this.setProperty("com.ibm.ssl.keyStore", keyStoreLocation);
            }
            if (this.getFileBased() != null) {
                this.setProperty("com.ibm.ssl.keyStoreFileBased", this.getFileBased().toString());
            }
            if ((keyStoreType = this.getType()) != null) {
                this.setProperty("com.ibm.ssl.keyStoreType", keyStoreType);
                if (!(keyStoreType.equalsIgnoreCase("JKS") || keyStoreType.equalsIgnoreCase("JCEKS") || keyStoreType.equalsIgnoreCase("PKCS12"))) {
                    this.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                }
                if (keyStoreType.equalsIgnoreCase("PKCS11")) {
                    this.setProperty("com.ibm.ssl.tokenEnabled", "true");
                    if (this.isOracleVendor()) {
                        this.setProperty("com.ibm.ssl.keyStoreProvider", SUNPKCS11_PROVIDER_NAME);
                    } else {
                        this.setProperty("com.ibm.ssl.keyStoreProvider", IBMPKCS11Impl_PROVIDER_NAME);
                    }
                }
            }
            if (this.getReadOnly() != null) {
                this.setProperty("com.ibm.ssl.keyStoreReadOnly", this.getReadOnly().toString());
            }
            if (this.getInitializeAtStartup() != null) {
                this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", this.getInitializeAtStartup().toString());
            }
            if (this.getStashFile() != null) {
                this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", this.getStashFile().toString());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setUpInternalProperties");
        }
    }

    private void setType(String _type) {
        this.type = _type;
        this.setProperty("com.ibm.ssl.keyStoreType", _type);
    }

    private void setProvider(String _provider) {
        this.provider = _provider;
        this.setProperty("com.ibm.ssl.keyStoreProvider", _provider);
    }

    private void setFileBased(Boolean flag) {
        this.fileBased = flag;
        this.setProperty("com.ibm.ssl.keyStoreFileBased", flag.toString());
    }

    private void setReadOnly(Boolean flag) {
        this.readOnly = flag;
        this.setProperty("com.ibm.ssl.keyStoreReadOnly", flag.toString());
    }

    private void setInitializeAtStartup(Boolean flag) {
        this.initializeAtStartup = flag;
        this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", flag.toString());
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getLocation -> " + this.location), (Object[])new Object[0]);
        }
        return this.location;
    }

    public String getPassword() {
        return new String(this.password.getChars());
    }

    public String getProvider() {
        return this.provider;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getFileBased() {
        return this.fileBased;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Boolean getInitializeAtStartup() {
        return this.initializeAtStartup;
    }

    public Boolean getStashFile() {
        return this.stashFile;
    }

    public long getPollingRate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPollingRate returning " + this.pollingRate), (Object[])new Object[0]);
        }
        return this.pollingRate;
    }

    public String getTrigger() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTrigger returning " + this.trigger), (Object[])new Object[0]);
        }
        return this.trigger;
    }

    public Map<String, String> getCustomProps() {
        return this.customProps;
    }

    public SerializableProtectedString getKeyPassword() {
        if (!this.certAliasInfo.isEmpty()) {
            Map.Entry<String, SerializableProtectedString> entry = this.certAliasInfo.entrySet().iterator().next();
            return entry.getValue();
        }
        return this.password;
    }

    public synchronized KeyStore do_getKeyStore(boolean reinitialize, boolean createIfNotPresent) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"do_getKeyStore", (Object[])new Object[]{reinitialize, createIfNotPresent});
        }
        String storeFile = this.location;
        boolean create = createIfNotPresent;
        try {
            this.myKeyStore = this.obtainKeyStore(storeFile, create);
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cannot open keystore URL: " + storeFile + "; " + ex), (Object[])new Object[0]);
            }
            if (this.getType().equals("PKCS11")) {
                String msg = ex.getMessage();
                if (msg == null) {
                    msg = ex.getCause().getMessage();
                }
                Tr.error((TraceComponent)tc, (String)"ssl.hwkeystore.load.error.CWPKI0814E", (Object[])new Object[]{this.getName(), storeFile, msg});
            } else {
                Tr.error((TraceComponent)tc, (String)"ssl.keystore.load.error.CWPKI0033E", (Object[])new Object[]{storeFile, ex.getMessage()});
            }
            Tr.warning((TraceComponent)tc, (String)"ssl.config.not.used.CWPKI0809W", (Object[])new Object[]{this.name, this.name});
            throw ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"do_getKeyStore", (Object)this.myKeyStore);
        }
        return this.myKeyStore;
    }

    protected KeyStore obtainKeyStore(final String storeFile, final boolean create) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<KeyStore>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyStore run() throws Exception {
                KeyStore ks1 = null;
                try (InputStream is = null;){
                    String name = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreName");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Initializing KeyStore: " + name), (Object[])new Object[0]);
                    }
                    String password = WSKeyStore.decodePassword(WSKeyStore.this.getProperty("com.ibm.ssl.keyStorePassword"));
                    String type = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreType");
                    boolean fileBased = Boolean.parseBoolean(WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreFileBased"));
                    String provider = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreProvider");
                    boolean tokenEnabled = Boolean.parseBoolean(WSKeyStore.this.getProperty("com.ibm.ssl.tokenEnabled"));
                    String createStash = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreCreateCMSStash");
                    String keyStoreLocation = null;
                    if (fileBased && storeFile != null) {
                        long start;
                        File kFile;
                        keyStoreLocation = WSKeyStore.this.cfgSvc.resolveString(storeFile);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("File path for store: " + keyStoreLocation), (Object[])new Object[0]);
                        }
                        if ((kFile = new File(keyStoreLocation).getAbsoluteFile()).exists()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Loading keyStore (filebased)", (Object[])new Object[0]);
                            }
                            JSSEProvider jsseProvider = JSSEProviderFactory.getInstance();
                            ks1 = jsseProvider.getKeyStoreInstance(type, provider);
                            is = new URL("file:" + kFile.getCanonicalPath()).openStream();
                            if (password.isEmpty() && (type.equalsIgnoreCase("JCEKS") || type.equalsIgnoreCase("JKS"))) {
                                ks1.load(is, null);
                            } else {
                                ks1.load(is, password.toCharArray());
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Enumeration<String> e = ks1.aliases();
                                while (e.hasMoreElements()) {
                                    Tr.debug((TraceComponent)tc, (String)("alias: " + e.nextElement()), (Object[])new Object[0]);
                                }
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"do_getKeyStore (initialized)", (Object[])new Object[0]);
                            }
                            KeyStore keyStore = ks1;
                            return keyStore;
                        }
                        if (create || name.endsWith("key.jks")) {
                            start = System.currentTimeMillis();
                            Tr.info((TraceComponent)tc, (String)"ssl.create.certificate.start", (Object[])new Object[0]);
                            File parentFile = kFile.getParentFile();
                            if (parentFile == null || parentFile.isDirectory() || parentFile.mkdirs()) {
                                try {
                                    String serverName = WSKeyStore.this.cfgSvc.getServerName();
                                    DefaultSSLCertificateCreator certCreator = DefaultSSLCertificateFactory.getDefaultSSLCertificateCreator();
                                    certCreator.createDefaultSSLCertificate(keyStoreLocation, password, 365, new DefaultSubjectDN(WSKeyStore.this.genKeyHostName, serverName).getSubjectDN(), 2048, "SHA256withRSA");
                                }
                                catch (IllegalArgumentException e) {
                                    Tr.error((TraceComponent)tc, (String)"ssl.create.certificate.password.error", (Object[])new Object[0]);
                                    throw e;
                                }
                                catch (CertificateException e) {
                                    Tr.error((TraceComponent)tc, (String)"ssl.create.certificate.error", (Object[])new Object[]{keyStoreLocation});
                                    throw e;
                                }
                            } else {
                                Tr.error((TraceComponent)tc, (String)"ssl.create.certificate.error", (Object[])new Object[]{keyStoreLocation});
                                throw new SSLException("KeyStore \"" + keyStoreLocation + "\" could not be created.");
                            }
                            JSSEProvider jsseProvider = JSSEProviderFactory.getInstance();
                            ks1 = jsseProvider.getKeyStoreInstance(type, provider);
                            is = new URL("file:" + kFile.getCanonicalPath()).openStream();
                            ks1.load(is, password.toCharArray());
                        } else {
                            throw new SSLException("KeyStore \"" + keyStoreLocation + "\" does not exist.");
                        }
                        Tr.audit((TraceComponent)tc, (String)"ssl.create.certificate.end", (Object[])new Object[]{TimestampUtils.getElapsedTime((long)start), keyStoreLocation});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"do_getKeyStore (loaded)", (Object[])new Object[0]);
                        }
                        KeyStore keyStore = ks1;
                        return keyStore;
                    }
                    if (tokenEnabled) {
                        WSPKCSInKeyStore pKS = null;
                        pKS = pkcsStoreList.insert(type, storeFile, password, true, provider);
                        if (pKS != null) {
                            ks1 = pKS.getKS();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"do_getKeyStore (created and initialized)", (Object[])new Object[0]);
                            }
                            KeyStore keyStore = ks1;
                            return keyStore;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"do_getKeyStore (Could not get KeyStore from pkcsStoreList)", (Object[])new Object[0]);
                        }
                        throw new SSLException("Could not get KeyStore instance for hardware device.");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Loading keyStore (nonfilebased)", (Object[])new Object[0]);
                    }
                    try {
                        is = WSKeyStore.openKeyStore(storeFile);
                    }
                    catch (Exception e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"KeyStore does not exist", (Object[])new Object[0]);
                        }
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"do_getKeyStore", (Object)this);
                    }
                    ks1 = JSSEProviderFactory.getInstance().getKeyStoreInstance(type, provider);
                    if (null == is && (create || name != null && (name.endsWith("DefaultKeyStore") || name.endsWith("DefaultTrustStore") || name.endsWith("DefaultRootStore") || name.endsWith("DefaultDeletedStore") || name.endsWith("DefaultSignersStore") || name.endsWith("LTPAKeys")))) {
                        ks1.load(null, password.toCharArray());
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"do_getKeyStore (loaded)", (Object[])new Object[0]);
                        }
                        KeyStore e = ks1;
                        return e;
                    }
                    ks1.load(is, password.toCharArray());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Enumeration<String> e = ks1.aliases();
                        while (e.hasMoreElements()) {
                            Tr.debug((TraceComponent)tc, (String)("alias: " + e.nextElement()), (Object[])new Object[0]);
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"do_getKeyStore (initialized)", (Object[])new Object[0]);
                    }
                    KeyStore keyStore = ks1;
                    return keyStore;
                }
            }
        });
    }

    public KeyStore getKeyStore(boolean reinitialize, boolean createIfNotPresent) throws Exception {
        if (this.myKeyStore == null || reinitialize) {
            this.myKeyStore = this.do_getKeyStore(reinitialize, createIfNotPresent);
        }
        return this.myKeyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws Exception {
        block15: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"store", (Object[])new Object[0]);
            }
            try {
                String name = this.getProperty("com.ibm.ssl.keyStoreName");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Storing KeyStore " + name), (Object[])new Object[0]);
                }
                String SSLKeyFile = this.getProperty("com.ibm.ssl.keyStore");
                String SSLKeyPassword = WSKeyStore.decodePassword(this.getProperty("com.ibm.ssl.keyStorePassword"));
                String SSLKeyStoreType = this.getProperty("com.ibm.ssl.keyStoreType");
                boolean readOnly = Boolean.parseBoolean(this.getProperty("com.ibm.ssl.keyStoreReadOnly"));
                boolean fileBased = Boolean.parseBoolean(this.getProperty("com.ibm.ssl.keyStoreFileBased"));
                String SSLKeyStoreStash = this.getProperty("com.ibm.ssl.keyStoreCreateCMSStash");
                KeyStore ks = this.getKeyStore(false, false);
                if (ks == null || readOnly) break block15;
                if (fileBased) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Storing filebased keystore type " + SSLKeyStoreType), (Object[])new Object[0]);
                    }
                    String keyStoreLocation = SSLKeyFile;
                    String keyStorePassword = SSLKeyPassword;
                    try (FileOutputStream fos = new FileOutputStream(keyStoreLocation);){
                        ks.store(fos, keyStorePassword.toCharArray());
                        break block15;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Storing non-filebased keystore type " + SSLKeyStoreType), (Object[])new Object[0]);
                }
                String keyStoreLocation = SSLKeyFile;
                String keyStorePassword = SSLKeyPassword;
                URL ring = new URL(keyStoreLocation);
                URLConnection ringConnect = ring.openConnection();
                try (OutputStream fos = ringConnect.getOutputStream();){
                    ks.store(fos, keyStorePassword.toCharArray());
                }
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception storing KeyStore; " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"store", (Object)this);
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"store");
        }
    }

    public void initializeKeyStore(boolean reinitialize) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeKeyStore", (Object[])new Object[0]);
        }
        try {
            String initAtStartup = this.getProperty("com.ibm.ssl.keyStoreInitializeAtStartup");
            boolean createIfMissing = "defaultKeyStore".equals(this.getProperty("id"));
            if (Boolean.parseBoolean(initAtStartup) || reinitialize) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Initializing keystore at startup.", (Object[])new Object[0]);
                }
                this.getKeyStore(reinitialize, createIfMissing);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception initializing KeyStore; " + e), (Object[])new Object[0]);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeKeyStore");
        }
    }

    public void provideExpirationWarnings(int daysBeforeExpireWarning, String keyStoreName) throws Exception {
        KeyStore keystore;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"provideExpirationWarnings", (Object[])new Object[]{daysBeforeExpireWarning});
        }
        if ((keystore = this.getKeyStore(false, false)) != null) {
            try {
                Enumeration<String> e = keystore.aliases();
                if (e != null) {
                    while (e.hasMoreElements()) {
                        Certificate[] cert_chain;
                        String alias = e.nextElement();
                        if (null == alias || null == (cert_chain = keystore.getCertificateChain(alias))) continue;
                        for (int i = 0; i < cert_chain.length; ++i) {
                            this.printWarning(daysBeforeExpireWarning, keyStoreName, alias, (X509Certificate)cert_chain[i]);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception validating KeyStore expirations; " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"provideExpirationWarnings", (Object)this);
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"provideExpirationWarnings");
        }
    }

    public void printWarning(int daysBeforeExpireWarning, String keyStoreName, String alias, X509Certificate cert) {
        try {
            long millisDelta = (long)daysBeforeExpireWarning * 24L * 60L * 60L * 1000L;
            long millisBeforeExpiration = cert.getNotAfter().getTime() - System.currentTimeMillis();
            long daysLeft = millisBeforeExpiration / 1000L / 60L / 60L / 24L;
            if (millisBeforeExpiration < 0L) {
                Tr.error((TraceComponent)tc, (String)"ssl.expiration.expired.CWPKI0017E", (Object[])new Object[]{alias, keyStoreName});
            } else if (millisBeforeExpiration < millisDelta) {
                Tr.warning((TraceComponent)tc, (String)"ssl.expiration.warning.CWPKI0016W", (Object[])new Object[]{alias, keyStoreName, daysLeft});
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The certificate with alias " + alias + " from keyStore " + keyStoreName + " has " + daysLeft + " days left before expiring."), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception reading KeyStore certificates during expiration check; " + e), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"printWarning", (Object)this);
        }
    }

    public static String decodePassword(@Sensitive String password) {
        String decodedPassword;
        block6: {
            decodedPassword = null;
            if (password == null || password.isEmpty()) {
                return password;
            }
            try {
                decodedPassword = PasswordUtil.decode((String)password);
                if (decodedPassword != null && !defaultKeyStoreWarningIssued && decodedPassword.equals("WebAS")) {
                    Tr.warning((TraceComponent)tc, (String)"ssl.default.password.in.use.CWPKI0041W", (Object[])new Object[0]);
                    defaultKeyStoreWarningIssued = true;
                }
            }
            catch (InvalidPasswordDecodingException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Password was not decoded.", (Object[])new Object[0]);
                }
                decodedPassword = password;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)WSKeyStore.class.getName(), (String)"decodePassword");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)("Exception decoding KeyStore password; " + e), (Object[])new Object[0]);
            }
        }
        return decodedPassword;
    }

    public static InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("openKeyStore: " + fileName), (Object[])new Object[0]);
        }
        URL urlFile = null;
        File kfile = new File(fileName);
        if (kfile.exists() && kfile.length() == 0L) {
            throw new IOException("Keystore file exists, but is empty: " + fileName);
        }
        urlFile = !kfile.exists() ? new URL(fileName) : new URL("file:" + kfile.getCanonicalPath());
        InputStream fis = urlFile.openStream();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("openKeyStore: " + (null != fis)));
        }
        return fis;
    }

    @Override
    public String toString() {
        Enumeration<?> e = this.propertyNames();
        StringBuilder buf = new StringBuilder(128);
        buf.append("WSKeyStore.toString() {\n");
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = this.getProperty(propName);
            if (propName.toLowerCase().indexOf("password") != -1) {
                buf.append(propName);
                buf.append('=');
                buf.append(SSLConfigManager.mask(value));
                buf.append('\n');
                continue;
            }
            buf.append(propName);
            buf.append('=');
            buf.append(value);
            buf.append('\n');
        }
        buf.append('}');
        return buf.toString();
    }

    public void setCertificateEntry(String alias, Certificate cert) throws KeyStoreException, KeyException {
        KeyStoreManager mgr;
        block15: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"setCertificateEntry", (Object[])new Object[]{alias, cert});
            }
            if (Boolean.parseBoolean(this.getProperty("com.ibm.ssl.keyStoreReadOnly"))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Unable to update readonly store", (Object[])new Object[0]);
                }
                throw new KeyStoreException("Unable to add to read-only store");
            }
            mgr = KeyStoreManager.getInstance();
            try {
                KeyStore jKeyStore = this.getKeyStore(false, false);
                if (null == jKeyStore) {
                    String keyStoreLocation = this.getProperty("com.ibm.ssl.keyStore");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Cannot load the Java keystore at location \"" + keyStoreLocation + "\""), (Object[])new Object[0]);
                    }
                    throw new KeyStoreException("Cannot load the Java keystore at location \"" + keyStoreLocation + "\"");
                }
                jKeyStore.setCertificateEntry(alias, cert);
                try {
                    this.store();
                }
                catch (IOException e) {
                    String ksType = this.getProperty("com.ibm.ssl.keyStoreType");
                    if (ksType.equals("JCERACFKS") || ksType.equals("JCECCARACFKS") || ksType.equals("JCEHYBRIDRACFKS")) {
                        KeyStore ks = this.getKeyStore(true, false);
                        if (mgr.checkIfSignerAlreadyExistsInTrustStore((X509Certificate)cert, ks)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Certificate already exists in RACF: " + e.getMessage()), (Object[])new Object[0]);
                            }
                            break block15;
                        }
                        throw new KeyException(e.getMessage(), e);
                    }
                    throw new KeyException(e.getMessage(), e);
                }
            }
            catch (KeyStoreException kse) {
                throw kse;
            }
            catch (KeyException ke) {
                throw ke;
            }
            catch (Exception e) {
                throw new KeyException(e.getMessage(), e);
            }
        }
        AbstractJSSEProvider.clearSSLContextCache();
        mgr.clearJavaKeyStoresFromKeyStoreMap();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setCertificateEntry");
        }
    }

    public Key getKey(String alias, @Sensitive String keyPassword) throws KeyStoreException, CertificateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey: " + alias), (Object[])new Object[0]);
        }
        Key key = null;
        try {
            SerializableProtectedString keyPWD = null;
            KeyStore jKeyStore = this.getKeyStore(false, false);
            if (jKeyStore == null) {
                throw new KeyStoreException("The keystore [" + this.name + "] is not present in the configuration");
            }
            if (!jKeyStore.isKeyEntry(alias)) {
                throw new CertificateException("The alias [" + alias + "] is not present in the KeyStore as a key entry");
            }
            if (keyPassword != null) {
                keyPWD = new SerializableProtectedString(keyPassword.toCharArray());
            } else {
                keyPWD = this.getKeyPassword(alias);
                if (keyPWD == null) {
                    keyPWD = this.password;
                }
            }
            String decodedPassword = WSKeyStore.decodePassword(new String(keyPWD.getChars()));
            key = jKeyStore.getKey(alias, decodedPassword.toCharArray());
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (KeyStoreException e) {
            throw e;
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)"ssl.key.error.CWPKI0812E", (Object[])new Object[]{alias, this.name, e.getMessage()});
            throw new KeyStoreException("Unexpected error while loading the requested private key for alias [" + alias + "] from keystore: " + this.name, e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getKey");
        }
        return key;
    }

    public Enumeration<String> aliases() throws KeyStoreException, KeyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"aliases", (Object[])new Object[0]);
        }
        Enumeration<String> aliases = null;
        try {
            KeyStore jKeyStore = this.getKeyStore(false, false);
            if (jKeyStore == null) {
                throw new KeyStoreException("The keystore [" + this.name + "] is not present in the configuration");
            }
            aliases = jKeyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new KeyException(ex.getMessage(), ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("aliases: " + aliases));
        }
        return aliases;
    }

    public boolean isKeyEntry(String alias) throws KeyStoreException, KeyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isKeyEntry: " + alias), (Object[])new Object[0]);
        }
        boolean isKey = false;
        try {
            KeyStore jKeyStore = this.getKeyStore(false, false);
            if (jKeyStore == null) {
                throw new KeyStoreException("The keystore [" + this.name + "] is not present in the configuration");
            }
            isKey = jKeyStore.isKeyEntry(alias);
        }
        catch (KeyStoreException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new KeyException(ex.getMessage(), ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isKeyEntry: " + isKey));
        }
        return isKey;
    }

    private SerializableProtectedString getKeyPassword(String alias) {
        SerializableProtectedString keyPass;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getKeyPassword " + alias), (Object[])new Object[0]);
        }
        if ((keyPass = this.certAliasInfo.get(alias)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getKeyPassword entry found.", (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getKeyPassword -> null", (Object[])new Object[0]);
        }
        return keyPass;
    }

    protected void clearJavaKeyStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clearJavaKeyStore", (Object[])new Object[0]);
        }
        this.myKeyStore = null;
    }

    public boolean isOracleVendor() {
        String vendorName = this.getSystemProperty("java.vendor");
        boolean isOracle = false;
        if (vendorName != null && vendorName.toLowerCase().contains("oracle")) {
            isOracle = true;
        }
        return isOracle;
    }

    public String getSystemProperty(final String propName) {
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propName);
            }
        });
        return value;
    }
}

