/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.protocol.LibertySSLSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class WSSocket
extends SSLSocket {
    private static final TraceComponent tc = Tr.register(WSSocket.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    protected Socket socket;

    public WSSocket(Socket s) {
        this.socket = s;
    }

    @Override
    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return this.socket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.socket.sendUrgentData(data);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int l) throws SocketException {
        this.socket.setSoLinger(on, l);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public String toString() {
        return this.socket.toString();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.socket.bind(bindpoint);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connect", (Object)new Object[]{endpoint});
        }
        this.socket.connect(endpoint);
        if (endpoint instanceof InetSocketAddress) {
            InetSocketAddress ep = (InetSocketAddress)endpoint;
            int port = ep.getPort();
            String host = ep.getHostName();
            SSLSocketFactory factory = (SSLSocketFactory)LibertySSLSocketFactory.getDefault();
            this.socket = factory.createSocket(this.socket, host, port, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connect");
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connect", (Object)new Object[]{endpoint, timeout});
        }
        this.socket.connect(endpoint, timeout);
        if (endpoint instanceof InetSocketAddress) {
            InetSocketAddress ep = (InetSocketAddress)endpoint;
            int port = ep.getPort();
            String host = ep.getHostName();
            SSLSocketFactory factory = (SSLSocketFactory)LibertySSLSocketFactory.getDefault();
            this.socket = factory.createSocket(this.socket, host, port, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connect");
        }
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).addHandshakeCompletedListener(listener);
        }
    }

    @Override
    public String[] getEnabledCipherSuites() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getEnabledCipherSuites();
        }
        return null;
    }

    @Override
    public String[] getEnabledProtocols() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getEnabledProtocols();
        }
        return null;
    }

    @Override
    public boolean getEnableSessionCreation() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getEnableSessionCreation();
        }
        return false;
    }

    @Override
    public boolean getNeedClientAuth() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getNeedClientAuth();
        }
        return false;
    }

    @Override
    public SSLSession getSession() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getSession();
        }
        return null;
    }

    @Override
    public SSLParameters getSSLParameters() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getSSLParameters();
        }
        return null;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getSupportedCipherSuites();
        }
        return null;
    }

    @Override
    public String[] getSupportedProtocols() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getSupportedProtocols();
        }
        return null;
    }

    @Override
    public boolean getUseClientMode() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getUseClientMode();
        }
        return false;
    }

    @Override
    public boolean getWantClientAuth() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getWantClientAuth();
        }
        return false;
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).removeHandshakeCompletedListener(listener);
        }
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).setEnabledCipherSuites(suites);
        }
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).setEnabledProtocols(protocols);
        }
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).setEnableSessionCreation(flag);
        }
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).setNeedClientAuth(need);
        }
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).setSSLParameters(params);
        }
    }

    @Override
    public void setUseClientMode(boolean mode) {
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).setUseClientMode(mode);
        }
    }

    @Override
    public void setWantClientAuth(boolean want) {
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).setWantClientAuth(want);
        }
    }

    @Override
    public void startHandshake() throws IOException {
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)this.socket).startHandshake();
        }
    }
}

