/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.ClientManager;
import org.apache.yoko.orb.OB.DispatchStrategyFactory;
import org.apache.yoko.orb.OB.DispatchStrategyFactory_impl;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OBPortableServer.POAManager;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactoryHelper;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory_impl;
import org.apache.yoko.orb.OBPortableServer.POA_impl;
import org.apache.yoko.orb.PortableServer.Current_impl;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerFactoryPackage.ManagerAlreadyExists;

public final class ORBControl {
    ORBInstance orbInstance_;
    private volatile State state;
    private final CountDownLatch shutdown = new CountDownLatch(1);
    private POA rootPOA_;
    private volatile Thread mainThread_;
    private long shutdownTimeout_ = 2L;

    private synchronized void completeServerShutdown() {
        if (this.shutdown.getCount() != 0L || this.state == State.SERVER_SHUTDOWN) {
            return;
        }
        Assert._OB_assert(this.state != State.CLIENT_SHUTDOWN && this.state != State.DESTROYED);
        Assert._OB_assert(this.state == State.NOT_RUNNING || this.mainThread_ == Thread.currentThread());
        POAManagerFactory_impl factory = (POAManagerFactory_impl)this.orbInstance_.getPOAManagerFactory();
        factory._OB_deactivate();
        this.waitForServerThreads();
        this.notifyAll();
    }

    private void waitForServerThreads() {
        this.shutdownExecutor(this.orbInstance_.getServerPhaser(), this.orbInstance_.getServerExecutor());
        DispatchStrategyFactory dsFactory = this.orbInstance_.getDispatchStrategyFactory();
        DispatchStrategyFactory_impl dsFactoryImpl = (DispatchStrategyFactory_impl)dsFactory;
        dsFactoryImpl._OB_destroy();
        this.state = State.SERVER_SHUTDOWN;
        if (this.rootPOA_ != null) {
            this.rootPOA_.destroy(true, true);
            this.rootPOA_ = null;
        }
    }

    private synchronized void validateState() {
        if (this.state == State.DESTROYED) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        if (this.state == State.SERVER_SHUTDOWN || this.state == State.CLIENT_SHUTDOWN) {
            throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
        }
        if (this.state == State.NOT_RUNNING) {
            this.mainThread_ = Thread.currentThread();
            this.state = State.RUNNING;
        }
    }

    private synchronized void blockServerShutdownComplete() {
        while (this.state == State.RUNNING) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ORBControl() {
        this.state = State.NOT_RUNNING;
    }

    public synchronized void destroy() {
        Assert._OB_assert(this.state == State.CLIENT_SHUTDOWN);
        this.state = State.DESTROYED;
        this.orbInstance_ = null;
    }

    public void setORBInstance(ORBInstance instance) {
        this.orbInstance_ = instance;
    }

    public boolean workPending() {
        this.validateState();
        if (this.mainThread_ != Thread.currentThread()) {
            return false;
        }
        return this.shutdown.getCount() == 0L;
    }

    public void performWork() {
        this.validateState();
        if (this.mainThread_ != Thread.currentThread()) {
            return;
        }
        this.completeServerShutdown();
    }

    public void run() {
        this.validateState();
        if (this.mainThread_ != Thread.currentThread()) {
            this.blockServerShutdownComplete();
            return;
        }
        if (this.shutdown.getCount() == 0L) {
            this.completeServerShutdown();
            return;
        }
        do {
            try {
                this.shutdown.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.completeServerShutdown();
        } while (this.state == State.RUNNING);
    }

    public void shutdownServer(boolean waitForCompletion) {
        if (this.state == State.DESTROYED) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        if (this.state == State.SERVER_SHUTDOWN || this.state == State.CLIENT_SHUTDOWN) {
            throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
        }
        if (waitForCompletion) {
            boolean inInvocation = false;
            try {
                InitialServiceManager initialServiceManager = this.orbInstance_.getInitialServiceManager();
                Object o = initialServiceManager.resolveInitialReferences("POACurrent");
                Current_impl current = (Current_impl)o;
                inInvocation = current._OB_inUpcall();
                if (inInvocation) {
                    try {
                        POA_impl p = (POA_impl)current.get_POA();
                        inInvocation = p._OB_ORBInstance() == this.orbInstance_;
                    }
                    catch (NoContext noContext) {}
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (InvalidName invalidName) {
                // empty catch block
            }
            if (inInvocation) {
                throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446339), 1330446339, CompletionStatus.COMPLETED_NO);
            }
        }
        this.shutdown.countDown();
        if (!waitForCompletion) {
            return;
        }
        if (this.state == State.RUNNING && this.mainThread_ != Thread.currentThread()) {
            this.blockServerShutdownComplete();
            return;
        }
        this.completeServerShutdown();
    }

    public synchronized void shutdownServerClient() {
        if (this.state == State.DESTROYED) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        if (this.state == State.CLIENT_SHUTDOWN) {
            return;
        }
        if (this.orbInstance_ != null) {
            if (this.state != State.SERVER_SHUTDOWN) {
                this.shutdownServer(true);
            }
            Assert._OB_assert(this.state == State.SERVER_SHUTDOWN);
            ClientManager clientManager = this.orbInstance_.getClientManager();
            clientManager.destroy();
            this.shutdownExecutor(this.orbInstance_.getClientPhaser(), this.orbInstance_.getClientExecutor());
        }
        this.state = State.CLIENT_SHUTDOWN;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownExecutor(Phaser phaser, ExecutorService executor) {
        int phase = phaser.arrive();
        try {
            phaser.awaitAdvanceInterruptibly(phase, this.shutdownTimeout_, TimeUnit.SECONDS);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException timeoutException) {
        }
        finally {
            phaser.forceTermination();
        }
        executor.shutdownNow();
    }

    public void initializeRootPOA(ORB orb) {
        String serverId = this.orbInstance_.getServerId();
        if (serverId.length() == 0) {
            serverId = "_RootPOA";
        }
        InitialServiceManager ism = this.orbInstance_.getInitialServiceManager();
        POAManagerFactory factory = null;
        try {
            factory = POAManagerFactoryHelper.narrow(ism.resolveInitialReferences("POAManagerFactory"));
        }
        catch (InvalidName ex) {
            Assert._OB_assert(ex);
        }
        POAManager manager = null;
        org.omg.PortableServer.POAManager[] managers = factory.list();
        for (int i = 0; i < managers.length; ++i) {
            if (!managers[i].get_id().equals("RootPOAManager")) continue;
            manager = (POAManager)managers[i];
            break;
        }
        if (manager == null) {
            try {
                Policy[] emptyPl = new Policy[]{};
                manager = (POAManager)factory.create_POAManager("RootPOAManager", emptyPl);
            }
            catch (ManagerAlreadyExists ex) {
                Assert._OB_assert(ex);
            }
            catch (PolicyError ex) {
                Assert._OB_assert(ex);
            }
        }
        POA_impl root = new POA_impl(orb, this.orbInstance_, serverId, manager);
        root._OB_addPolicyFactory();
        this.rootPOA_ = root;
        try {
            ism.addInitialReference("RootPOA", (Object)root, true);
        }
        catch (InvalidName ex) {
            Assert._OB_assert(ex);
        }
        POAManagerFactory_impl factoryImpl = (POAManagerFactory_impl)factory;
        factoryImpl._OB_initializeIMR(root, this);
    }

    private static enum State {
        NOT_RUNNING,
        RUNNING,
        SERVER_SHUTDOWN,
        CLIENT_SHUTDOWN,
        DESTROYED;

    }
}

