/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.UnknownException;
import org.omg.SendingContext.CodeBase;

public class UnresolvedException
extends UnknownException {
    private static final Logger LOGGER = Logger.getLogger(UnresolvedException.class.getName());
    private final UNKNOWN ex;
    private final byte[] data;
    private final CodeConverters converters;
    private final CodeBase sendingContextRuntime;
    private final String codebase;

    UnresolvedException(UNKNOWN ex, byte[] data, InputStream is) {
        super((Throwable)ex);
        this.completed = ex.completed;
        this.minor = ex.minor;
        this.ex = ex;
        this.data = data;
        this.converters = is._OB_codeConverters();
        this.sendingContextRuntime = is.__getSendingContextRuntime();
        this.codebase = is.__getCodeBase();
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public SystemException resolve() {
        block45: {
            Buffer buf = new Buffer(this.data, this.data.length);
            try {
                Throwable throwable = null;
                try (InputStream in = new InputStream(buf, 0, false, this.converters, GiopVersion.GIOP1_2);){
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Unpacking Unknown Exception Info%n%s", in.dumpData()));
                    }
                    try {
                        in.__setSendingContextRuntime(this.sendingContextRuntime);
                        in.__setCodeBase(this.codebase);
                        in._OB_readEndian();
                        Throwable t = (Throwable)in.read_value();
                        UnknownException x = new UnknownException(t);
                        x.completed = this.ex.completed;
                        x.minor = this.ex.minor;
                        UnknownException unknownException = x;
                        return unknownException;
                    }
                    catch (Exception e) {
                        block46: {
                            String dump = in.dumpData();
                            int curPos = in.buf_.pos();
                            in.buf_.pos(0);
                            String fullDump = in.dumpData();
                            in.buf_.pos(curPos);
                            try (StringWriter sw = new StringWriter();
                                 PrintWriter pw = new PrintWriter(sw);){
                                e.printStackTrace(pw);
                                LOGGER.severe(String.format("%s:%n%s:%n%s%n%s:%n%s%n%s:%n%s", "Exception reading UnknownExceptionInfo service context", "Remaining data", dump, "Full data", fullDump, "Exception thrown", sw.toString()));
                            }
                            if (in == null) break block45;
                            if (throwable == null) break block46;
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block45;
                        }
                        in.close();
                        break block45;
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.ex;
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        throw new NotSerializableException();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new NotSerializableException();
    }
}

