/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.util;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class AutoLock
implements AutoCloseable {
    final AtomicReference<Lock> lockRef;
    final Lock downgradeLock;
    final int downgradeHeld;

    AutoLock(Lock lock) {
        this(lock, null, 0);
    }

    AutoLock(Lock lock, Lock downgradeLock, int downgradeHeld) {
        this.lockRef = new AtomicReference<Lock>(lock);
        this.downgradeLock = downgradeLock;
        this.downgradeHeld = downgradeHeld;
        for (int i = downgradeHeld; i > 0; --i) {
            downgradeLock.unlock();
        }
        lock.lock();
    }

    @Override
    public void close() {
        Lock lock = this.lockRef.getAndSet(null);
        if (lock == null) {
            return;
        }
        for (int i = 0; i < this.downgradeHeld; ++i) {
            this.downgradeLock.lock();
        }
        lock.unlock();
    }

    public Condition newCondition() {
        return this.lockRef.get().newCondition();
    }

    public boolean downgrade() {
        if (this.downgradeLock == null) {
            return false;
        }
        Lock oldLock = this.lockRef.getAndSet(this.downgradeLock);
        if (oldLock == this.downgradeLock) {
            return false;
        }
        this.downgradeLock.lock();
        oldLock.unlock();
        return true;
    }
}

