/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.deliverydelay;

import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.deliverydelay.DeliveryDelayIndex;
import com.ibm.ws.sib.msgstore.deliverydelay.DeliveryDelayable;
import com.ibm.ws.sib.msgstore.deliverydelay.DeliveryDelayableReference;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DeliveryDelayManager
implements AlarmListener,
XmlConstants {
    private static TraceComponent tc = SibTr.register(DeliveryDelayManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final int BATCH_SIZE = 20;
    private static final int CLEANUP_EVERY_N_CYCLES = 5;
    private static final int MAX_DIAG_LOG = 30;
    private static final int MAX_CONSECUTIVE_FAILURES = 3;
    private final DeliveryDelayManagerLock lockObject = new DeliveryDelayManagerLock();
    private DeliveryDelayIndex deliveryDelayIndex = null;
    private Alarm deliveryDelayAlarm = null;
    private volatile boolean runEnabled = false;
    private volatile boolean addEnabled = true;
    private volatile boolean alarmScheduled = false;
    private volatile boolean alarming = false;
    private long interval = 0L;
    private byte consecutiveFailures = 0;
    private MessageStoreImpl messageStore = null;
    private JsMessagingEngine messagingEngine = null;
    private Exception lastException = null;
    private long lastExceptionTime = 0L;
    private long deliveryDelayManagerStartTime = 0L;
    private long deliveryDelayManagerStopTime = 0L;
    private long startTime = 0L;
    private boolean cleanupDeletedItems = false;
    private int diagIndex = 0;
    private final long[] alarmTime = new long[30];
    private final long[] logIndexSize = new long[30];
    private final long[] logProcessed = new long[30];
    private final long[] logUnlocked = new long[30];
    private final long[] logRemain = new long[30];
    private final long[] logGone = new long[30];
    private final long[] logCleaned = new long[30];
    private int countForCleanup = 0;
    private int batchCount = 0;
    private int cleanupLimit = 5;

    public DeliveryDelayManager(MessageStoreImpl ms) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.messageStore = ms;
        this.deliveryDelayIndex = new DeliveryDelayIndex();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addDeliveryDelayable(DeliveryDelayable deliveryDelayable) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addDeliveryDelayable", (Object)("objId=" + (deliveryDelayable == null ? "null" : String.valueOf(deliveryDelayable.deliveryDelayableGetID())) + " addEnabled=" + this.addEnabled));
        }
        boolean reply = false;
        if (this.addEnabled && deliveryDelayable != null) {
            long deliveryDelayTime = deliveryDelayable.deliveryDelayableGetDeliveryDelayTime();
            DeliveryDelayableReference delayedDeliverableRef = new DeliveryDelayableReference(deliveryDelayable);
            delayedDeliverableRef.setDeliveryDelayTime(deliveryDelayTime);
            if (deliveryDelayable.deliveryDelayableIsInStore()) {
                DeliveryDelayManagerLock deliveryDelayManagerLock = this.lockObject;
                synchronized (deliveryDelayManagerLock) {
                    reply = this.deliveryDelayIndex.put(delayedDeliverableRef);
                    if (reply) {
                        boolean scheduled = false;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Before scheduleAlarm", (Object)("deliveryDelayIndexSize=" + this.deliveryDelayIndex.size() + " runEnabled" + this.runEnabled));
                        }
                        if (this.runEnabled && this.deliveryDelayIndex.size() == 1) {
                            this.scheduleAlarm(this.interval);
                            scheduled = true;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Added: DDT=" + delayedDeliverableRef.getDeliveryDelayTime() + ", objId=" + delayedDeliverableRef.getID() + ", scheduled=" + scheduled));
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Duplicate deliveyDelayable: DDT=" + delayedDeliverableRef.getDeliveryDelayTime() + ", objId=" + delayedDeliverableRef.getID()));
                        }
                        this.runEnabled = false;
                        Object[] o = new Object[]{delayedDeliverableRef.getDeliveryDelayTime() + " : " + delayedDeliverableRef.getID()};
                        SevereMessageStoreException e = new SevereMessageStoreException("DUPLICATE_DELIVERYDELAYABLE_SIMS2010", o);
                        this.lastException = e;
                        this.lastExceptionTime = DeliveryDelayManager.timeNow();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"addDeliveryDelayable");
                        }
                        throw e;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addDeliveryDelayable", (Object)("reply=" + reply));
        }
        return reply;
    }

    public final boolean isRunning() {
        return this.runEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeDeliveryDelayable(DeliveryDelayable deliveryDelayable) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeDeliveryDelayable", (Object)("objId=" + (deliveryDelayable == null ? "null" : String.valueOf(deliveryDelayable.deliveryDelayableGetID())) + " ET=" + (deliveryDelayable == null ? "null" : String.valueOf(deliveryDelayable.deliveryDelayableGetDeliveryDelayTime())) + " addEnabled=" + this.addEnabled));
        }
        boolean reply = false;
        boolean cancelled = false;
        DeliveryDelayManagerLock deliveryDelayManagerLock = this.lockObject;
        synchronized (deliveryDelayManagerLock) {
            if (this.addEnabled && deliveryDelayable != null) {
                long deliveryDelay = deliveryDelayable.deliveryDelayableGetDeliveryDelayTime();
                DeliveryDelayableReference delayedDeliverableRef = new DeliveryDelayableReference(deliveryDelayable);
                delayedDeliverableRef.setDeliveryDelayTime(deliveryDelay);
                reply = this.deliveryDelayIndex.remove(delayedDeliverableRef);
                if (reply && this.deliveryDelayIndex.size() <= 0 && this.deliveryDelayAlarm != null) {
                    this.deliveryDelayAlarm.cancel();
                    this.alarmScheduled = false;
                    cancelled = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeDeliveryDelayable", (Object)("deliveryDelayIndexSize=" + this.deliveryDelayIndex.size() + " reply=" + reply + " cancelled=" + cancelled));
        }
        return reply;
    }

    public final int size() {
        int size = this.deliveryDelayIndex.size();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(long deliveryDelayScanInterval, JsMessagingEngine jsme) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)("interval=" + deliveryDelayScanInterval + " indexSize=" + this.deliveryDelayIndex.size()));
        }
        this.messagingEngine = jsme;
        if (deliveryDelayScanInterval >= 0L) {
            this.interval = deliveryDelayScanInterval;
        } else {
            String value = this.messageStore.getProperty("deliveryDelayScanInterval", "1000");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("Value from property=<" + value + ">"));
            }
            try {
                this.interval = Long.parseLong(value.trim());
            }
            catch (NumberFormatException e) {
                this.lastException = e;
                this.lastExceptionTime = DeliveryDelayManager.timeNow();
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("Unable to parse property: " + e));
                this.interval = 1000L;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("deliveryDelayScanInterval=" + this.interval));
        }
        DeliveryDelayManagerLock deliveryDelayManagerLock = this.lockObject;
        synchronized (deliveryDelayManagerLock) {
            if (this.interval < 1L) {
                this.runEnabled = false;
                this.addEnabled = false;
            } else if (this.deliveryDelayAlarm == null) {
                this.runEnabled = true;
                this.addEnabled = true;
                this.deliveryDelayManagerStartTime = DeliveryDelayManager.timeNow();
                if (this.deliveryDelayIndex.size() > 0) {
                    this.scheduleAlarm(this.interval);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"DeliveryDelayManager already started");
                }
                SevereMessageStoreException e = new SevereMessageStoreException("DELIVERYDELAYMANAGER_THREAD_ALREADY_RUNNING_SIMS2012");
                this.lastException = e;
                this.lastExceptionTime = DeliveryDelayManager.timeNow();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"start");
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)("runEnabled=" + this.runEnabled + " addEnabled=" + this.addEnabled + " interval=" + this.interval));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        DeliveryDelayManagerLock deliveryDelayManagerLock = this.lockObject;
        synchronized (deliveryDelayManagerLock) {
            this.addEnabled = false;
            if (this.runEnabled) {
                this.runEnabled = false;
                this.deliveryDelayManagerStopTime = DeliveryDelayManager.timeNow();
            }
            if (this.deliveryDelayAlarm != null) {
                this.deliveryDelayAlarm.cancel();
                this.deliveryDelayAlarm = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alarm(Object obj) {
        long remain;
        long gone;
        long cleaned;
        long unlocked;
        long processed;
        block63: {
            if (this.messagingEngine != null) {
                SibTr.push((Object)this.messagingEngine);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)("deliveryDelayIndexSize=" + this.deliveryDelayIndex.size()));
            }
            DeliveryDelayManagerLock deliveryDelayManagerLock = this.lockObject;
            synchronized (deliveryDelayManagerLock) {
                this.alarmScheduled = false;
                while (this.alarming) {
                    try {
                        this.lockObject.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.alarming = true;
            }
            ExternalLocalTransaction transaction = null;
            int indexUsed = 0;
            processed = 0L;
            unlocked = 0L;
            cleaned = 0L;
            gone = 0L;
            remain = 0L;
            try {
                DeliveryDelayManagerLock deliveryDelayManagerLock2;
                DeliveryDelayable deliveryDelayable;
                ++this.countForCleanup;
                if (this.countForCleanup >= this.cleanupLimit) {
                    this.countForCleanup = 0;
                    this.cleanupDeletedItems = true;
                } else {
                    this.cleanupDeletedItems = false;
                }
                this.startTime = System.currentTimeMillis();
                indexUsed = this.saveStartTime(this.startTime);
                DeliveryDelayableReference deliveryDelayableRef = null;
                DeliveryDelayManagerLock deliveryDelayManagerLock3 = this.lockObject;
                synchronized (deliveryDelayManagerLock3) {
                    this.deliveryDelayIndex.resetIterator();
                    deliveryDelayableRef = this.deliveryDelayIndex.next();
                }
                while (this.runEnabled && deliveryDelayableRef != null && deliveryDelayableRef.getDeliveryDelayTime() <= this.startTime) {
                    ++processed;
                    deliveryDelayable = (DeliveryDelayable)deliveryDelayableRef.get();
                    if (deliveryDelayable != null && deliveryDelayable.deliveryDelayableIsInStore()) {
                        if (transaction == null) {
                            transaction = this.messageStore.getTransactionFactory().createLocalTransaction();
                        }
                        if (deliveryDelayable.deliveryDelayableUnlock((PersistentTransaction)transaction, -56789L)) {
                            ++unlocked;
                            this.remove(deliveryDelayableRef, true);
                            ++this.batchCount;
                            if (this.batchCount >= 20) {
                                transaction.commit();
                                transaction = null;
                                this.batchCount = 0;
                            }
                        } else {
                            ++remain;
                        }
                    } else if (this.remove(deliveryDelayableRef, false)) {
                        ++gone;
                    }
                    deliveryDelayManagerLock2 = this.lockObject;
                    synchronized (deliveryDelayManagerLock2) {
                        deliveryDelayableRef = this.deliveryDelayIndex.next();
                    }
                }
                if (this.cleanupDeletedItems) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"DeliveryDelayManager cleanup in progress");
                    }
                    while (this.runEnabled && deliveryDelayableRef != null) {
                        deliveryDelayable = (DeliveryDelayable)deliveryDelayableRef.get();
                        if ((deliveryDelayable == null || !deliveryDelayable.deliveryDelayableIsInStore()) && this.remove(deliveryDelayableRef, false)) {
                            ++cleaned;
                        }
                        deliveryDelayManagerLock2 = this.lockObject;
                        synchronized (deliveryDelayManagerLock2) {
                            deliveryDelayableRef = this.deliveryDelayIndex.next();
                        }
                    }
                    if (cleaned < 10L && this.cleanupLimit < 100) {
                        this.cleanupLimit += 5;
                    } else if (cleaned > 1000L && this.cleanupLimit > 5) {
                        this.cleanupLimit = 5;
                    } else if (cleaned > 100L && this.cleanupLimit > 5) {
                        this.cleanupLimit -= 5;
                    }
                }
                if (transaction != null) {
                    if (this.batchCount == 0) {
                        transaction.rollback();
                    } else {
                        transaction.commit();
                        this.batchCount = 0;
                    }
                    transaction = null;
                }
                this.consecutiveFailures = 0;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.deliverydelay.DeliveryDelayManager.alarm", (String)"550", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"alarm", (Object)("DeliveryDelayManager thread exception: " + e));
                }
                this.consecutiveFailures = (byte)(this.consecutiveFailures + 1);
                this.lastException = e;
                this.lastExceptionTime = DeliveryDelayManager.timeNow();
                if (this.consecutiveFailures <= 3) break block63;
                DeliveryDelayManagerLock deliveryDelayManagerLock4 = this.lockObject;
                synchronized (deliveryDelayManagerLock4) {
                    this.runEnabled = false;
                    this.addEnabled = false;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)e);
                }
                throw new MessageStoreRuntimeException("DELIVERYDELAYMANAGER_DAEMON_TERMINATED_SIMS2011", new Object[]{e}, (Throwable)e);
            }
            finally {
                long currIndexSize = 0L;
                DeliveryDelayManagerLock deliveryDelayManagerLock5 = this.lockObject;
                synchronized (deliveryDelayManagerLock5) {
                    this.alarming = false;
                    currIndexSize = this.deliveryDelayIndex.size();
                    if (this.runEnabled) {
                        if (currIndexSize > 0L) {
                            this.scheduleAlarm(this.interval);
                        }
                    } else {
                        this.addEnabled = false;
                    }
                    this.lockObject.notifyAll();
                }
                this.logIndexSize[indexUsed] = currIndexSize;
                this.logProcessed[indexUsed] = processed;
                this.logUnlocked[indexUsed] = unlocked;
                this.logGone[indexUsed] = gone;
                this.logRemain[indexUsed] = remain;
                this.logCleaned[indexUsed] = cleaned;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)(" processed=" + processed + " gone=" + gone + " unlocked=" + unlocked + " remain=" + remain + " cleaned=" + cleaned + " DeliveryDelayIndexSize=" + this.deliveryDelayIndex.size() + " cleanupLimit=" + this.cleanupLimit + " alarmScheduled=" + this.alarmScheduled));
        }
        if (this.messagingEngine != null) {
            SibTr.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean remove(DeliveryDelayableReference deliveryDelayableReference, boolean unlocked) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object)(" deliveryDelayableReference=" + deliveryDelayableReference + " unlocked=" + unlocked + " deliveryDelayIndex=" + this.deliveryDelayIndex.size()));
        }
        boolean reply = false;
        DeliveryDelayManagerLock deliveryDelayManagerLock = this.lockObject;
        synchronized (deliveryDelayManagerLock) {
            reply = this.deliveryDelayIndex.remove();
        }
        if (reply) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Removed (" + (unlocked ? "unlocked" : "gone") + ") DDT=" + deliveryDelayableReference.getDeliveryDelayTime() + " objId=" + deliveryDelayableReference.getID() + " DeliveryDelayIndexSize=" + this.deliveryDelayIndex.size()));
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Did not remove from index:  DDT=" + deliveryDelayableReference.getDeliveryDelayTime() + " objId=" + deliveryDelayableReference.getID()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)("deliveryDelayIndex=" + this.deliveryDelayIndex.size() + " reply=" + reply));
        }
        return reply;
    }

    private int saveStartTime(long time) {
        int indexUsed = this.diagIndex;
        this.alarmTime[this.diagIndex++] = time;
        if (this.diagIndex >= 30) {
            this.diagIndex = 0;
        }
        return indexUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleAlarm(long timeOut) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("scheduleAlarm timeOut=" + timeOut));
        }
        DeliveryDelayManagerLock deliveryDelayManagerLock = this.lockObject;
        synchronized (deliveryDelayManagerLock) {
            if (!this.alarmScheduled && !this.alarming) {
                this.deliveryDelayAlarm = AlarmManager.createNonDeferrable((long)timeOut, (AlarmListener)this);
                this.alarmScheduled = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"scheduleAlarm", (Object)this.alarmScheduled);
        }
    }

    public static long timeNow() {
        return System.currentTimeMillis();
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd @ HH:mm:ss.SSS");
        String timeNow = dateFormat.format(new Date());
        writer.newLine();
        writer.startTag("deliveryDelayManager");
        writer.indent();
        writer.newLine();
        writer.taggedValue("timeNow", (Object)timeNow);
        writer.newLine();
        writer.taggedValue("interval", this.interval);
        writer.newLine();
        writer.taggedValue("addEnabled", (Object)this.addEnabled);
        writer.newLine();
        writer.taggedValue("runEnabled", (Object)this.runEnabled);
        writer.newLine();
        writer.taggedValue("cleanupFlag", (Object)this.cleanupDeletedItems);
        writer.newLine();
        writer.taggedValue("deliveryDelayManagerStartTime", (Object)dateFormat.format(new Date(this.deliveryDelayManagerStartTime)));
        writer.newLine();
        writer.taggedValue("deliveryDelayManagerStopTime", (Object)dateFormat.format(new Date(this.deliveryDelayManagerStopTime)));
        writer.newLine();
        writer.taggedValue("nextLogIndex", (long)this.diagIndex);
        writer.newLine();
        for (int i = 0; i < 30; ++i) {
            String str = "Cycle=" + i + (this.diagIndex == i ? ":*" : ": ") + dateFormat.format(new Date(this.alarmTime[i])) + " size=" + this.logIndexSize[i] + " processed=" + this.logProcessed[i] + " unlocked=" + this.logUnlocked[i] + " remain=" + this.logRemain[i] + " gone=" + this.logGone[i] + " cleaned=" + this.logCleaned[i];
            writer.taggedValue("info", (Object)str);
            writer.newLine();
        }
        writer.startTag("storedException");
        if (this.lastException == null) {
            writer.write("No exceptions recorded");
        } else {
            writer.indent();
            writer.newLine();
            writer.taggedValue("time", (Object)new Date(this.lastExceptionTime));
            writer.outdent();
            writer.write((Throwable)this.lastException);
            writer.newLine();
        }
        writer.endTag("storedException");
        writer.outdent();
        writer.newLine();
        writer.endTag("deliveryDelayManager");
    }

    private static final class DeliveryDelayManagerLock {
        private DeliveryDelayManagerLock() {
        }
    }
}

