/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JWKProvider;
import com.ibm.ws.security.common.jwk.interfaces.JSONWebKey;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.internal.BuilderImpl;
import com.ibm.ws.security.jwt.internal.JwtTokenException;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import org.jose4j.keys.HmacKey;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwtData {
    private static final TraceComponent tc = Tr.register(JwtData.class);
    private static final String SIGNATURE_ALG_HS256 = "HS256";
    private static final String SIGNATURE_ALG_RS256 = "RS256";
    public static final String TYPE_JWT_TOKEN = "Json Web Token";
    boolean bIdToken = false;
    boolean bJwtToken = false;
    private Key _signingKey = null;
    private String _keyId = null;
    JwtConfig jwtConfig = null;
    String tokenType = "Json Web Token";
    JWKProvider jwkProvider = null;
    String signatureAlgorithm = null;
    JwtTokenException noKeyException = null;
    static final long serialVersionUID = -6353413103254883040L;

    public JwtData(BuilderImpl jwtBuilder, JwtConfig jwtConfig, String tokenType) throws JwtTokenException {
        this.jwtConfig = jwtConfig;
        this.tokenType = tokenType;
        this.signatureAlgorithm = jwtBuilder.getAlgorithm();
        this.bJwtToken = TYPE_JWT_TOKEN.equals(tokenType);
        this.initSigningKey(jwtBuilder, jwtConfig);
    }

    public JwtConfig getConfig() {
        return this.jwtConfig;
    }

    @FFDCIgnore(value={Exception.class})
    protected void initSigningKey(BuilderImpl jwtBuilder, JwtConfig jwtConfig) throws JwtTokenException {
        String keyType = "x509";
        try {
            if (jwtConfig.isJwkEnabled() && SIGNATURE_ALG_RS256.equals(this.signatureAlgorithm)) {
                JSONWebKey jwk;
                keyType = "jwk";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Signing key type is " + keyType), (Object[])new Object[0]);
                }
                if ((jwk = jwtConfig.getJSONWebKey()) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Did not succcessfully build a JWK", (Object[])new Object[0]);
                    }
                    this._signingKey = null;
                    this._keyId = null;
                } else {
                    this._signingKey = jwk.getPrivateKey();
                    this._keyId = jwk.getKeyID();
                }
            } else if (SIGNATURE_ALG_HS256.equals(this.signatureAlgorithm)) {
                String sharedKey;
                keyType = "shared secret";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Signing key type is " + keyType), (Object[])new Object[0]);
                }
                if (JwtUtils.isNullEmpty(sharedKey = jwtBuilder.getSharedKey())) {
                    sharedKey = jwtConfig.getSharedKey();
                }
                this._signingKey = !JwtUtils.isNullEmpty(sharedKey) ? new HmacKey(sharedKey.getBytes("UTF-8")) : null;
            } else if (SIGNATURE_ALG_RS256.equals(this.signatureAlgorithm)) {
                this._signingKey = jwtBuilder.getKey();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Signing key type is " + keyType), (Object[])new Object[0]);
                }
                if (this._signingKey == null) {
                    String keyAlias = null;
                    String keyStoreRef = null;
                    keyAlias = jwtConfig.getKeyAlias();
                    keyStoreRef = jwtConfig.getKeyStoreRef();
                    this._signingKey = JwtUtils.getPrivateKey(keyAlias, keyStoreRef);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Key alias: " + keyAlias + ", Keystore: " + keyStoreRef), (Object[])new Object[0]);
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RSAPrivateKey: " + (this._signingKey instanceof RSAPrivateKey)), (Object[])new Object[0]);
                }
                if (this._signingKey != null && !(this._signingKey instanceof RSAPrivateKey)) {
                    this._signingKey = null;
                }
            }
        }
        catch (Exception e) {
            Object[] objs = new Object[]{this.signatureAlgorithm, jwtConfig.isJwkEnabled(), e.getLocalizedMessage()};
            JwtTokenException jte = JwtTokenException.newInstance(false, "JWT_NO_SIGNING_KEY_WITH_ERROR", objs);
            jte.initCause(e);
            throw jte;
        }
        if (this._signingKey == null) {
            Object[] objs = new Object[]{this.signatureAlgorithm, jwtConfig.isJwkEnabled(), ""};
            throw JwtTokenException.newInstance(true, "JWT_NO_SIGNING_KEY_WITH_ERROR", objs);
        }
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Sensitive
    public JwtData(Key key, String id) {
        this._signingKey = key;
        this._keyId = id;
    }

    @Sensitive
    Key getSigningKey() {
        return this._signingKey;
    }

    String getKeyID() {
        return this._keyId;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public JwtTokenException getNoKeyException() {
        if (this.noKeyException != null) {
            return this.noKeyException;
        }
        return new JwtTokenException("No signing key found");
    }

    public boolean isJwt() {
        return this.bJwtToken;
    }
}

