/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.security.jwt.JwtBuilder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TokenBuilder {
    private static TraceComponent tc = Tr.register(TokenBuilder.class);
    private static final String USER_CLAIM = "usr";
    private static final String GROUP_CLAIM = "groups";
    private static final String GROUP_PREFIX = "group:";
    static final long serialVersionUID = 3264823558194580001L;

    public String createTokenString(JwtConfig config) {
        try {
            JwtBuilder builder = JwtBuilder.create(config.getId());
            String user = this.getUserName();
            builder.subject(user);
            builder.claim(USER_CLAIM, user);
            ArrayList<String> groups = this.getGroups();
            if (this.isValidList(groups)) {
                builder.claim(GROUP_CLAIM, groups);
            }
            return builder.buildJwt().compact();
        }
        catch (Exception builder) {
            FFDCFilter.processException((Throwable)builder, (String)"com.ibm.ws.security.jwt.utils.TokenBuilder", (String)"64", (Object)this, (Object[])new Object[]{config});
            return null;
        }
    }

    @Trivial
    private boolean isValidList(List<String> in) {
        return in != null && in.size() > 0;
    }

    private String getUserName() {
        Subject subject = null;
        try {
            subject = WSSubject.getRunAsSubject();
            WSCredential wsCred = this.getWSCredential(subject);
            return wsCred.getSecurityName();
        }
        catch (Exception wsCred) {
            FFDCFilter.processException((Throwable)wsCred, (String)"com.ibm.ws.security.jwt.utils.TokenBuilder", (String)"81", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    private ArrayList<String> getGroups() {
        Subject subject = null;
        try {
            subject = WSSubject.getRunAsSubject();
            WSCredential wsCred = this.getWSCredential(subject);
            ArrayList groupIds = wsCred.getGroupIds();
            ArrayList<String> groups = new ArrayList<String>();
            ListIterator it = groupIds.listIterator();
            while (it.hasNext()) {
                int groupIndex;
                String origGroup = (String)it.next();
                if (origGroup != null && origGroup.startsWith(GROUP_PREFIX) && (groupIndex = origGroup.indexOf("/")) > 0) {
                    origGroup = origGroup.substring(groupIndex + 1);
                }
                groups.add(origGroup);
            }
            return groups;
        }
        catch (Exception wsCred) {
            FFDCFilter.processException((Throwable)wsCred, (String)"com.ibm.ws.security.jwt.utils.TokenBuilder", (String)"108", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    private WSCredential getWSCredential(Subject subject) {
        WSCredential wsCredential = null;
        Set<WSCredential> wsCredentials = subject.getPublicCredentials(WSCredential.class);
        Iterator<WSCredential> wsCredentialsIterator = wsCredentials.iterator();
        if (wsCredentialsIterator.hasNext()) {
            wsCredential = wsCredentialsIterator.next();
        }
        return wsCredential;
    }
}

