/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class LogQueryBean
implements Serializable {
    private static final long serialVersionUID = -6635572279743895675L;
    private Date minTime;
    private Date maxTime;
    private Level minLevel;
    private Level maxLevel;
    private String[] messageContent;
    private String[] includeLoggers;
    private String[] excludeLoggers;
    private int[] threadIDs;

    public Date getMinTime() {
        return this.minTime;
    }

    public Date getMaxTime() {
        return this.maxTime;
    }

    public void setTime(Date minTime, Date maxTime) throws IllegalArgumentException {
        if (minTime != null && maxTime != null && minTime.after(maxTime)) {
            throw new IllegalArgumentException("Value of the minTime parameter should specify time before the time specified by the value of the maxTime parameter");
        }
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    public Level getMinLevel() {
        return this.minLevel;
    }

    public Level getMaxLevel() {
        return this.maxLevel;
    }

    public void setLevels(Level minLevel, Level maxLevel) throws IllegalArgumentException {
        if (minLevel != null && maxLevel != null && minLevel.intValue() > maxLevel.intValue()) {
            throw new IllegalArgumentException("Value of the minLevel parameter should specify level not larger than the value of the maxLevel parametere.");
        }
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public String[] getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(String[] messageContent) throws IllegalArgumentException {
        LogQueryBean.verifyPatterns(messageContent);
        this.messageContent = messageContent;
    }

    public String[] getIncludeLoggers() {
        return this.includeLoggers;
    }

    public void setIncludeLoggers(String[] includeLoggers) throws IllegalArgumentException {
        LogQueryBean.verifyPatterns(includeLoggers);
        this.includeLoggers = includeLoggers;
    }

    public String[] getExcludeLoggers() {
        return this.excludeLoggers;
    }

    public void setExcludeLoggers(String[] excludeLoggers) throws IllegalArgumentException {
        LogQueryBean.verifyPatterns(excludeLoggers);
        this.excludeLoggers = excludeLoggers;
    }

    private static void verifyPatterns(String[] patterns) throws IllegalArgumentException {
        if (patterns != null) {
            try {
                for (String pattern : patterns) {
                    LogQueryBean.compile(pattern);
                }
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Pattern array contains an invalid regular expression", e);
            }
        }
    }

    public static Pattern compile(String pattern) throws IllegalArgumentException {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern can not be null");
        }
        if (pattern.startsWith("/") && pattern.endsWith("/") && pattern.length() > 1) {
            try {
                return Pattern.compile(pattern.substring(1, pattern.length() - 1));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Pattern contains an invalid expression", e);
            }
        }
        StringBuilder rEPattern = new StringBuilder("^");
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '*') {
                rEPattern.append('.');
            }
            if (pattern.charAt(i) == '?') {
                rEPattern.append('.');
                continue;
            }
            rEPattern.append(pattern.charAt(i));
        }
        rEPattern.append("$");
        try {
            return Pattern.compile(rEPattern.toString());
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern contains an invalid expression", e);
        }
    }

    public int[] getThreadIDs() {
        return this.threadIDs;
    }

    public void setThreadIDs(int[] threadIDs) {
        this.threadIDs = threadIDs;
    }

    public void setThreadIDs(String[] threadIDs) throws IllegalArgumentException {
        int[] threads = null;
        if (threadIDs != null) {
            threads = new int[threadIDs.length];
            try {
                for (int i = 0; i < threads.length; ++i) {
                    threads[i] = Integer.parseInt(threadIDs[i], 16);
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Strings in the threadIDs array should be all in hexadecimal format");
            }
        }
        this.threadIDs = threads;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.excludeLoggers);
        result = 31 * result + Arrays.hashCode(this.includeLoggers);
        result = 31 * result + (this.maxLevel == null ? 0 : this.maxLevel.hashCode());
        result = 31 * result + (this.maxTime == null ? 0 : this.maxTime.hashCode());
        result = 31 * result + Arrays.hashCode(this.messageContent);
        result = 31 * result + (this.minLevel == null ? 0 : this.minLevel.hashCode());
        result = 31 * result + (this.minTime == null ? 0 : this.minTime.hashCode());
        result = 31 * result + Arrays.hashCode(this.threadIDs);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogQueryBean other = (LogQueryBean)obj;
        if (!Arrays.equals(this.excludeLoggers, other.excludeLoggers)) {
            return false;
        }
        if (!Arrays.equals(this.includeLoggers, other.includeLoggers)) {
            return false;
        }
        if (this.maxLevel == null ? other.maxLevel != null : !this.maxLevel.equals(other.maxLevel)) {
            return false;
        }
        if (this.maxTime == null ? other.maxTime != null : !this.maxTime.equals(other.maxTime)) {
            return false;
        }
        if (!Arrays.equals(this.messageContent, other.messageContent)) {
            return false;
        }
        if (this.minLevel == null ? other.minLevel != null : !this.minLevel.equals(other.minLevel)) {
            return false;
        }
        if (this.minTime == null ? other.minTime != null : !this.minTime.equals(other.minTime)) {
            return false;
        }
        return Arrays.equals(this.threadIDs, other.threadIDs);
    }

    public String toString() {
        return "LogQueryBean [excludeLoggers=" + Arrays.toString(this.excludeLoggers) + ", includeLoggers=" + Arrays.toString(this.includeLoggers) + ", maxLevel=" + this.maxLevel + ", maxTime=" + this.maxTime + ", messageContent=" + Arrays.toString(this.messageContent) + ", minLevel=" + this.minLevel + ", minTime=" + this.minTime + ", threadIDs=" + Arrays.toString(this.threadIDs) + "]";
    }
}

