/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector.manager.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collector.manager.internal.CollectorManagerUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collector.manager.Handler;
import com.ibm.wsspi.collector.manager.Source;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HandlerManager {
    private String handlerId;
    private Handler handler;
    private final Set<String> subscribedSources;
    private final Set<String> pendingSubscriptions;
    static final long serialVersionUID = 3529924893396346662L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public HandlerManager(Handler handler) {
        this.setHandler(handler);
        this.subscribedSources = new HashSet<String>();
        this.pendingSubscriptions = new HashSet<String>();
    }

    public String getHandlerId() {
        return this.handlerId;
    }

    public void setHandlerId(String handlerId) {
        this.handlerId = handlerId;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        if (handler != null) {
            this.handler = handler;
            this.handlerId = CollectorManagerUtils.getHandlerId(handler);
        }
    }

    public void unsetHandler(Handler handler) {
        if (this.handler == handler) {
            this.handler = null;
        }
    }

    public void addSubscribedSource(Source source) {
        String sourceId = CollectorManagerUtils.getSourceId(source);
        this.pendingSubscriptions.remove(sourceId);
        this.subscribedSources.add(sourceId);
    }

    public void removeSubscribedSource(Source source) {
        String sourceId = CollectorManagerUtils.getSourceId(source);
        this.subscribedSources.remove(sourceId);
    }

    public void addPendingSubscription(String sourceId) {
        if (!this.subscribedSources.contains(sourceId)) {
            this.pendingSubscriptions.add(sourceId);
        }
    }

    public Set<String> getSubsribedSources() {
        return this.subscribedSources;
    }

    public Set<String> getPendingSubscriptions() {
        return this.pendingSubscriptions;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(HandlerManager.class);
    }
}

