/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector.manager.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collector.manager.buffer.BufferManagerImpl;
import com.ibm.ws.collector.manager.internal.CollectorManagerUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.Handler;
import com.ibm.wsspi.collector.manager.Source;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SourceManager {
    private String sourceId;
    private Source source;
    private BufferManagerImpl bufferMgr;
    private final Set<String> subscribers;
    private final int BUFFER_SIZE = 10000;
    static final long serialVersionUID = -1348048772197552684L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SourceManager(Source source) {
        this.setSource(source);
        this.subscribers = new HashSet<String>();
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        if (source != null) {
            this.source = source;
            this.sourceId = CollectorManagerUtils.getSourceId(source);
        }
    }

    public void unsetSource(Source source) {
        if (this.source == source) {
            this.source = null;
        }
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    public void setBufferManager(BufferManager bufferMgr) {
        this.bufferMgr = (BufferManagerImpl)bufferMgr;
    }

    public void addSubscriber(Handler handler) {
        String handlerId = CollectorManagerUtils.getHandlerId(handler);
        if (this.source.getSourceName().trim().equals("audit") && this.subscribers.isEmpty()) {
            this.bufferMgr = new BufferManagerImpl(10000, this.sourceId, false);
            this.source.setBufferManager((BufferManager)this.bufferMgr);
        }
        this.subscribers.add(handlerId);
        this.bufferMgr.addHandler(handlerId);
    }

    public boolean removeSubscriber(Handler handler) {
        String handlerId = CollectorManagerUtils.getHandlerId(handler);
        this.subscribers.remove(handlerId);
        this.bufferMgr.removeHandler(handlerId);
        if (this.subscribers.isEmpty()) {
            this.source.unsetBufferManager((BufferManager)this.bufferMgr);
            if (!this.sourceId.contains("com.ibm.ws.logging.source.message") && !this.sourceId.contains("com.ibm.ws.logging.source.trace")) {
                this.bufferMgr = null;
            }
            return true;
        }
        return false;
    }

    public Set<String> getSubscriptions() {
        return this.subscribers;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SourceManager.class);
    }
}

