/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JavaInfo {
    private static JavaInfo instance;
    private final int MAJOR;
    private final int MINOR;
    private final int SERVICE_RELEASE;
    private final int FIXPACK;
    private final Vendor VENDOR;
    static final long serialVersionUID = -3329564887626998727L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private JavaInfo() {
        String version = JavaInfo.getSystemProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
        this.MAJOR = Integer.valueOf(versionElements[i++]);
        this.MINOR = i < versionElements.length ? Integer.valueOf(versionElements[i]) : 0;
        String vendor = JavaInfo.getSystemProperty("java.vendor").toLowerCase();
        this.VENDOR = vendor.contains("ibm") ? Vendor.IBM : (vendor.contains("openj9") ? Vendor.OPENJ9 : (vendor.contains("oracle") ? Vendor.ORACLE : Vendor.UNKNOWN));
        int sr = 0;
        int fp = 0;
        if (this.VENDOR == Vendor.IBM) {
            int fploc;
            String runtimeVersion = JavaInfo.getSystemProperty("java.runtime.version").toLowerCase();
            int srloc = runtimeVersion.indexOf("sr");
            if (srloc > -1 && (srloc += 2) < runtimeVersion.length()) {
                int len = 0;
                while (srloc + len < runtimeVersion.length() && Character.isDigit(runtimeVersion.charAt(srloc + len))) {
                    ++len;
                }
                sr = Integer.parseInt(runtimeVersion.substring(srloc, srloc + len));
            }
            if ((fploc = runtimeVersion.indexOf("fp")) > -1 && (fploc += 2) < runtimeVersion.length()) {
                int len = 0;
                while (fploc + len < runtimeVersion.length() && Character.isDigit(runtimeVersion.charAt(fploc + len))) {
                    ++len;
                }
                fp = Integer.parseInt(runtimeVersion.substring(fploc, fploc + len));
            }
        }
        this.SERVICE_RELEASE = sr;
        this.FIXPACK = fp;
    }

    private static final String getSystemProperty(final String propName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -4796308782865707991L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(propName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    private static JavaInfo instance() {
        if (instance == null) {
            instance = new JavaInfo();
        }
        return instance;
    }

    public static int majorVersion() {
        return JavaInfo.instance().MAJOR;
    }

    public static int minorVersion() {
        return JavaInfo.instance().MINOR;
    }

    public static Vendor vendor() {
        return JavaInfo.instance().VENDOR;
    }

    public static int serviceRelease() {
        return JavaInfo.instance().SERVICE_RELEASE;
    }

    public static int fixPack() {
        return JavaInfo.instance().FIXPACK;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JavaInfo.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class Vendor
    extends Enum<Vendor> {
        public static final /* enum */ Vendor IBM;
        public static final /* enum */ Vendor OPENJ9;
        public static final /* enum */ Vendor ORACLE;
        public static final /* enum */ Vendor UNKNOWN;
        private static final /* synthetic */ Vendor[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static Vendor[] values() {
            return (Vendor[])$VALUES.clone();
        }

        public static Vendor valueOf(String name) {
            return Enum.valueOf(Vendor.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Vendor.class);
            IBM = new Vendor();
            OPENJ9 = new Vendor();
            ORACLE = new Vendor();
            UNKNOWN = new Vendor();
            $VALUES = new Vendor[]{IBM, OPENJ9, ORACLE, UNKNOWN};
        }
    }
}

