/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;
import java.util.Scanner;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UtilityTemplate {
    static final long serialVersionUID = 3229061258015613345L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public File getUtilityJar() {
        URL home = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        if (!home.getProtocol().equals("file")) {
            return null;
        }
        String path = PathUtils.normalize(home.getPath());
        return new File(path);
    }

    public String getInstallDir() {
        String installDir = System.getenv("WLP_INSTALL_DIR");
        if (installDir == null) {
            File utilityJarFile = this.getUtilityJar();
            installDir = utilityJarFile == null ? System.getProperty("user.dir") + File.separator : utilityJarFile.getParentFile().getParentFile().getAbsolutePath() + File.separator;
        } else if (!installDir.endsWith("/") && !installDir.endsWith("\\")) {
            installDir = installDir + File.separator;
        }
        return installDir;
    }

    public String getUserDir() {
        String usrDir = System.getenv("WLP_USER_DIR");
        if (usrDir == null) {
            usrDir = this.getInstallDir() + "usr" + File.separator;
        } else if (!usrDir.endsWith("/") && !usrDir.endsWith("\\")) {
            usrDir = usrDir + File.separator;
        }
        return usrDir;
    }

    public String getOutputDir(String serverName) {
        String outputDir = System.getenv("WLP_OUTPUT_DIR");
        File serverEnv = new File(this.getUserDir() + "servers" + File.separator + serverName + File.separator + "server.env");
        if (serverName != null && serverEnv.exists() && serverEnv.canRead()) {
            try {
                Properties props = new Properties();
                Scanner s = new Scanner(serverEnv);
                String serverEnvStr = s.useDelimiter("\\Z").next();
                s.close();
                props.load(new StringReader(serverEnvStr.replace("\\", "\\\\")));
                outputDir = props.getProperty("WLP_OUTPUT_DIR");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.service.util.UtilityTemplate", (String)"86", (Object)this, (Object[])new Object[]{serverName});
            }
        }
        if (outputDir == null) {
            outputDir = this.getUserDir() + "servers" + File.separator;
        } else if (!outputDir.endsWith("/") && !outputDir.endsWith("\\")) {
            outputDir = outputDir + File.separator;
        }
        return outputDir;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(UtilityTemplate.class);
    }
}

