/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.JMS390FloatSupport;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.utils.HexString;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.ResourceAllocationException;

public class JmsBytesMessageImpl
extends JmsMessageImpl
implements BytesMessage {
    private static final long serialVersionUID = 1691954622519522063L;
    private JsJmsBytesMessage jsBytesMsg;
    private boolean bodySetInJsMsg = false;
    private boolean writeByteArrayCalled = false;
    private int lastEncoding;
    private boolean requiresInit = false;
    private transient ByteArrayOutputStream _writeBytes;
    private transient DataOutputStream writeStream;
    private static final int ARRAY_SIZE = 20;
    private int integer_count;
    private int[] integer_offsets;
    private int[] integer_sizes;
    private Vector integers;
    private Vector float_offsets;
    private Vector float_values;
    private byte[] dataBuffer;
    private int dataStart;
    private int integerEncoding = 1;
    private int floatEncoding = 256;
    private transient ByteArrayInputStream readStream;
    private int streamOffset;
    private boolean markInUse = false;
    private transient String cachedBytesToString = null;
    private static TraceComponent tc = SibTr.register(JmsBytesMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    public JmsBytesMessageImpl() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsBytesMessageImpl");
        }
        this.clearBody();
        this.messageClass = "jms_bytes";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsBytesMessageImpl");
        }
    }

    JmsBytesMessageImpl(BytesMessage bytesMessage) throws JMSException {
        super((Message)bytesMessage);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsBytesMessageImpl", (Object)bytesMessage);
        }
        this.clearBody();
        bytesMessage.reset();
        int bufferSize = 32768;
        long bodyLength = bytesMessage.getBodyLength();
        if (bodyLength < (long)bufferSize) {
            bufferSize = (int)bodyLength;
        }
        byte[] buffer = new byte[bufferSize];
        int nRead = 0;
        while ((nRead = bytesMessage.readBytes(buffer)) > 0) {
            this.writeBytes(buffer, 0, nRead);
        }
        this.messageClass = "jms_bytes";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsBytesMessageImpl");
        }
    }

    JmsBytesMessageImpl(JsJmsBytesMessage newMsg, JmsSessionImpl newSess) {
        super((JsJmsMessage)newMsg, newSess);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsBytesMessageImpl", (Object)new Object[]{newMsg, newSess});
        }
        this.jsBytesMsg = newMsg;
        this.requiresInit = true;
        this.setBodyReadOnly();
        this.messageClass = "jms_bytes";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsBytesMessageImpl");
        }
    }

    @Override
    public void clearBody() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
        super.clearBody();
        this.dataBuffer = null;
        this.dataStart = 0;
        this.readStream = null;
        if (this.jsBytesMsg != null) {
            this.jsBytesMsg.setBytes(null);
            this.jsBytesMsg.setObjectProperty("JMS_IBM_Encoding", null);
            this.jsBytesMsg.setObjectProperty("JMS_IBM_Character_Set", null);
        }
        this.integerEncoding = 1;
        this.floatEncoding = 256;
        this.cachedBytesToString = null;
        if (!this.producerWontModifyPayloadAfterSet) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Producer might modify the payload after set - encoding is required, so reinitialise encoding relating variables");
            }
            this._writeBytes = new ByteArrayOutputStream();
            this.writeStream = new DataOutputStream(this._writeBytes);
            this.integer_count = 0;
            this.integer_offsets = new int[20];
            this.integer_sizes = new int[20];
            if (this.integers != null) {
                this.integers.removeAllElements();
            }
            if (this.float_offsets != null) {
                this.float_offsets.removeAllElements();
            }
            if (this.float_values != null) {
                this.float_values.removeAllElements();
            }
            this.bodySetInJsMsg = false;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Producer has promised not to modify payload - ensure write streams used for encoding are null");
            }
            this._writeBytes = null;
            this.writeStream = null;
            this.writeByteArrayCalled = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
    }

    public boolean readBoolean() throws JMSException {
        int byteRead;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readBoolean");
        }
        this.checkBodyReadable("readBoolean");
        if (this.requiresInit) {
            this.lazyInitForReading();
        }
        if ((byteRead = this.readStream.read()) < 0) {
            throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readBoolean", (Object)(byteRead != 0 ? 1 : 0));
        }
        return byteRead != 0;
    }

    public byte readByte() throws JMSException {
        int byteRead;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readByte");
        }
        this.checkBodyReadable("readByte");
        if (this.requiresInit) {
            this.lazyInitForReading();
        }
        if ((byteRead = this.readStream.read()) < 0) {
            throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readByte", (Object)byteRead);
        }
        return (byte)byteRead;
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readBytes", (Object)new Object[]{value, length});
        }
        this.checkBodyReadable("readBytes");
        if (this.requiresInit) {
            this.lazyInitForReading();
        }
        if (value.length < length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        int result = this.readStream.read(value, 0, length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readBytes", (Object)result);
        }
        return result;
    }

    public char readChar() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readChar");
        }
        this.checkBodyReadable("readChar");
        if (this.requiresInit) {
            this.lazyInitForReading();
        }
        if (!this.markInUse) {
            this.readStream.mark(2);
        }
        int byte1 = this.readStream.read();
        int byte2 = this.readStream.read();
        if (byte2 < 0) {
            this.readStream.reset();
            throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
        }
        char result = this.integerEncoding == 2 ? (char)((byte2 << 8) + byte1) : (char)((byte1 << 8) + byte2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readChar", (Object)Character.valueOf(result));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public double readDouble() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && JmsBytesMessageImpl.tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)JmsBytesMessageImpl.tc, (String)"readDouble");
        }
        savedEncoding = this.integerEncoding;
        try {
            switch (this.floatEncoding) {
                case 256: {
                    this.integerEncoding = 1;
                    result = Double.longBitsToDouble(this.readLong());
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 512: {
                    this.integerEncoding = 2;
                    result = Double.longBitsToDouble(this.readLong());
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                case 768: {
                    this.integerEncoding = 1;
                    result = JMS390FloatSupport.longS390BitsToDouble(this.readLong());
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "BAD_ENCODING_CWSIA0181", new Object[]{Integer.toHexString(this.floatEncoding)}, JmsBytesMessageImpl.tc);
                }
            }
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0190", new Object[]{ex, "JmsBytesMessageImpl.readDouble"}, ex, "JmsBytesMessageImpl.readDouble#1", this, JmsBytesMessageImpl.tc);
        }
        finally {
            this.integerEncoding = savedEncoding;
        }
        if (TraceComponent.isAnyTracingEnabled() && JmsBytesMessageImpl.tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)JmsBytesMessageImpl.tc, (String)"readDouble", (Object)result);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public float readFloat() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && JmsBytesMessageImpl.tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)JmsBytesMessageImpl.tc, (String)"readFloat");
        }
        savedEncoding = this.integerEncoding;
        try {
            switch (this.floatEncoding) {
                case 256: {
                    this.integerEncoding = 1;
                    result = Float.intBitsToFloat(this.readInt());
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 512: {
                    this.integerEncoding = 2;
                    result = Float.intBitsToFloat(this.readInt());
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                case 768: {
                    this.integerEncoding = 1;
                    result = JMS390FloatSupport.intS390BitsToFloat(this.readInt());
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "BAD_ENCODING_CWSIA0181", new Object[]{Integer.toHexString(this.floatEncoding)}, JmsBytesMessageImpl.tc);
                }
            }
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0190", new Object[]{ex, "JmsBytesMessageImpl.readFloat"}, ex, "JmsBytesMessageImpl.readFloat#1", this, JmsBytesMessageImpl.tc);
        }
        finally {
            this.integerEncoding = savedEncoding;
        }
        if (TraceComponent.isAnyTracingEnabled() && JmsBytesMessageImpl.tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)JmsBytesMessageImpl.tc, (String)"readFloat", (Object)Float.valueOf(result));
        }
        return result;
    }

    public int readInt() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readInt");
        }
        this.checkBodyReadable("readInt");
        if (this.requiresInit) {
            this.lazyInitForReading();
        }
        if (!this.markInUse) {
            this.readStream.mark(4);
        }
        int byte1 = this.readStream.read();
        int byte2 = this.readStream.read();
        int byte3 = this.readStream.read();
        int byte4 = this.readStream.read();
        if (byte4 < 0) {
            this.readStream.reset();
            throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
        }
        int result = this.integerEncoding == 2 ? (byte4 << 24) + (byte3 << 16) + (byte2 << 8) + byte1 : (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + byte4;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readInt", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws JMSException {
        long result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readLong");
        }
        this.checkBodyReadable("readLong");
        if (this.requiresInit) {
            this.lazyInitForReading();
        }
        try {
            this.readStream.mark(8);
            this.markInUse = true;
            long int1 = (long)this.readInt() & 0xFFFFFFFFL;
            long int2 = (long)this.readInt() & 0xFFFFFFFFL;
            result = this.integerEncoding == 2 ? (int2 << 32) + int1 : (int1 << 32) + int2;
        }
        finally {
            this.markInUse = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readLong", (Object)result);
        }
        return result;
    }

    public short readShort() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readShort");
        }
        this.checkBodyReadable("readShort");
        if (this.requiresInit) {
            this.lazyInitForReading();
        }
        if (!this.markInUse) {
            this.readStream.mark(2);
        }
        int byte1 = this.readStream.read();
        int byte2 = this.readStream.read();
        if (byte2 < 0) {
            this.readStream.reset();
            throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
        }
        short result = this.integerEncoding == 2 ? (short)((byte2 << 8) + byte1) : (short)((byte1 << 8) + byte2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readShort", (Object)result);
        }
        return result;
    }

    public int readUnsignedByte() throws JMSException {
        int byteRead;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readUnsignedByte");
        }
        this.checkBodyReadable("readUnsignedByte");
        if (this.requiresInit) {
            this.lazyInitForReading();
        }
        if ((byteRead = this.readStream.read()) < 0) {
            throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readUnsignedByte", (Object)byteRead);
        }
        return byteRead;
    }

    public int readUnsignedShort() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readUnsignedShort");
        }
        this.checkBodyReadable("readUnsignedShort");
        if (this.requiresInit) {
            this.lazyInitForReading();
        }
        if (!this.markInUse) {
            this.readStream.mark(2);
        }
        int byte1 = this.readStream.read();
        int byte2 = this.readStream.read();
        if (byte2 < 0) {
            this.readStream.reset();
            throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
        }
        int result = this.integerEncoding == 2 ? (byte2 << 8) + byte1 : (byte1 << 8) + byte2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readUnsignedShort", (Object)result);
        }
        return result;
    }

    public String readUTF() throws JMSException {
        String result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readUTF");
        }
        int savedEncoding = this.integerEncoding;
        try {
            this.checkBodyReadable("readUTF");
            if (this.requiresInit) {
                this.lazyInitForReading();
            }
            this.readStream.mark(8);
            this.markInUse = true;
            this.integerEncoding = 1;
            int length = this.readUnsignedShort();
            byte[] utfBytes = new byte[length];
            if (this.readBytes(utfBytes, length) != length) {
                this.readStream.reset();
                throw (JMSException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_BYTESMESSAGE_CWSIA0183", null, tc);
            }
            result = new String(utfBytes, 0, length, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(MessageFormatException.class, "UTF8_CONV_CWSIA0184", null, ex, "JmsBytesMessage.readUTF#1", this, tc);
        }
        finally {
            this.integerEncoding = savedEncoding;
            this.markInUse = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readUTF", (Object)result);
        }
        return result;
    }

    public void reset() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset");
        }
        if (!this.isBodyReadOnly()) {
            if (!this.producerWontModifyPayloadAfterSet) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Body is writeable & producer might modify the payload, so encode the write stream");
                }
                this.dataBuffer = this._writeBytes.toByteArray();
                this.lastEncoding = this.integerEncoding | this.floatEncoding;
                this.jsBytesMsg.setBytes(this._exportBody(this.lastEncoding));
                this.bodySetInJsMsg = true;
                this.writeStream = null;
                this._writeBytes = null;
            }
            this.dataStart = 0;
            this.setBodyReadOnly();
        }
        if (this.dataBuffer == null) {
            this.dataBuffer = new byte[0];
        }
        this.readStream = new ByteArrayInputStream(this.dataBuffer);
        this.readStream.skip(this.dataStart);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeBoolean", (Object)value);
        }
        this.checkProducerPromise("writeBoolean(boolean)", "JmsBytesMessageImpl.writeBoolean#1");
        this.checkBodyWriteable("writeBoolean");
        this.writeByte((byte)(value ? 1 : 0));
        this.cachedBytesToString = null;
        this.bodySetInJsMsg = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeBoolean");
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeByte", (Object)value);
        }
        try {
            this.checkProducerPromise("writeByte(byte)", "JmsBytesMessageImpl.writeByte#2");
            this.checkBodyWriteable("writeByte");
            this.writeStream.writeByte(value);
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, ex, "JmsBytesMessageImpl.writeByte#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeByte");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeBytes(byte[] value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeBytes", (Object)value);
        }
        try {
            this.checkBodyWriteable("writeBytes");
            if (this.producerWontModifyPayloadAfterSet) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Producer has promised not to modify the payload after setting it in the message - check if they've violated that promise");
                }
                if (this.writeByteArrayCalled) throw (JMSException)JmsErrorUtils.newThrowable(IllegalStateException.class, "PROMISE_BROKEN_EXCEPTION_CWSIA0511", null, null, "JmsBytesMessageImpl.writeBytes#3", this, tc);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"This is the first call to writeBytes(byte[] value) - storing the byte array reference directly in the underlying MFP object");
                }
                this.writeByteArrayCalled = true;
                this.jsBytesMsg.setBytes(value);
                this.dataBuffer = value;
                this.dataStart = 0;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Producer 'payload modification' promise is not in place - make a copy of the byte array");
                }
                this.writeStream.write(value, 0, value.length);
                this.bodySetInJsMsg = false;
            }
            this.cachedBytesToString = null;
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, ex, "JmsBytesMessageImpl.writeBytes#4", this, tc);
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) return;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeBytes");
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeBytes", (Object)new Object[]{value, offset, length});
        }
        try {
            this.checkProducerPromise("writeBytes(byte[], int, int)", "JmsBytesMessageImpl.writeBytes#2");
            this.checkBodyWriteable("writeBytes");
            this.writeStream.write(value, offset, length);
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, ex, "JmsBytesMessageImpl.writeBytes#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeBytes");
        }
    }

    public void writeChar(char value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeChar", (Object)Character.valueOf(value));
        }
        try {
            this.checkProducerPromise("writeChar(char)", "JmsBytesMessageImpl.writeChar#2");
            this.checkBodyWriteable("writeChar");
            this.writeStream.writeChar(value);
            this.recordInteger(this.writeStream.size() - 2, 2);
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, ex, "JmsBytesMessageImpl.writeChar#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeChar");
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeDouble", (Object)value);
        }
        try {
            this.checkProducerPromise("writeDouble(double)", "JmsBytesMessageImpl.writeDouble#2");
            this.checkBodyWriteable("writeDouble");
            this.writeStream.writeLong(Double.doubleToLongBits(value));
            if (this.float_values == null) {
                this.float_values = new Vector();
            }
            this.float_values.addElement(new Double(value));
            if (this.float_offsets == null) {
                this.float_offsets = new Vector();
            }
            this.float_offsets.addElement(this.writeStream.size() - 8);
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, ex, "JmsBytesMessageImpl.writeDouble#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeDouble");
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeFloat", (Object)Float.valueOf(value));
        }
        try {
            this.checkProducerPromise("writeFloat(float)", "JmsBytesMessageImpl.writeFloat#2");
            this.checkBodyWriteable("writeFloat");
            this.writeStream.writeInt(Float.floatToIntBits(value));
            if (this.float_values == null) {
                this.float_values = new Vector();
            }
            this.float_values.addElement(new Float(value));
            if (this.float_offsets == null) {
                this.float_offsets = new Vector();
            }
            this.float_offsets.addElement(this.writeStream.size() - 4);
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, ex, "JmsBytesMessageImpl.writeFloat#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeFloat");
        }
    }

    public void writeInt(int value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeInt", (Object)value);
        }
        try {
            this.checkProducerPromise("writeInt(int)", "JmsBytesMessageImpl.writeInt#2");
            this.checkBodyWriteable("writeInt");
            this.writeStream.writeInt(value);
            this.recordInteger(this.writeStream.size() - 4, 4);
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, ex, "JmsBytesMessageImpl.writeInt#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeInt");
        }
    }

    public void writeLong(long value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeLong", (Object)value);
        }
        try {
            this.checkProducerPromise("writeLong(long)", "JmsBytesMessageImpl.writeLong#2");
            this.checkBodyWriteable("writeLong");
            this.writeStream.writeLong(value);
            this.recordInteger(this.writeStream.size() - 8, 8);
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, ex, "JmsBytesMessageImpl.writeLong#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeLong");
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeObject");
        }
        this.checkProducerPromise("writeObject(Object)", "JmsBytesMessageImpl.writeObject#1");
        this.checkBodyWriteable("writeObject");
        if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else {
            if (value == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"given null, throwing NPE");
                }
                throw new NullPointerException();
            }
            throw (JMSException)JmsErrorUtils.newThrowable(MessageFormatException.class, "BAD_OBJECT_CWSIA0185", new Object[]{value.getClass().getName()}, tc);
        }
        this.cachedBytesToString = null;
        this.bodySetInJsMsg = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeObject");
        }
    }

    public void writeShort(short value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeShort", (Object)value);
        }
        try {
            this.checkProducerPromise("writeShort(short)", "JmsBytesMessageImpl.writeShort#2");
            this.checkBodyWriteable("writeShort");
            this.writeStream.writeShort(value);
            this.recordInteger(this.writeStream.size() - 2, 2);
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, ex, "JmsBytesMessageImpl.writeShort#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeShort");
        }
    }

    public void writeUTF(String value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeUTF", (Object)value);
        }
        try {
            this.checkProducerPromise("writeUTF(String)", "JmsBytesMessageImpl.writeUTF#1");
            this.checkBodyWriteable("writeUTF");
            this.writeStream.writeUTF(value);
            this.cachedBytesToString = null;
            this.bodySetInJsMsg = false;
        }
        catch (UTFDataFormatException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(MessageFormatException.class, "UTF8_CONV_CWSIA0184", null, ex, null, this, tc);
        }
        catch (IOException ex) {
            throw (JMSException)JmsErrorUtils.newThrowable(ResourceAllocationException.class, "WRITE_PROBLEM_CWSIA0186", null, ex, "JmsBytesMessageImpl.writeUTF#2", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeUTF");
        }
    }

    public long getBodyLength() throws JMSException {
        long bLen;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBodyLength");
        }
        this.checkBodyReadable("getBodyLength");
        if (this.requiresInit) {
            this.lazyInitForReading();
        }
        if (this.dataBuffer == null) {
            bLen = 0L;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"buffer null");
            }
        } else {
            bLen = this.dataBuffer.length - this.dataStart;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBodyLength", (Object)bLen);
        }
        return bLen;
    }

    @Override
    public String toString() {
        if (this.cachedBytesToString == null) {
            StringBuffer retval;
            int LINE_LENGTH;
            int MAX_LINES;
            block9: {
                MAX_LINES = 10;
                LINE_LENGTH = 40;
                retval = new StringBuffer();
                if (!this.isBodyReadOnly()) {
                    try {
                        this.getMsgReference();
                    }
                    catch (JMSException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("getMsgReference failed with " + (Object)((Object)e)));
                    }
                }
            }
            if (this.requiresInit) {
                this.lazyInitForReading();
            }
            if (this.dataBuffer != null) {
                int curpos = this.dataStart;
                for (int lines_written = 0; lines_written < MAX_LINES; ++lines_written) {
                    if (this.dataBuffer.length <= curpos + LINE_LENGTH) {
                        HexString.binToHex((byte[])this.dataBuffer, (int)curpos, (int)(this.dataBuffer.length - curpos), (StringBuffer)retval);
                        curpos = this.dataBuffer.length;
                        retval.append("\n");
                        break;
                    }
                    HexString.binToHex((byte[])this.dataBuffer, (int)curpos, (int)LINE_LENGTH, (StringBuffer)retval);
                    retval.append("\n");
                    curpos += LINE_LENGTH;
                }
                if (curpos != this.dataBuffer.length) {
                    retval.append("...\n");
                }
            }
            this.cachedBytesToString = retval.toString();
        }
        return super.toString() + "\n" + this.cachedBytesToString;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeObject", (Object)out);
        }
        try {
            if (this.requiresInit) {
                this.lazyInitForReading();
            }
            if (this.isBodyReadOnly()) {
                this.streamOffset = this.dataBuffer.length - this.readStream.available();
            } else if (this._writeBytes != null) {
                this.dataBuffer = this._writeBytes.toByteArray();
            }
            out.defaultWriteObject();
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error during writeObject", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readObject", (Object)in);
        }
        try {
            in.defaultReadObject();
            if (this.isBodyReadOnly()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Body is read only - recreating read stream from local reference to payload");
                }
                this.readStream = new ByteArrayInputStream(this.dataBuffer);
                this.readStream.skip(this.streamOffset);
            } else if (!this.producerWontModifyPayloadAfterSet) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Body is writeable & producer hasn't promised not to modify the payload after it's been set - recreating write streams from local reference to payload");
                }
                this._writeBytes = new ByteArrayOutputStream();
                this.writeStream = new DataOutputStream(this._writeBytes);
                this.writeStream.write(this.dataBuffer);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Body is writeable but producer has promised not to modify the payload after it's been set, ignore write streams");
            }
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error during readObject", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readObject");
        }
    }

    @Override
    protected JsJmsMessage instantiateMessage() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateMessage");
        }
        JsJmsBytesMessage newMsg = null;
        try {
            newMsg = jmfact.createJmsBytesMessage();
        }
        catch (MessageCreateFailedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error occurred creating message", (Object)((Object)e));
            }
            throw e;
        }
        this.jsBytesMsg = newMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateMessage", (Object)newMsg);
        }
        return newMsg;
    }

    private void lazyInitForReading() {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"lazyInitForReading");
            }
            this.requiresInit = false;
            this.dataBuffer = this.jsBytesMsg.getBytes();
            if (this.dataBuffer == null) {
                this.dataBuffer = new byte[0];
            }
            this.readStream = new ByteArrayInputStream(this.dataBuffer);
            this.dataStart = 0;
            try {
                if (this.propertyExists("JMS_IBM_Encoding")) {
                    int encoding = this.getIntProperty("JMS_IBM_Encoding");
                    this.integerEncoding = encoding & 0xF;
                    this.floatEncoding = encoding & 0xF00;
                }
            }
            catch (JMSException je) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("ignoring exception whilst getting encoding " + (Object)((Object)je)));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lazyInitForReading");
        }
    }

    @Override
    protected JsJmsMessage getMsgReference() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMsgReference");
        }
        if (!this.isBodyReadOnly() && !this.producerWontModifyPayloadAfterSet) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Body is writeable & producer hasn't promised not to modify the payload - attempt encoding");
            }
            int encoding = this.integerEncoding | this.floatEncoding;
            if (this.propertyExists("JMS_IBM_Encoding")) {
                encoding = this.getIntProperty("JMS_IBM_Encoding");
            }
            if (this.bodySetInJsMsg && encoding == this.lastEncoding) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Body cached - encoding not necessary");
                }
            } else {
                byte[] encodedBody = this._exportBody(encoding);
                this.jsBytesMsg.setBytes(encodedBody);
                this.lastEncoding = encoding;
                this.bodySetInJsMsg = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMsgReference", (Object)this.jsBytesMsg);
        }
        return this.jsBytesMsg;
    }

    private byte[] _exportBody(int encoding) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_exportBody", (Object)encoding);
        }
        try {
            this.dataBuffer = this._writeBytes.toByteArray();
            this.dataStart = 0;
            int requestedIntegerEncoding = encoding & 0xF;
            int requestedFloatEncoding = encoding & 0xF00;
            if (this.integerEncoding <= 1 && requestedIntegerEncoding == 2 || this.integerEncoding == 2 && requestedIntegerEncoding <= 1) {
                if (this.integers != null) {
                    for (int i = 0; i < this.integers.size(); i += 2) {
                        int[] offsets = (int[])this.integers.elementAt(i);
                        int[] sizes = (int[])this.integers.elementAt(i + 1);
                        for (int j = 0; j < 20; ++j) {
                            this.reverse(this.dataBuffer, offsets[j], sizes[j]);
                        }
                    }
                }
                for (int j = 0; j < this.integer_count; ++j) {
                    this.reverse(this.dataBuffer, this.integer_offsets[j], this.integer_sizes[j]);
                }
            }
            if (this.floatEncoding != requestedFloatEncoding) {
                ByteArrayOutputStream floatbaos = new ByteArrayOutputStream(8);
                DataOutputStream floatstream = new DataOutputStream(floatbaos);
                if (this.float_offsets != null && this.float_values != null) {
                    for (int i = 0; i < this.float_offsets.size(); ++i) {
                        floatbaos.reset();
                        Object value = this.float_values.elementAt(i);
                        int offset = (Integer)this.float_offsets.elementAt(i);
                        if (value instanceof Float) {
                            float floatValue = ((Float)value).floatValue();
                            switch (requestedFloatEncoding) {
                                case 256: 
                                case 512: {
                                    floatstream.writeInt(Float.floatToIntBits(floatValue));
                                    break;
                                }
                                case 768: {
                                    floatstream.writeInt(JMS390FloatSupport.floatToS390IntBits(floatValue));
                                    break;
                                }
                                default: {
                                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "BAD_ENCODING_CWSIA0181", new Object[]{Integer.toHexString(requestedFloatEncoding)}, tc);
                                }
                            }
                            byte[] floatbytes = floatbaos.toByteArray();
                            if (requestedFloatEncoding == 512) {
                                this.reverse(floatbytes, 0, 4);
                            }
                            System.arraycopy(floatbytes, 0, this.dataBuffer, offset, 4);
                            continue;
                        }
                        if (!(value instanceof Double)) continue;
                        double doubleValue = (Double)value;
                        switch (requestedFloatEncoding) {
                            case 256: 
                            case 512: {
                                floatstream.writeLong(Double.doubleToLongBits(doubleValue));
                                break;
                            }
                            case 768: {
                                floatstream.writeLong(JMS390FloatSupport.doubleToS390LongBits(doubleValue));
                                break;
                            }
                            default: {
                                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "BAD_ENCODING_CWSIA0181", new Object[]{Integer.toHexString(requestedFloatEncoding)}, tc);
                            }
                        }
                        byte[] floatbytes = floatbaos.toByteArray();
                        if (requestedFloatEncoding == 512) {
                            this.reverse(floatbytes, 0, 8);
                        }
                        System.arraycopy(floatbytes, 0, this.dataBuffer, offset, 8);
                    }
                }
            }
        }
        catch (IOException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "DATA_STREAM_PROBLEM_CWSIA0182", null, e, "JmsBytesMessageImpl._exportBody#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_exportBody", (Object)this.dataBuffer);
        }
        return this.dataBuffer;
    }

    private void recordInteger(int offset, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"recordInteger", (Object)new Object[]{offset, length});
        }
        if (this.integer_count == 20) {
            if (this.integers == null) {
                this.integers = new Vector();
            }
            this.integers.addElement(this.integer_offsets);
            this.integers.addElement(this.integer_sizes);
            this.integer_offsets = new int[20];
            this.integer_sizes = new int[20];
            this.integer_count = 0;
        }
        this.integer_offsets[this.integer_count] = offset;
        this.integer_sizes[this.integer_count++] = length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"recordInteger");
        }
    }

    private void reverse(byte[] buffer, int offset, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reverse", (Object)new Object[]{buffer, offset, length});
        }
        for (int i = 0; i < length / 2; ++i) {
            byte temp = buffer[offset + i];
            buffer[offset + i] = buffer[offset + (length - 1) - i];
            buffer[offset + (length - 1) - i] = temp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reverse");
        }
    }

    private void checkProducerPromise(String jmsMethod, String ffdcProbeID) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkProducerPromise", (Object)new Object[]{jmsMethod, ffdcProbeID});
        }
        if (this.producerWontModifyPayloadAfterSet) {
            throw (JMSException)JmsErrorUtils.newThrowable(IllegalStateException.class, "PROMISE_BROKEN_EXCEPTION_CWSIA0510", new Object[]{jmsMethod}, null, ffdcProbeID, this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkProducerPromise");
        }
    }

    @Override
    public <T> T getBody(Class<T> paramClass) throws JMSException, MessageFormatException {
        T returnObj = null;
        this.reset();
        try {
            returnObj = super.getBody(paramClass);
        }
        finally {
            this.reset();
        }
        return returnObj;
    }
}

