/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.MsgDestEncodingUtilsImpl;
import com.ibm.ws.sib.jms.util.ArrayUtil;
import com.ibm.ws.sib.jms.util.UTF8Encoder;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayOutputStream;
import javax.jms.JMSException;

abstract class PropertyCoder {
    private static TraceComponent tc = SibTr.register(PropertyCoder.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    static final byte STAR = 42;
    static final String STAR_STRING = "*";
    static final String SHORT_ON = "N";
    static final String SHORT_OFF = "F";
    final String longName;
    final String shortName;
    final byte[] encodedName;
    String debugString;

    PropertyCoder(String longName, String shortName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"PropertyCoder.<init>", (Object)new Object[]{longName, shortName});
        }
        this.longName = longName;
        this.shortName = shortName;
        if (shortName != null) {
            this.encodedName = UTF8Encoder.encode((String)shortName);
        } else {
            int len = UTF8Encoder.getEncodedLength((String)longName);
            this.encodedName = new byte[3 + len];
            this.encodedName[0] = 42;
            ArrayUtil.writeShort((byte[])this.encodedName, (int)1, (short)((short)len));
            UTF8Encoder.encode((byte[])this.encodedName, (int)3, (String)longName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"PropertyCoder.<init>", (Object)this.toString());
        }
    }

    final String getLongName() {
        return this.longName;
    }

    final String getShortName() {
        return this.shortName;
    }

    public String toString() {
        if (this.debugString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" [ ");
            sb.append(this.longName);
            sb.append(", ");
            sb.append(this.shortName);
            sb.append(" ]");
            this.debugString = new String(sb);
        }
        return this.debugString;
    }

    abstract void encodeProperty(ByteArrayOutputStream var1, Object var2) throws JMSException;

    abstract Object decodeProperty(MsgDestEncodingUtilsImpl.PropertyInputStream var1) throws JMSException;
}

