/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.resource;

import com.ibm.ws.repository.resolver.internal.resource.RequirementImpl;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;

public class GenericMetadataRequirement
extends RequirementImpl {
    private final ManifestHeaderProcessor.GenericMetadata delegate;
    private static final Pattern OSGI_IDENTITY_PATTERN = Pattern.compile(".*\\(osgi.identity=([^)]*).*");

    public GenericMetadataRequirement(ManifestHeaderProcessor.GenericMetadata delegate) {
        super(GenericMetadataRequirement.getNameFromDelegate(delegate));
        this.delegate = delegate;
    }

    private static String getNameFromDelegate(ManifestHeaderProcessor.GenericMetadata delegate) {
        String filterString = (String)delegate.getDirectives().get("filter");
        String name = null;
        if (filterString != null) {
            Matcher matcher = OSGI_IDENTITY_PATTERN.matcher(filterString);
            name = matcher.matches() && matcher.groupCount() == 1 ? matcher.group(1) : filterString;
        }
        return name;
    }

    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    public Map<String, String> getDirectives() {
        return this.delegate.getDirectives();
    }

    public Map<String, Object> getAttributes() {
        return this.delegate.getAttributes();
    }
}

