/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.resource;

import com.ibm.ws.repository.resolver.internal.resource.ResourceHolder;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ResourceImpl
implements Resource {
    private final Map<String, List<Capability>> namespaceToCapabilities;
    private final Map<String, List<Requirement>> namespaceToRequirements;
    protected final String location;
    public static final String LOCATION_REPOSITORY = "repo";
    public static final String LOCATION_INSTALL = "install";
    private final RepositoryResource resource;
    private List<ResourceImpl> equalityCheckingResources;

    public ResourceImpl(List<Capability> capabilities, List<Requirement> requirements, String location, RepositoryResource massiveResource) {
        this.resource = massiveResource;
        NamespaceMapBuilder<Capability> capabilityMapBuilder = new NamespaceMapBuilder<Capability>(){

            @Override
            public String getNamespace(Capability capability) {
                return capability.getNamespace();
            }
        };
        this.namespaceToCapabilities = capabilityMapBuilder.buildMap(capabilities, this);
        NamespaceMapBuilder<Requirement> requirementMapBuilder = new NamespaceMapBuilder<Requirement>(){

            @Override
            public String getNamespace(Requirement requirement) {
                return requirement.getNamespace();
            }
        };
        this.namespaceToRequirements = requirementMapBuilder.buildMap(requirements, this);
        this.location = location;
    }

    public List<Capability> getCapabilities(String namespace) {
        List<Capability> capabilities = this.namespaceToCapabilities.get(namespace);
        if (capabilities != null) {
            return capabilities;
        }
        return Collections.emptyList();
    }

    public List<Requirement> getRequirements(String namespace) {
        List<Requirement> requirements = this.namespaceToRequirements.get(namespace);
        if (requirements != null) {
            return requirements;
        }
        return Collections.emptyList();
    }

    public RepositoryResource getResource() {
        return this.resource;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespaceToCapabilities == null ? 0 : this.namespaceToCapabilities.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.namespaceToRequirements == null ? 0 : this.namespaceToRequirements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceImpl other = (ResourceImpl)obj;
        if (this.equalityCheckingResources == null) {
            this.equalityCheckingResources = new ArrayList<ResourceImpl>();
        }
        for (ResourceImpl alreadyChecked : this.equalityCheckingResources) {
            if (alreadyChecked != other) continue;
            return true;
        }
        this.equalityCheckingResources.add(other);
        if (!this.namespaceToCapabilities.equals(other.namespaceToCapabilities)) {
            this.equalityCheckingResources = null;
            return false;
        }
        if (!this.namespaceToRequirements.equals(other.namespaceToRequirements)) {
            this.equalityCheckingResources = null;
            return false;
        }
        if (this.location == null) {
            if (other.location != null) {
                this.equalityCheckingResources = null;
                return false;
            }
        } else if (!this.location.equals(other.location)) {
            this.equalityCheckingResources = null;
            return false;
        }
        this.equalityCheckingResources = null;
        return true;
    }

    protected int compareLocation(ResourceImpl other) {
        if (LOCATION_INSTALL.equals(this.location) && !LOCATION_INSTALL.equals(other.location)) {
            return -1;
        }
        if (!LOCATION_INSTALL.equals(this.location) && LOCATION_INSTALL.equals(other.location)) {
            return 1;
        }
        return 0;
    }

    private abstract class NamespaceMapBuilder<T> {
        private NamespaceMapBuilder() {
        }

        public Map<String, List<T>> buildMap(List<T> list, Resource resource) {
            Map<String, List<T>> map;
            if (list != null) {
                LinkedHashMap tempMap = new LinkedHashMap();
                for (T t : list) {
                    String namespace = this.getNamespace(t);
                    ArrayList<T> namespaceItems = (ArrayList<T>)tempMap.get(namespace);
                    if (namespaceItems == null) {
                        namespaceItems = new ArrayList<T>();
                        tempMap.put(namespace, namespaceItems);
                    }
                    if (t instanceof ResourceHolder) {
                        ((ResourceHolder)t).setResource(resource);
                    }
                    namespaceItems.add(t);
                }
                tempMap.put(null, new ArrayList<T>(list));
                map = new LinkedHashMap<String, List<T>>();
                for (Map.Entry entry : tempMap.entrySet()) {
                    map.put((String)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
                }
            } else {
                map = Collections.emptyMap();
            }
            return map;
        }

        public abstract String getNamespace(T var1);
    }
}

