/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.config.impl.ConversionManager;
import com.ibm.ws.microprofile.config.impl.SortedSources;
import com.ibm.ws.microprofile.config.interfaces.SourcedValue;
import com.ibm.ws.microprofile.config.interfaces.WebSphereConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractConfig
implements WebSphereConfig {
    private static final TraceComponent tc = Tr.register(AbstractConfig.class);
    private final SortedSources sources;
    private boolean closed = false;
    private final ConversionManager conversionManager;
    static final long serialVersionUID = 4281149768967340395L;

    @Trivial
    public AbstractConfig(ConversionManager conversionManager, SortedSources sources) {
        this.sources = sources;
        this.conversionManager = conversionManager;
    }

    protected abstract Set<String> getKeySet();

    public Iterable<ConfigSource> getConfigSources() {
        return this.sources;
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        this.assertNotClosed();
        SourcedValue sourced = this.getSourcedValue(propertyName, propertyType);
        Object value = null;
        if (sourced != null) {
            value = sourced.getValue();
        }
        Optional<Object> optional = Optional.ofNullable(value);
        return optional;
    }

    public Set<String> getPropertyNames() {
        this.assertNotClosed();
        Set<String> keys = this.getKeySet();
        return keys;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    protected void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"config.closed.CWMCG0001E", (Object[])new Object[0]));
        }
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Config[");
        sb.append(this.hashCode());
        sb.append("](");
        if (this.closed) {
            sb.append("CLOSED");
        } else {
            sb.append(this.sources.size());
            sb.append(" sources");
        }
        sb.append(")");
        return sb.toString();
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        Object value = this.getValue(propertyName, propertyType, false);
        return (T)value;
    }

    @Override
    public Object getValue(String propertyName, Type propertyType) {
        Object value = this.getValue(propertyName, propertyType, false);
        return value;
    }

    @Override
    public Object getValue(String propertyName, Type propertyType, boolean optional) {
        Object value = null;
        this.assertNotClosed();
        if (this.getKeySet().contains(propertyName)) {
            SourcedValue sourced = this.getSourcedValue(propertyName, propertyType);
            value = sourced.getValue();
        } else if (optional) {
            value = this.convertValue("org.eclipse.microprofile.config.configproperty.unconfigureddvalue", propertyType);
        } else {
            throw new NoSuchElementException(Tr.formatMessage((TraceComponent)tc, (String)"no.such.element.CWMCG0015E", (Object[])new Object[]{propertyName}));
        }
        return value;
    }

    @Override
    public Object getValue(String propertyName, Type propertyType, String defaultString) {
        Object value = null;
        this.assertNotClosed();
        if (this.getKeySet().contains(propertyName)) {
            SourcedValue sourced = this.getSourcedValue(propertyName, propertyType);
            value = sourced.getValue();
        } else {
            value = this.convertValue(defaultString, propertyType);
        }
        return value;
    }

    @Override
    public Object convertValue(String rawValue, Type type) {
        this.assertNotClosed();
        Object value = this.conversionManager.convert(rawValue, type);
        return value;
    }
}

