/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_MappedSimple;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.anno.classsource.ClassSource_Streamer;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassSourceImpl_MappedSimple
extends ClassSourceImpl
implements ClassSource,
ClassSource_MappedSimple {
    public static final String CLASS_NAME = ClassSourceImpl_MappedSimple.class.getName();
    private static final TraceComponent tc = Tr.register(ClassSourceImpl_MappedSimple.class);
    protected final ClassSource_MappedSimple.SimpleClassProvider provider;
    protected long startTime;
    protected long endTime;
    protected long streamTime;
    static final long serialVersionUID = 9013929699983020741L;

    public ClassSourceImpl_MappedSimple(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, ClassSource_MappedSimple.SimpleClassProvider provider) throws ClassSource_Exception {
        super(factory, internMap, name, provider.getName());
        this.provider = provider;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init> [ {0} ]", (Object[])new Object[]{this.getHashText()});
        }
    }

    @Override
    public ClassSource_MappedSimple.SimpleClassProvider getProvider() {
        return this.provider;
    }

    @Trivial
    public Collection<String> getResourceNames() {
        return this.getProvider().getResourceNames();
    }

    @Trivial
    public boolean isProviderResource(String resourceName) {
        Collection<String> useResourceNames = this.getResourceNames();
        if (useResourceNames.contains(resourceName)) {
            return true;
        }
        if (resourceName.length() == 0) {
            return false;
        }
        if (resourceName.charAt(0) == '/') {
            return false;
        }
        return useResourceNames.contains("/" + resourceName);
    }

    @Override
    @Trivial
    public void open() throws ClassSource_Exception {
        String methodName = "open";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] ENTER/RETURN", this.getHashText(), methodName), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public void close() throws ClassSource_Exception {
        String methodName = "close";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] ENTER/RETURN", this.getHashText(), methodName), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void scanClasses(ClassSource_Streamer streamer, Set<String> i_seedClassNames, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        String methodName = "scanClasses";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{MessageFormat.format("[ {0} ] ENTER", this.getHashText())});
        }
        this.startTimings();
        int initialClasses = i_seedClassNames.size();
        for (String nextResourceName : this.provider.getResourceNames()) {
            if (this.isDirectoryResource(nextResourceName)) {
                this.incrementResourceExclusionCount();
                this.markResult(ClassSource_ScanCounts.ResultField.CONTAINER);
                this.markResult(ClassSource_ScanCounts.ResultField.NON_ROOT_CONTAINER);
            } else {
                if (!this.isClassResource(nextResourceName)) {
                    this.incrementResourceExclusionCount();
                    this.markResult(ClassSource_ScanCounts.ResultField.NON_CLASS);
                } else {
                    String nextClassName = this.getClassNameFromResourceName(nextResourceName);
                    String i_nextClassName = this.internClassName(nextClassName);
                    boolean didAdd = this.i_maybeAdd(i_nextClassName, i_seedClassNames);
                    if (!didAdd) {
                        this.incrementClassExclusionCount();
                        this.markResult(ClassSource_ScanCounts.ResultField.DUPLICATE_CLASS);
                    } else {
                        boolean didProcess;
                        this.incrementClassInclusionCount();
                        try {
                            didProcess = this.process(streamer, nextClassName, nextResourceName, scanPolicy);
                        }
                        catch (ClassSource_Exception classSource_Exception) {
                            void e;
                            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedSimple", (String)"279", (Object)this, (Object[])new Object[]{streamer, i_seedClassNames, scanPolicy});
                            didProcess = false;
                            Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_SCAN_EXCEPTION", (Object[])new Object[]{e});
                        }
                        if (didProcess) {
                            this.markResult(ClassSource_ScanCounts.ResultField.PROCESSED_CLASS);
                        } else {
                            this.markResult(ClassSource_ScanCounts.ResultField.UNPROCESSED_CLASS);
                        }
                    }
                    this.markResult(ClassSource_ScanCounts.ResultField.CLASS);
                }
                this.markResult(ClassSource_ScanCounts.ResultField.NON_CONTAINER);
            }
            this.markResult(ClassSource_ScanCounts.ResultField.ENTRY);
        }
        int finalClasses = i_seedClassNames.size();
        if (tc.isDebugEnabled()) {
            Object[] logParms = new Object[]{this.getHashText(), null, null};
            logParms[1] = finalClasses - initialClasses;
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] Added classes", logParms), (Object[])new Object[0]);
            for (ClassSource_ScanCounts.ResultField resultField : ClassSource_ScanCounts.ResultField.values()) {
                int nextResult = this.getResult(resultField);
                String nextResultTag = resultField.getTag();
                logParms[1] = nextResult;
                logParms[2] = nextResultTag;
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ]  [ {1} ] {2}", logParms), (Object[])new Object[0]);
            }
        }
        this.endTimings();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.getHashText());
        }
    }

    @Override
    public String getClassNameFromResourceName(String resourceName) {
        int endingOffset = resourceName.length() - ".class".length();
        int startingOffset = resourceName.charAt(0) == '/' ? 1 : 0;
        String className = resourceName.substring(startingOffset, endingOffset);
        className = className.replace('/', '.');
        return className;
    }

    protected void startTimings() {
        this.startTime = this.getTime();
        this.streamTime = 0L;
    }

    @Trivial
    protected void addStreamTime(long additionalTime) {
        this.streamTime += additionalTime;
    }

    protected void endTimings() {
        this.endTime = this.getTime();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Start time:  [ {0} ]", this.startTime), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("End time:    [ {0} ]", this.endTime), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Delta time:  [ {0} ]", this.endTime - this.startTime), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Stream time: [ {0} ]", this.streamTime), (Object[])new Object[0]);
        }
    }

    @Trivial
    protected long getTime() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(ClassSource_Streamer streamer, String className, String resourceName, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        if (streamer == null) {
            return true;
        }
        if (!streamer.doProcess(className, scanPolicy)) {
            return false;
        }
        InputStream inputStream = this.openResourceStream(className, resourceName);
        if (inputStream == null) {
            return false;
        }
        try {
            streamer.process(this.getCanonicalName(), className, inputStream, scanPolicy);
        }
        finally {
            this.closeResourceStream(className, resourceName, inputStream);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        InputStream result;
        String methodName = "openResourceStream";
        if (!this.isProviderResource(resourceName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] ENTER/RETURN [ null ]: Provider does not contain [ {2} ]", this.getHashText(), methodName, resourceName), (Object[])new Object[0]);
            }
            return null;
        }
        try {
            long initialTime = this.getTime();
            result = this.getProvider().openResource(resourceName);
            long finalTime = this.getTime();
            this.addStreamTime(finalTime - initialTime);
        }
        catch (Throwable initialTime) {
            void th;
            FFDCFilter.processException((Throwable)initialTime, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedSimple", (String)"529", (Object)this, (Object[])new Object[]{className, resourceName});
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + resourceName + " ] for class [ " + className + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)th);
        }
        if (result == null) {
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + resourceName + " ] for class [ " + className + " ]";
            throw this.getFactory().newClassSourceException(eMsg);
        }
        return result;
    }

    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedSimple", (String)"565", (Object)this, (Object[])new Object[]{className, resourceName, inputStream});
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_CLOSE3_EXCEPTION", (Object[])new Object[]{this.getHashText(), resourceName, null, null, className});
        }
    }

    @Override
    @Trivial
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Class Source [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }
}

